/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.forgeevents.trackers;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sleys.lazyutilities.core.config.ElementsModuleConfig;
import sleys.lazyutilities.modules.elements.registry.ElementsList;
import sleys.lazyutilities.modules.elements.utilities.elemental.ElementalDealer;

@Mod.EventBusSubscriber(modid="lzm_elements", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CryoTrackerEvent {
    private static final int REQUIRED_TICKS = 6000;
    private static final int REQUIRED_ALTITUDE = 150;

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        boolean inHighAltitude;
        if (!ElementsModuleConfig.isAllowElementsInEnvironment()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        Level level = entity.m_9236_();
        BlockPos pos = entity.m_20183_();
        if (level.f_46443_) {
            return;
        }
        MobEffect effect = (MobEffect)ElementsList.CRYO.get();
        int duration = 500;
        if (level.m_8055_(pos).m_60713_(Blocks.f_152499_)) {
            ElementalDealer.applyElement(entity, effect, duration);
            return;
        }
        Biome biome = (Biome)level.m_204166_(pos).m_203334_();
        ResourceKey biomeKey = level.m_9598_().m_175515_(Registries.f_256952_).m_7854_((Object)biome).orElse(null);
        boolean inColdBiome = biomeKey == Biomes.f_186761_ || biomeKey == Biomes.f_186756_ || biomeKey == Biomes.f_48182_;
        boolean inSnowStorm = level.m_46470_() && level.m_45527_(pos) && inColdBiome;
        boolean bl = inHighAltitude = pos.m_123342_() >= 150;
        if (inSnowStorm) {
            ElementalDealer.applyElement(entity, effect, duration);
            return;
        }
        entity.getPersistentData().m_128405_("CryoCounter", entity.getPersistentData().m_128451_("CryoCounter") + 1);
        if (inColdBiome || inHighAltitude) {
            if (entity.getPersistentData().m_128451_("CryoCounter") >= 6000) {
                ElementalDealer.applyElement(entity, effect, duration);
                entity.getPersistentData().m_128405_("CryoCounter", 0);
            }
        } else {
            entity.getPersistentData().m_128405_("CryoCounter", 0);
        }
    }
}

