/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.effects;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.network.PacketDistributor;
import sleys.lazyutilities.core.utilities.network.STCTextParticlePacket;
import sleys.lazyutilities.modules.elements.LZElementsMod;
import sleys.lazyutilities.modules.elements.client.particle.TextParticleHandler;
import sleys.lazyutilities.modules.elements.combat.cooldowns.ICD;
import sleys.lazyutilities.modules.elements.combat.damage.ElementsDamageEffect;
import sleys.lazyutilities.modules.elements.combat.damage.ElementsDamageType;
import sleys.lazyutilities.modules.elements.combat.handlers.ElementalDamageDealerHandler;
import sleys.lazyutilities.modules.elements.utilities.math.TextParticleMath;

public class Vaporized
extends MobEffect {
    public Vaporized() {
        super(MobEffectCategory.NEUTRAL, -1);
    }

    public boolean m_8093_() {
        return true;
    }

    public List<ItemStack> getCurativeItems() {
        return new ArrayList<ItemStack>();
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6385_(entity, attributeMap, amplifier);
        CompoundTag tag = entity.getPersistentData();
        ElementalDamageDealerHandler.ElementalResult elementalData = ICD.getStoredElementalData(entity);
        float ExecutionDamage = elementalData.damageValue();
        tag.m_128350_("Vaporizado_Damage", ExecutionDamage);
        if (tag.m_128441_("ElementalPrimerizo") || tag.m_128441_("ElementoPrimerizoUsado")) {
            String elemento = tag.m_128441_("ElementalPrimerizo") ? tag.m_128461_("ElementalPrimerizo") : tag.m_128461_("ElementoPrimerizoUsado");
            Level level = entity.m_9236_();
            Vec3 pos = TextParticleMath.getRandomEdgePosition(entity);
            MutableComponent translated = Component.m_237115_((String)"effect.text.vaporized");
            int color = 16113331;
            switch (elemento) {
                case "HYDRO": {
                    color = 12890767;
                    tag.m_128350_("Vaporizado_Damage_Type", 1.0f);
                    break;
                }
                case "PYRO": {
                    color = 16246210;
                    tag.m_128350_("Vaporizado_Damage_Type", 2.0f);
                    break;
                }
            }
            if (!level.m_5776_()) {
                LZElementsMod.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new STCTextParticlePacket(pos.f_82479_, pos.f_82480_, pos.f_82481_, (Component)translated, color, 20));
            } else {
                TextParticleHandler.spawnTextParticle(level, TextParticleMath.getRandomEdgePosition(entity), (Component)translated, color, 20, (Entity)entity);
            }
        }
        tag.m_128473_("ElementoPrimerizoUsado");
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6386_(entity, attributeMap, amplifier);
        CompoundTag tag = entity.getPersistentData();
        if (tag.m_128441_("Vaporizado_Damage")) {
            tag.m_128473_("Vaporizado_Damage");
        }
        if (tag.m_128441_("Vaporizado_Damage_Type")) {
            tag.m_128473_("Vaporizado_Damage_Type");
        }
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        CompoundTag tag = entity.getPersistentData();
        ResourceKey<DamageType> damageType = null;
        float BonusDamage = 1.0f;
        if (tag.m_128441_("Vaporizado_Damage_Type") && tag.m_128457_("Vaporizado_Damage_Type") == 1.0f) {
            damageType = ElementsDamageType.PYRO;
            BonusDamage = 1.25f;
        } else {
            damageType = ElementsDamageType.HYDRO;
        }
        float SourceDamage = tag.m_128441_("Vaporizado_Damage") ? tag.m_128457_("Vaporizado_Damage") : 1.5f;
        float finalDamage = ElementsDamageEffect.applyElementalModifiers(entity, SourceDamage * BonusDamage * 1.45f, damageType);
        DamageSource damageSource = new DamageSource((Holder)entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(damageType));
        entity.m_6469_(damageSource, finalDamage);
        entity.m_21195_((MobEffect)this);
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new IClientMobEffectExtensions(){

            public boolean isVisibleInInventory(MobEffectInstance effect) {
                return false;
            }

            public boolean renderInventoryText(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, GuiGraphics guiGraphics, int x, int y, int blitOffset) {
                return false;
            }

            public boolean isVisibleInGui(MobEffectInstance effect) {
                return false;
            }
        });
    }
}

