/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.effects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.network.PacketDistributor;
import sleys.lazyutilities.core.utilities.network.STCTextParticlePacket;
import sleys.lazyutilities.modules.elements.LZElementsMod;
import sleys.lazyutilities.modules.elements.client.particle.TextParticleHandler;
import sleys.lazyutilities.modules.elements.utilities.math.TextParticleMath;

public class Rooted
extends MobEffect {
    private static final int PARTICLE_EXECUTER = 15;
    private static final Map<UUID, Float> entitySizes = new HashMap<UUID, Float>();
    private static final UUID SPEED_MODIFIER_ID = UUID.fromString("3a1a34b4-4c3b-42d3-bb4f-dcdbb8d7b1f5");

    public Rooted() {
        super(MobEffectCategory.NEUTRAL, -1);
    }

    public List<ItemStack> getCurativeItems() {
        ArrayList<ItemStack> cures = new ArrayList<ItemStack>();
        return cures;
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6385_(entity, attributeMap, amplifier);
        AttributeInstance speedAttribute = entity.m_21051_(Attributes.f_22279_);
        if (speedAttribute != null && speedAttribute.m_22111_(SPEED_MODIFIER_ID) == null) {
            speedAttribute.m_22118_(new AttributeModifier(SPEED_MODIFIER_ID, "enraizado_slow", -0.15, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        MutableComponent translated = Component.m_237115_((String)"effect.text.rooted");
        Level level = entity.m_9236_();
        if (!level.m_5776_()) {
            Vec3 pos = TextParticleMath.getRandomEdgePosition(entity);
            LZElementsMod.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new STCTextParticlePacket(pos.f_82479_, pos.f_82480_, pos.f_82481_, (Component)translated, 5025616, 20));
        } else {
            TextParticleHandler.spawnTextParticle(level, TextParticleMath.getRandomEdgePosition(entity), (Component)translated, 5025616, 20, (Entity)entity);
        }
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6386_(entity, attributeMap, amplifier);
        AttributeInstance speedAttribute = entity.m_21051_(Attributes.f_22279_);
        if (speedAttribute.m_22111_(SPEED_MODIFIER_ID) != null) {
            speedAttribute.m_22120_(SPEED_MODIFIER_ID);
        }
        entitySizes.remove(entity.m_20148_());
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Level level;
        if (entity == null || !((level = entity.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel _level = (ServerLevel)level;
        if (entity.f_19797_ % 15 != 0) {
            return;
        }
        UUID entityId = entity.m_20148_();
        entitySizes.putIfAbsent(entityId, Float.valueOf(entity.m_6972_((Pose)entity.m_20089_()).f_20378_));
        float entityHeight = entitySizes.get(entityId).floatValue();
        RandomSource rand = entity.m_217043_();
        for (int i = 0; i < 5; ++i) {
            double yOffset = entity.m_20186_() + (double)entityHeight / 2.0;
            double randomOffset = entity.m_217043_().m_188500_() * 0.5;
            _level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50493_.m_49966_()), entity.m_20185_(), yOffset, entity.m_20189_(), 2, 0.3, randomOffset, 0.3, 0.005);
        }
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new IClientMobEffectExtensions(){

            public boolean isVisibleInInventory(MobEffectInstance effect) {
                return false;
            }

            public boolean renderInventoryText(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, GuiGraphics guiGraphics, int x, int y, int blitOffset) {
                return false;
            }

            public boolean isVisibleInGui(MobEffectInstance effect) {
                return false;
            }
        });
    }
}

