/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.effects;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.network.PacketDistributor;
import sleys.lazyutilities.core.utilities.network.STCTextParticlePacket;
import sleys.lazyutilities.modules.elements.LZElementsMod;
import sleys.lazyutilities.modules.elements.client.particle.TextParticleHandler;
import sleys.lazyutilities.modules.elements.combat.damage.ElementsDamageTickEffect;
import sleys.lazyutilities.modules.elements.combat.damage.ElementsDamageType;
import sleys.lazyutilities.modules.elements.combat.reactions.ElementalReactions;
import sleys.lazyutilities.modules.elements.combat.reactions.ElementalStatusManager;
import sleys.lazyutilities.modules.elements.utilities.math.TextParticleMath;

public class Pyro
extends MobEffect {
    private static final int DAMAGE_INTERVAL = 20;
    private static final int PARTICLE_EXECUTER = 5;
    private static final Map<UUID, Float> entitySizes = new HashMap<UUID, Float>();

    public Pyro() {
        super(MobEffectCategory.NEUTRAL, -1);
    }

    public List<ItemStack> getCurativeItems() {
        return List.of();
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6385_(entity, attributeMap, amplifier);
        ElementalStatusManager.applyElement(entity, ElementalReactions.Element.PYRO);
        MutableComponent translated = Component.m_237115_((String)"effect.text.pyro");
        Level level = entity.m_9236_();
        if (!level.m_5776_()) {
            Vec3 pos = TextParticleMath.getRandomEdgePosition(entity);
            LZElementsMod.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new STCTextParticlePacket(pos.f_82479_, pos.f_82480_, pos.f_82481_, (Component)translated, 16729344, 20));
        } else {
            TextParticleHandler.spawnTextParticle(level, TextParticleMath.getRandomEdgePosition(entity), (Component)translated, 16729344, 20, (Entity)entity);
        }
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6386_(entity, attributeMap, amplifier);
        CompoundTag tag = entity.getPersistentData();
        String elementalPrimerizo = tag.m_128461_("ElementalPrimerizo");
        if ("PYRO".equals(elementalPrimerizo)) {
            tag.m_128473_("ElementalPrimerizo");
        }
        entitySizes.remove(entity.m_20148_());
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Level level;
        if (entity == null || !((level = entity.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel _level = (ServerLevel)level;
        UUID entityId = entity.m_20148_();
        entitySizes.putIfAbsent(entityId, Float.valueOf(entity.m_6972_((Pose)entity.m_20089_()).f_20378_));
        float entityHeight = entitySizes.get(entityId).floatValue();
        double yOffset = entity.m_20186_() + (double)entityHeight / 2.5;
        if (entity.f_19797_ % 5 == 0) {
            for (int i = 0; i < 1; ++i) {
                _level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, entity.m_20185_() + (ThreadLocalRandom.current().nextDouble() - 0.25) * 0.4, yOffset + ThreadLocalRandom.current().nextDouble(0.1, 0.4), entity.m_20189_() + (ThreadLocalRandom.current().nextDouble() - 0.25) * 0.4, 2, 0.15, 0.25, 0.15, 0.05);
            }
        }
        if (!entity.m_6060_() && entity.f_19797_ % 20 == 0) {
            float modifiedDamage = ElementsDamageTickEffect.applyElementalModifiers(entity, 1.0f, ElementsDamageType.PYRO_TICK);
            DamageSource damageSource = new DamageSource((Holder)entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ElementsDamageType.PYRO_TICK), (Entity)entity);
            entity.m_6469_(damageSource, modifiedDamage);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new IClientMobEffectExtensions(){

            public boolean isVisibleInInventory(MobEffectInstance effect) {
                return false;
            }

            public boolean renderInventoryText(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, GuiGraphics guiGraphics, int x, int y, int blitOffset) {
                return false;
            }

            public boolean isVisibleInGui(MobEffectInstance effect) {
                return false;
            }
        });
    }
}

