/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.effects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;
import sleys.lazyutilities.core.utilities.network.STCTextParticlePacket;
import sleys.lazyutilities.modules.elements.LZElementsMod;
import sleys.lazyutilities.modules.elements.client.particle.TextParticleHandler;
import sleys.lazyutilities.modules.elements.combat.cooldowns.ICD;
import sleys.lazyutilities.modules.elements.combat.damage.ElementsDamageEffect;
import sleys.lazyutilities.modules.elements.combat.damage.ElementsDamageType;
import sleys.lazyutilities.modules.elements.combat.handlers.ElementalDamageDealerHandler;
import sleys.lazyutilities.modules.elements.combat.handlers.ElementalDamageTickScaler;
import sleys.lazyutilities.modules.elements.utilities.math.TextParticleMath;

public class Frozen
extends MobEffect {
    private static final int PARTICLE_EXECUTER = 15;
    private static final Map<UUID, Float> entitySizes = new HashMap<UUID, Float>();

    public Frozen() {
        super(MobEffectCategory.NEUTRAL, -1);
    }

    public boolean m_8093_() {
        return true;
    }

    public List<ItemStack> getCurativeItems() {
        ArrayList<ItemStack> cures = new ArrayList<ItemStack>();
        return cures;
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6385_(entity, attributeMap, amplifier);
        ElementalDamageDealerHandler.ElementalResult elementalData = ICD.getStoredElementalData(entity);
        float ExecutionDamage = ElementalDamageTickScaler.scaleDamage(elementalData.damageValue());
        CompoundTag tag = entity.getPersistentData();
        tag.m_128350_("Congelado_Scaler", ExecutionDamage);
        MutableComponent translated = Component.m_237115_((String)"effect.text.frozen");
        Level level = entity.m_9236_();
        if (!level.m_5776_()) {
            Vec3 pos = TextParticleMath.getRandomEdgePosition(entity);
            LZElementsMod.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new STCTextParticlePacket(pos.f_82479_, pos.f_82480_, pos.f_82481_, (Component)translated, 58879, 20));
        } else {
            TextParticleHandler.spawnTextParticle(level, TextParticleMath.getRandomEdgePosition(entity), (Component)translated, 58879, 20, (Entity)entity);
        }
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6386_(entity, attributeMap, amplifier);
        CompoundTag tag = entity.getPersistentData();
        if (tag.m_128441_("Congelado_Scaler")) {
            tag.m_128473_("Congelado_Scaler");
        }
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Level level;
        if (entity == null || !((level = entity.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel _level = (ServerLevel)level;
        CompoundTag tag = entity.getPersistentData();
        float maxHealth = entity.m_21233_();
        float currentHealth = entity.m_21223_();
        float weaponDamage = tag.m_128441_("Congelado_Scaler") ? tag.m_128457_("Congelado_Scaler") : 1.0f;
        float weaponScalingFactor = Math.max(0.0f, 0.7f - weaponDamage / 40.0f * 0.7f);
        float baseDamage = maxHealth * 0.14f;
        float healthFactor = Math.max(1.0f - currentHealth / maxHealth, 0.0f);
        float damageReduction = Math.min(healthFactor * 0.4f, 0.4f);
        float damageAmount = baseDamage * (1.0f - damageReduction) * (1.0f - weaponScalingFactor);
        if (damageAmount >= 175.0f) {
            damageAmount = 175.0f;
        }
        UUID entityId = entity.m_20148_();
        entitySizes.putIfAbsent(entityId, Float.valueOf(entity.m_6972_((Pose)entity.m_20089_()).f_20378_));
        float entityHeight = entitySizes.get(entityId).floatValue();
        RandomSource rand = entity.m_217043_();
        for (int i = 0; i < 10; ++i) {
            double yOffset = entity.m_20186_() + (double)entityHeight / 2.0;
            double randomOffset = entity.m_217043_().m_188500_() * 0.5;
            _level.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50126_.m_49966_()), entity.m_20185_(), yOffset, entity.m_20189_(), 2, 0.3, randomOffset, 0.3, 0.005);
        }
        float finalDamage = ElementsDamageEffect.applyElementalModifiers(entity, damageAmount, ElementsDamageType.CRYO);
        DamageSource damageSource = new DamageSource((Holder)entity.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(ElementsDamageType.CRYO));
        _level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), Objects.requireNonNull((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.fromNamespaceAndPath((String)"lzm_elements", (String)"elements:congelado"))), SoundSource.MASTER, 1.0f, 1.0f, false);
        entity.m_6469_(damageSource, finalDamage);
        entity.m_21195_((MobEffect)this);
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new IClientMobEffectExtensions(){

            public boolean isVisibleInInventory(MobEffectInstance effect) {
                return false;
            }

            public boolean renderInventoryText(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, GuiGraphics guiGraphics, int x, int y, int blitOffset) {
                return false;
            }

            public boolean isVisibleInGui(MobEffectInstance effect) {
                return false;
            }
        });
    }
}

