/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.effects;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientMobEffectExtensions;
import net.minecraftforge.network.PacketDistributor;
import sleys.lazyutilities.core.utilities.network.STCTextParticlePacket;
import sleys.lazyutilities.modules.elements.LZElementsMod;
import sleys.lazyutilities.modules.elements.client.particle.TextParticleHandler;
import sleys.lazyutilities.modules.elements.registry.ElementsList;
import sleys.lazyutilities.modules.elements.utilities.math.TextParticleMath;

public class Conductor
extends MobEffect {
    private static final int CHECK_INTERVAL = 60;
    private static final double LIGHTNING_CHANCE = 0.1;
    private static final Random random = new Random();

    public Conductor() {
        super(MobEffectCategory.NEUTRAL, -1);
    }

    public List<ItemStack> getCurativeItems() {
        return List.of();
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributeMap, int amplifier) {
        super.m_6385_(entity, attributeMap, amplifier);
        MutableComponent translated = Component.m_237115_((String)"effect.text.conductor");
        Level level = entity.m_9236_();
        if (!level.m_5776_()) {
            Vec3 pos = TextParticleMath.getRandomEdgePosition(entity);
            LZElementsMod.PACKET_HANDLER.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new STCTextParticlePacket(pos.f_82479_, pos.f_82480_, pos.f_82481_, (Component)translated, 8146431, 20));
        } else {
            TextParticleHandler.spawnTextParticle(level, TextParticleMath.getRandomEdgePosition(entity), (Component)translated, 8146431, 20, (Entity)entity);
        }
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        LightningBolt lightning;
        Level level = entity.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (entity.m_21023_((MobEffect)ElementsList.ELECTRO.get()) && entity.f_19797_ % 60 == 0 && random.nextDouble() < 0.1 && (lightning = (LightningBolt)EntityType.f_20465_.m_20615_((Level)serverLevel)) != null) {
            lightning.m_6027_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            serverLevel.m_7967_((Entity)lightning);
            entity.m_21195_((MobEffect)this);
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void initializeClient(Consumer<IClientMobEffectExtensions> consumer) {
        consumer.accept(new IClientMobEffectExtensions(){

            public boolean isVisibleInInventory(MobEffectInstance effect) {
                return false;
            }

            public boolean renderInventoryText(MobEffectInstance instance, EffectRenderingInventoryScreen<?> screen, GuiGraphics guiGraphics, int x, int y, int blitOffset) {
                return false;
            }

            public boolean isVisibleInGui(MobEffectInstance effect) {
                return false;
            }
        });
    }
}

