/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.combat.reactions;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sleys.lazyutilities.core.config.ElementsModuleConfig;
import sleys.lazyutilities.modules.elements.LZElementsMod;
import sleys.lazyutilities.modules.elements.combat.reactions.ElementalReactions;
import sleys.lazyutilities.modules.elements.registry.ElementsList;

public class ElementalStatusManager {
    public static final Logger LOGGER = LogManager.getLogger(LZElementsMod.class);
    private static final String ELEMENT_TAG = "ElementalPrimerizo";
    private static final String USED_ELEMENT_TAG = "ElementoPrimerizoUsado";

    public static void applyElement(LivingEntity entity, ElementalReactions.Element element) {
        if (!ElementsModuleConfig.isAllowReactions()) {
            return;
        }
        CompoundTag tag = entity.getPersistentData();
        if (ElementsModuleConfig.isDepurateReactions()) {
            LOGGER.info("[Reactions] Condici\u00f3n preterita: {} -> NBT: {}", (Object)entity.m_7755_().getString(), (Object)tag);
        }
        if (tag.m_128441_(ELEMENT_TAG)) {
            ElementalReactions.Element previous = ElementalReactions.Element.valueOf(tag.m_128461_(ELEMENT_TAG));
            ElementalReactions.Reaction reaction = ElementalReactions.getReaction(previous, element);
            if (reaction != null) {
                if (ElementsModuleConfig.isDepurateReactions()) {
                    LOGGER.info("[Reactions] Se activ\u00f3 la reacci\u00f3n: {}", (Object)reaction.effectSupplier().get().m_19481_());
                }
                ElementalReactions.applyReaction(entity, previous, element);
                if (reaction.resultingElement() != null) {
                    tag.m_128359_(ELEMENT_TAG, reaction.resultingElement().name());
                    if (ElementsModuleConfig.isDepurateReactions()) {
                        LOGGER.info("[Reactions] Elemento cambiado a: {}", (Object)reaction.resultingElement().name());
                    }
                    if (reaction.resultingElement() != previous) {
                        ElementalStatusManager.removeElementEffect(entity, previous);
                    }
                    if (reaction.resultingElement() != element) {
                        ElementalStatusManager.removeElementEffect(entity, element);
                    }
                } else {
                    ElementalStatusManager.removeElementEffect(entity, previous);
                    ElementalStatusManager.removeElementEffect(entity, element);
                    Object usedElements = tag.m_128461_(USED_ELEMENT_TAG);
                    if (!((String)usedElements).isEmpty()) {
                        usedElements = (String)usedElements + ",";
                    }
                    usedElements = (String)usedElements + tag.m_128461_(ELEMENT_TAG);
                    tag.m_128359_(USED_ELEMENT_TAG, (String)usedElements);
                    tag.m_128473_(ELEMENT_TAG);
                    if (ElementsModuleConfig.isDepurateReactions()) {
                        LOGGER.info("[Reactions] Elemento marcado como usado y movido a 'ElementoPrimerizoUsado'.");
                    }
                }
            }
        } else {
            tag.m_128359_(ELEMENT_TAG, element.name());
            if (ElementsModuleConfig.isDepurateReactions()) {
                LOGGER.info("[Reactions] Elemento asignado: {}", (Object)element.name());
            }
        }
        if (ElementsModuleConfig.isDepurateReactions()) {
            LOGGER.info("[Reactions] Condici\u00f3n actual: {} -> NBT: {}", (Object)entity.m_7755_().getString(), (Object)tag);
        }
    }

    private static void removeElementEffect(LivingEntity entity, ElementalReactions.Element element) {
        MobEffect effect = ElementalStatusManager.getEffectForElement(element);
        if (effect != null) {
            entity.m_21195_(effect);
            if (ElementsModuleConfig.isDepurateReactions()) {
                LOGGER.info("[Reactions] Eliminado efecto: {}", (Object)effect.m_19481_());
            }
        }
    }

    private static MobEffect getEffectForElement(ElementalReactions.Element element) {
        return switch (element) {
            case ElementalReactions.Element.PYRO -> (MobEffect)ElementsList.PYRO.get();
            case ElementalReactions.Element.HYDRO -> (MobEffect)ElementsList.HYDRO.get();
            case ElementalReactions.Element.GEO -> (MobEffect)ElementsList.GEO.get();
            case ElementalReactions.Element.CRYO -> (MobEffect)ElementsList.CRYO.get();
            case ElementalReactions.Element.ELECTRO -> (MobEffect)ElementsList.ELECTRO.get();
            default -> null;
        };
    }
}

