/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.combat.reactions;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sleys.lazyutilities.core.config.ElementsModuleConfig;
import sleys.lazyutilities.modules.elements.LZElementsMod;
import sleys.lazyutilities.modules.elements.combat.cooldowns.ERCS;
import sleys.lazyutilities.modules.elements.combat.cooldowns.ERGCS;
import sleys.lazyutilities.modules.elements.registry.ElementsList;

public class ElementalReactions {
    public static final Logger LOGGER = LogManager.getLogger(LZElementsMod.class);
    static int INSTA_REACTION = 10;
    static int NO_RETURN = 0;
    public static final Map<Element, Map<Element, Reaction>> REACTIONS = new HashMap<Element, Map<Element, Reaction>>();

    public static void applyReaction(LivingEntity entity, Element first, Element second) {
        Reaction reaction = ElementalReactions.getReaction(first, second);
        if (reaction != null) {
            UUID entityId = entity.m_20148_();
            if (!ERGCS.isBlocked(entityId) && !entity.m_21023_((MobEffect)ElementsList.REACTIONS_SHIELD.get())) {
                if (ERCS.canReact(entityId, reaction)) {
                    entity.m_7292_(reaction.createEffectInstance(reaction.reactionDuration));
                    if (reaction.resultingElement != null) {
                        entity.m_7292_(reaction.createEffectInstance(reaction.resultingElementDuration));
                    }
                    if (ElementsModuleConfig.isDepurateReactions()) {
                        LOGGER.info("[Reactions Matrix] Aplicando reacci\u00f3n: {} + {} -> {} con duraci\u00f3n de reacci\u00f3n: {} y duraci\u00f3n del elemento resultante: {}", (Object)first, (Object)second, (Object)reaction.effectSupplier.get().m_19481_(), (Object)reaction.reactionDuration, (Object)reaction.resultingElementDuration);
                    }
                    ERCS.applyCooldown(entityId, reaction);
                    ERGCS.addReaction(entityId, reaction);
                } else if (ElementsModuleConfig.isDepurateReactions()) {
                    LOGGER.info("[Reactions Matrix] Reacci\u00f3n en cooldown: {} + {}", (Object)first, (Object)second);
                }
            } else {
                if (ElementsModuleConfig.isDepurateReactions()) {
                    LOGGER.info("[Reactions Matrix] En Cooldown Global");
                    LOGGER.info("[Reactions Matrix] Condici\u00f3n de cooldown global: {}", (Object)ERGCS.ergcs_globalCooldowns.getOrDefault(entityId, 0));
                }
                if (!entity.m_21023_((MobEffect)ElementsList.REACTIONS_SHIELD.get())) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)ElementsList.REACTIONS_SHIELD.get(), 400, 0, false, true, false));
                }
            }
        }
    }

    public static Reaction getReaction(Element first, Element second) {
        return (Reaction)REACTIONS.getOrDefault((Object)first, Map.of()).get((Object)second);
    }

    static {
        REACTIONS.put(Element.PYRO, Map.of(Element.HYDRO, new Reaction((Supplier<MobEffect>)ElementsList.VAPORIZED, Element.HYDRO, INSTA_REACTION, 100), Element.GEO, new Reaction((Supplier<MobEffect>)ElementsList.BURNING, Element.PYRO, 140, 60), Element.CRYO, new Reaction((Supplier<MobEffect>)ElementsList.MELTED, null, INSTA_REACTION, NO_RETURN), Element.ELECTRO, new Reaction((Supplier<MobEffect>)ElementsList.OVERLOAD, null, INSTA_REACTION, NO_RETURN)));
        REACTIONS.put(Element.HYDRO, Map.of(Element.PYRO, new Reaction((Supplier<MobEffect>)ElementsList.VAPORIZED, null, INSTA_REACTION, NO_RETURN), Element.GEO, new Reaction((Supplier<MobEffect>)ElementsList.ROOTED, null, 200, NO_RETURN), Element.CRYO, new Reaction((Supplier<MobEffect>)ElementsList.FROZEN, Element.CRYO, INSTA_REACTION, 100), Element.ELECTRO, new Reaction((Supplier<MobEffect>)ElementsList.ELECTROCHARGED, Element.ELECTRO, 260, 160)));
        REACTIONS.put(Element.GEO, Map.of(Element.PYRO, new Reaction((Supplier<MobEffect>)ElementsList.BURNING, null, 180, NO_RETURN), Element.HYDRO, new Reaction((Supplier<MobEffect>)ElementsList.ROOTED, null, 260, NO_RETURN), Element.CRYO, new Reaction((Supplier<MobEffect>)ElementsList.COLD, null, 200, NO_RETURN), Element.ELECTRO, new Reaction((Supplier<MobEffect>)ElementsList.CONDUCTOR, null, 220, NO_RETURN)));
        REACTIONS.put(Element.CRYO, Map.of(Element.PYRO, new Reaction((Supplier<MobEffect>)ElementsList.MELTED, Element.PYRO, INSTA_REACTION, 60), Element.HYDRO, new Reaction((Supplier<MobEffect>)ElementsList.FROZEN, Element.CRYO, INSTA_REACTION, 100), Element.GEO, new Reaction((Supplier<MobEffect>)ElementsList.COLD, Element.CRYO, 180, 100), Element.ELECTRO, new Reaction((Supplier<MobEffect>)ElementsList.SUPERCONDUCTOR, null, 220, NO_RETURN)));
        REACTIONS.put(Element.ELECTRO, Map.of(Element.PYRO, new Reaction((Supplier<MobEffect>)ElementsList.OVERLOAD, null, INSTA_REACTION, NO_RETURN), Element.HYDRO, new Reaction((Supplier<MobEffect>)ElementsList.ELECTROCHARGED, Element.ELECTRO, 260, 160), Element.GEO, new Reaction((Supplier<MobEffect>)ElementsList.CONDUCTOR, null, 220, NO_RETURN), Element.CRYO, new Reaction((Supplier<MobEffect>)ElementsList.SUPERCONDUCTOR, null, 220, NO_RETURN)));
    }

    public static enum Element {
        PYRO,
        HYDRO,
        GEO,
        CRYO,
        ELECTRO;

    }

    public record Reaction(Supplier<MobEffect> effectSupplier, Element resultingElement, int reactionDuration, int resultingElementDuration) {
        public MobEffectInstance createEffectInstance(int duration) {
            MobEffect effect = this.effectSupplier.get();
            return new MobEffectInstance(effect, duration);
        }
    }
}

