/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.combat.handlers;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sleys.lazyutilities.core.config.ElementsModuleConfig;
import sleys.lazyutilities.modules.elements.LZElementsMod;
import sleys.lazyutilities.modules.elements.combat.cooldowns.ICD;
import sleys.lazyutilities.modules.elements.combat.damage.ElementsDamageEffect;
import sleys.lazyutilities.modules.elements.combat.damage.ElementsDamageType;
import sleys.lazyutilities.modules.elements.registry.ElementsList;

@Mod.EventBusSubscriber
public class ElementalDamageHandler {
    public static final Logger LOGGER = LogManager.getLogger(LZElementsMod.class);
    public static final String ElementNoICDAttack = "elements.icd_keys.no_use_icd";
    private static final Set<LivingHurtEvent> processedEvents = Collections.newSetFromMap(new WeakHashMap());

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLivingHurt(LivingHurtEvent event) {
        if (processedEvents.contains(event)) {
            return;
        }
        if (!(event.getSource().m_7639_() instanceof Player) && !(event.getSource().m_7639_() instanceof Mob)) {
            return;
        }
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        processedEvents.add(event);
        LivingEntity target = event.getEntity();
        LivingEntity attacker = (LivingEntity)event.getSource().m_7639_();
        ItemStack weapon = attacker.m_21205_();
        ResourceKey<DamageType> element = ElementalDamageHandler.getElementalDamage(weapon);
        if (element == null) {
            return;
        }
        float baseDamage = event.getAmount();
        float modifiedDamage = ElementsDamageEffect.applyElementalModifiers(target, baseDamage, element);
        event.setAmount(modifiedDamage);
        if (!attacker.getPersistentData().m_128471_(ElementNoICDAttack)) {
            MobEffect elementEffect = ElementalDamageHandler.getElementalEffect(weapon);
            ICD.applyElementalEffect(attacker, target, weapon, elementEffect);
        }
        if (ElementsModuleConfig.isDepurateEDS()) {
            LOGGER.info("[EDS] Evento capturado: datos actuales -> \nDa\u00f1o original: {}, Final: {}, Elemento: {}, Source: {}", (Object)Float.valueOf(baseDamage), (Object)Float.valueOf(modifiedDamage), element, (Object)event.getSource().m_19385_());
        }
    }

    public static ResourceKey<DamageType> getElementalDamage(ItemStack weapon) {
        if (weapon.m_41782_() && weapon.m_41783_().m_128425_("Tags", 9)) {
            ListTag tags = weapon.m_41783_().m_128437_("Tags", 8);
            for (int i = 0; i < tags.size(); ++i) {
                String tag;
                switch (tag = tags.m_128778_(i)) {
                    case "elements:pyro": {
                        return ElementsDamageType.PYRO;
                    }
                    case "elements:hydro": {
                        return ElementsDamageType.HYDRO;
                    }
                    case "elements:electro": {
                        return ElementsDamageType.ELECTRO;
                    }
                    case "elements:cryo": {
                        return ElementsDamageType.CRYO;
                    }
                    case "elements:geo": {
                        return ElementsDamageType.GEO;
                    }
                }
            }
        }
        return null;
    }

    public static MobEffect getElementalEffect(ItemStack weapon) {
        if (weapon.m_41782_() && weapon.m_41783_().m_128425_("Tags", 9)) {
            ListTag tags = weapon.m_41783_().m_128437_("Tags", 8);
            for (int i = 0; i < tags.size(); ++i) {
                String tag;
                switch (tag = tags.m_128778_(i)) {
                    case "elements:pyro": {
                        return (MobEffect)ElementsList.PYRO.get();
                    }
                    case "elements:hydro": {
                        return (MobEffect)ElementsList.HYDRO.get();
                    }
                    case "elements:electro": {
                        return (MobEffect)ElementsList.ELECTRO.get();
                    }
                    case "elements:cryo": {
                        return (MobEffect)ElementsList.CRYO.get();
                    }
                    case "elements:geo": {
                        return (MobEffect)ElementsList.GEO.get();
                    }
                }
            }
        }
        return null;
    }

    public static Component getElementalTooltip(ItemStack weapon) {
        ListTag tags;
        int i;
        if (weapon.m_41782_() && weapon.m_41783_().m_128425_("Tags", 9) && (i = 0) < (tags = weapon.m_41783_().m_128437_("Tags", 8)).size()) {
            String tag;
            return switch (tag = tags.m_128778_(i)) {
                case "elements:pyro" -> Component.m_237113_((String)"Pyro").m_130940_(ChatFormatting.RED);
                case "elements:hydro" -> Component.m_237113_((String)"Hydro").m_130940_(ChatFormatting.BLUE);
                case "elements:electro" -> Component.m_237113_((String)"Electro").m_130940_(ChatFormatting.DARK_PURPLE);
                case "elements:cryo" -> Component.m_237113_((String)"Cryo").m_130940_(ChatFormatting.AQUA);
                case "elements:geo" -> Component.m_237113_((String)"Geo").m_130940_(ChatFormatting.GOLD);
                default -> null;
            };
        }
        return Component.m_237113_((String)"Physical").m_130940_(ChatFormatting.GRAY);
    }
}

