/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.combat.handlers;

import com.google.common.collect.Multimap;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sleys.lazyutilities.modules.elements.LZElementsMod;

public class ElementalDamageDealerHandler {
    public static final Logger LOGGER = LogManager.getLogger(LZElementsMod.class);

    public static ElementalResult getElementalDamage(LivingEntity entity) {
        ItemStack mainHand = entity.m_21205_();
        ItemStack offHand = entity.m_21206_();
        ElementalData mainHandData = ElementalDamageDealerHandler.getElementalData(mainHand, EquipmentSlot.MAINHAND);
        ElementalData offHandData = ElementalDamageDealerHandler.getElementalData(offHand, EquipmentSlot.OFFHAND);
        boolean validWeapon = mainHandData.valid || offHandData.valid;
        float damageValue = ElementalDamageDealerHandler.getDamageValue(validWeapon, mainHandData, offHandData);
        return new ElementalResult(mainHandData.element, offHandData.element, damageValue, validWeapon);
    }

    private static float getDamageValue(boolean validWeapon, ElementalData mainHandData, ElementalData offHandData) {
        float damageValue = validWeapon ? (mainHandData.valid && offHandData.valid ? mainHandData.damage * 0.65f + offHandData.damage * 0.65f : (mainHandData.valid ? mainHandData.damage : offHandData.damage)) : 1.0f;
        return damageValue;
    }

    private static ElementalData getElementalData(ItemStack weapon, EquipmentSlot slot) {
        if (weapon.m_41619_()) {
            return new ElementalData("Invalid", 1.0f, false);
        }
        String element = ElementalDamageDealerHandler.getElementalValue(weapon);
        float damage = ElementalDamageDealerHandler.getAttackDamage(weapon, slot);
        boolean valid = damage > 2.0f;
        return new ElementalData(element, damage, valid);
    }

    public static String getElementalValue(ItemStack weapon) {
        if (weapon.m_41782_() && weapon.m_41783_().m_128425_("Tags", 9)) {
            ListTag tags = weapon.m_41783_().m_128437_("Tags", 8);
            for (int i = 0; i < tags.size(); ++i) {
                String tag;
                switch (tag = tags.m_128778_(i)) {
                    case "elements:pyro": {
                        return "Pyro";
                    }
                    case "elements:hydro": {
                        return "Hydro";
                    }
                    case "elements:electro": {
                        return "Electro";
                    }
                    case "elements:cryo": {
                        return "Cryo";
                    }
                    case "elements:geo": {
                        return "Geo";
                    }
                }
            }
        }
        return "Invalid";
    }

    public static float getAttackDamage(ItemStack stack, EquipmentSlot slot) {
        if (stack.m_41619_()) {
            return 0.0f;
        }
        Multimap modifiers = stack.m_41638_(slot);
        for (AttributeModifier modifier : modifiers.get((Object)Attributes.f_22281_)) {
            if (modifier == null) continue;
            return (float)modifier.m_22218_() + 1.0f;
        }
        return 0.0f;
    }

    private record ElementalData(String element, float damage, boolean valid) {
    }

    public record ElementalResult(String elementMainHand, String elementOffHand, float damageValue, boolean validWeapon) {
    }
}

