/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.combat.damage;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import sleys.lazyutilities.modules.elements.combat.damage.ElementsDamageType;
import sleys.lazyutilities.modules.elements.registry.ElementsList;

public class ElementsDamageEffect {
    public static float applyElementalModifiers(LivingEntity entity, float baseDamage, @NotNull ResourceKey<DamageType> damageType) {
        if (damageType.equals(ElementsDamageType.PYRO)) {
            float MAX_ARMOR = 30.0f;
            float armorValue = entity.m_21230_();
            if (armorValue <= 20.0f) {
                float missingArmorFactor = Math.max(0.0f, (20.0f - armorValue) / 20.0f);
                float bonusDamage = missingArmorFactor * 0.3f;
                return baseDamage * (1.0f + bonusDamage);
            }
            float reductionFactor = 1.0f - Math.min((armorValue - 20.0f) / 10.0f, 0.1f);
            return baseDamage * reductionFactor;
        }
        if (damageType.equals(ElementsDamageType.HYDRO)) {
            float maxHealth = entity.m_21233_();
            float currentHealth = entity.m_21223_();
            float maxHealthFactor = maxHealth >= 10.0f && maxHealth <= 50.0f ? (float)(0.25 * Math.pow(10.0f / maxHealth, 0.8)) : (maxHealth >= 50.0f && maxHealth <= 80.0f ? (float)(0.25 * Math.pow(10.0f / maxHealth, 1.0)) : (maxHealth >= 80.0f ? 0.0f : 0.25f));
            if (maxHealth < 10.0f) {
                maxHealthFactor += 0.1f;
            }
            float healthFactor = -0.15f * (1.0f - currentHealth / maxHealth);
            float aerialMultiplier = entity.m_20096_() ? 1.0f : 1.25f;
            return baseDamage * (1.0f + maxHealthFactor + healthFactor) * aerialMultiplier;
        }
        if (damageType.equals(ElementsDamageType.GEO)) {
            float multiplier;
            boolean isOnGround = entity.m_20096_();
            float f = multiplier = isOnGround ? 1.2f : 0.9f;
            if (entity.m_21023_((MobEffect)ElementsList.ROOTED.get())) {
                multiplier += 0.2f;
            }
            return baseDamage * multiplier;
        }
        if (damageType.equals(ElementsDamageType.ELECTRO)) {
            float armorValue = entity.m_21230_();
            float armorFactor = armorValue < 8.0f ? armorValue / 8.0f * 0.1f - 0.1f : Math.min((armorValue - 8.0f) / 22.0f * 0.33f, 0.33f);
            float multiplier = entity.m_21023_((MobEffect)ElementsList.CONDUCTOR.get()) ? 1.2f : 1.0f;
            return baseDamage * multiplier * (1.0f + armorFactor);
        }
        if (damageType.equals(ElementsDamageType.CRYO)) {
            float healthFactor = (float)((double)0.3f * (1.0 - Math.exp(-entity.m_21233_() / 40.0f)));
            float scaledDamage = baseDamage * (1.0f + healthFactor);
            return Math.min(scaledDamage, baseDamage * 1.3f);
        }
        return baseDamage;
    }
}

