/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.combat.cooldowns;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sleys.lazyutilities.core.config.ElementsModuleConfig;
import sleys.lazyutilities.core.utilities.logic.PlayerLogicUtilities;
import sleys.lazyutilities.modules.elements.LZElementsMod;
import sleys.lazyutilities.modules.elements.combat.handlers.ElementalDamageDealerHandler;
import sleys.lazyutilities.modules.elements.registry.ElementsList;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;

public class ICD {
    public static final Logger LOGGER = LogManager.getLogger(LZElementsMod.class);
    private static final int MAX_ENTRIES = 1000;
    private static final int TIME_THRESHOLD = 50;
    private static final int MAX_IDLE_TICKS = 200;
    private static final Map<UUID, CooldownData> icdMap = new LinkedHashMap<UUID, CooldownData>(1000, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<UUID, CooldownData> eldest) {
            return this.size() > 1000;
        }
    };

    public static void applyElementalEffect(LivingEntity attacker, LivingEntity target, ItemStack weapon, MobEffect elementEffect) {
        ElementalDamageDealerHandler.ElementalResult result = ElementalDamageDealerHandler.getElementalDamage(attacker);
        UUID targetId = target.m_20148_();
        long currentTime = attacker.m_9236_().m_46467_();
        CooldownData data = icdMap.computeIfAbsent(targetId, k -> new CooldownData());
        if (LZElementsMod.isEpicFight12 && ICD.isUsingEpicFightSkill(attacker)) {
            System.out.println("Innate-Elemental Skill");
            ICD.applyEffect(target, weapon, elementEffect, result);
            data.reset(currentTime);
            return;
        }
        if (data.lastHitTime == 0L || currentTime - data.lastHitTime >= 50L) {
            ICD.applyEffect(target, weapon, elementEffect, result);
            data.reset(currentTime);
            return;
        }
        ++data.hits;
        if (data.hits >= 4) {
            ICD.applyEffect(target, weapon, elementEffect, result);
            data.hits = 0;
        }
    }

    private static void applyEffect(LivingEntity target, ItemStack weapon, MobEffect elementEffect, ElementalDamageDealerHandler.ElementalResult result) {
        if (elementEffect == null) {
            return;
        }
        ICD.saveElementalData(target, result);
        if (ElementsModuleConfig.isDepurateICD()) {
            LOGGER.debug("Datos elementales: MainHand={}, OffHand={}, Damage={}, Objetivo: {}", (Object)result.elementMainHand(), (Object)result.elementOffHand(), (Object)Float.valueOf(result.damageValue()), (Object)target);
        }
        if (elementEffect == ElementsList.PYRO.get()) {
            target.m_7292_(new MobEffectInstance(elementEffect, 120, 0, false, false, false));
        }
        if (elementEffect == ElementsList.HYDRO.get()) {
            target.m_7292_(new MobEffectInstance(elementEffect, 105, 0, false, false, false));
        }
        if (elementEffect == ElementsList.GEO.get()) {
            target.m_7292_(new MobEffectInstance(elementEffect, 140, 0, false, false, false));
        }
        if (elementEffect == ElementsList.ELECTRO.get()) {
            target.m_7292_(new MobEffectInstance(elementEffect, 80, 0, false, false, false));
        }
        if (elementEffect == ElementsList.CRYO.get()) {
            target.m_7292_(new MobEffectInstance(elementEffect, 105, 0, false, false, false));
        }
    }

    private static void saveElementalData(LivingEntity target, ElementalDamageDealerHandler.ElementalResult result) {
        if (target == null) {
            LOGGER.error("[ICD] Error: Se intento guardar datos elementales en una entidad, pero no existe; retornando");
            return;
        }
        if (result == null) {
            LOGGER.error("[ICD] Error: Se intento guardar datos elementales en una entidad, pero no existen datos; retornando");
            return;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("MainHand", result.elementMainHand() != null ? result.elementMainHand() : "NULO");
        tag.m_128359_("OffHand", result.elementOffHand() != null ? result.elementOffHand() : "NULO");
        tag.m_128350_("Damage", result.damageValue());
        tag.m_128379_("ValidWeapon", result.validWeapon());
        try {
            target.getPersistentData().m_128365_("ICD_Data", (Tag)tag);
        }
        catch (Exception e) {
            LOGGER.error("[ICD] Ocurrio un error a la hora de guardar los datos en la entidad: ", (Throwable)e);
        }
    }

    public static ElementalDamageDealerHandler.ElementalResult getStoredElementalData(LivingEntity target) {
        CompoundTag tag = target.getPersistentData().m_128469_("ICD_Data");
        if (tag.m_128456_()) {
            return null;
        }
        return new ElementalDamageDealerHandler.ElementalResult(tag.m_128461_("MainHand"), tag.m_128461_("OffHand"), tag.m_128457_("Damage"), tag.m_128471_("ValidWeapon"));
    }

    private static boolean isUsingEpicFightSkill(LivingEntity entity) {
        if (entity instanceof Player) {
            PlayerPatch playerPatch;
            EpicFightDamageSource epicSource;
            Player player = (Player)entity;
            DamageSource damageSource = entity.m_269291_().m_269075_(player);
            if (damageSource instanceof EpicFightDamageSource && (epicSource = (EpicFightDamageSource)damageSource).m_269533_(EpicFightDamageTypeTags.WEAPON_INNATE) && PlayerLogicUtilities.isValidPatchedPlayer(playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class))) {
                DynamicAnimation actuallyAnimation = (DynamicAnimation)playerPatch.getServerAnimator().animationPlayer.getAnimation().get();
                return actuallyAnimation instanceof AttackAnimation;
            }
        }
        return false;
    }

    public static void cleanup() {
        long currentTime = System.currentTimeMillis();
        icdMap.entrySet().removeIf(entry -> currentTime - ((CooldownData)entry.getValue()).lastHitTime > 200L);
    }

    private static class CooldownData {
        long lastHitTime = 0L;
        int hits = 0;

        private CooldownData() {
        }

        void reset(long currentTime) {
            this.lastHitTime = currentTime;
            this.hits = 1;
        }
    }
}

