/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.combat.cooldowns;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sleys.lazyutilities.core.config.ElementsModuleConfig;
import sleys.lazyutilities.modules.elements.LZElementsMod;
import sleys.lazyutilities.modules.elements.combat.reactions.ElementalReactions;

public class ERCS {
    private static final Logger LOGGER = LogManager.getLogger(LZElementsMod.class);
    private static final Map<UUID, Map<ElementalReactions.Reaction, Long>> ercs_cooldowns = new HashMap<UUID, Map<ElementalReactions.Reaction, Long>>();
    private static final Map<ElementalReactions.Reaction, Integer> reactionCooldowns = new HashMap<ElementalReactions.Reaction, Integer>();

    public static boolean canReact(UUID entityId, ElementalReactions.Reaction reaction) {
        Map entityCooldowns = ercs_cooldowns.getOrDefault(entityId, new HashMap());
        long currentTime = System.currentTimeMillis();
        return !entityCooldowns.containsKey(reaction) || (Long)entityCooldowns.get(reaction) <= currentTime;
    }

    public static void applyCooldown(UUID entityId, ElementalReactions.Reaction reaction) {
        int cooldown = reactionCooldowns.getOrDefault(reaction, 100);
        long expireTime = System.currentTimeMillis() + (long)cooldown;
        ercs_cooldowns.computeIfAbsent(entityId, k -> new HashMap()).put(reaction, expireTime);
        if (ElementsModuleConfig.isDepurateERCS()) {
            LOGGER.info("[ERCS] Cooldown aplicado: " + reaction.effectSupplier().get().m_19481_() + " hasta " + expireTime + " (Duraci\u00f3n: " + cooldown + "ms)");
        }
    }

    static {
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.PYRO).get((Object)ElementalReactions.Element.CRYO), 925);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.CRYO).get((Object)ElementalReactions.Element.PYRO), 850);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.ELECTRO).get((Object)ElementalReactions.Element.PYRO), 420);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.PYRO).get((Object)ElementalReactions.Element.ELECTRO), 420);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.PYRO).get((Object)ElementalReactions.Element.HYDRO), 580);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.HYDRO).get((Object)ElementalReactions.Element.PYRO), 605);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.CRYO).get((Object)ElementalReactions.Element.HYDRO), 1200);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.HYDRO).get((Object)ElementalReactions.Element.CRYO), 1200);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.ELECTRO).get((Object)ElementalReactions.Element.HYDRO), 300);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.HYDRO).get((Object)ElementalReactions.Element.ELECTRO), 300);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.CRYO).get((Object)ElementalReactions.Element.GEO), 315);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.GEO).get((Object)ElementalReactions.Element.CRYO), 380);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.PYRO).get((Object)ElementalReactions.Element.GEO), 315);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.GEO).get((Object)ElementalReactions.Element.PYRO), 335);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.ELECTRO).get((Object)ElementalReactions.Element.GEO), 335);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.GEO).get((Object)ElementalReactions.Element.ELECTRO), 335);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.ELECTRO).get((Object)ElementalReactions.Element.CRYO), 530);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.CRYO).get((Object)ElementalReactions.Element.ELECTRO), 530);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.ELECTRO).get((Object)ElementalReactions.Element.HYDRO), 335);
        reactionCooldowns.put(ElementalReactions.REACTIONS.get((Object)ElementalReactions.Element.HYDRO).get((Object)ElementalReactions.Element.ELECTRO), 335);
    }
}

