/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sleys.lazyutilities.modules.elements.client.particle.TextParticle;

@OnlyIn(value=Dist.CLIENT)
public class TextParticleBuffer {
    private final Queue<TextParticle> particles = new ConcurrentLinkedQueue<TextParticle>();

    public void add(TextParticle particle) {
        this.particles.add(particle);
    }

    public void tick() {
        this.particles.forEach(TextParticle::tick);
        this.particles.removeIf(TextParticle::shouldRemove);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, Camera camera) {
        for (TextParticle particle : this.particles) {
            particle.render(poseStack, bufferSource, camera);
        }
    }
}

