/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.elements.client.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class TextParticle {
    private final Component text;
    private final int color;
    private final int lifetime;
    private int age = 0;
    public final double x;
    public final double y;
    public final double z;
    private final float initialScale;
    private float currentScale;
    @Nullable
    private final Float customScale;

    public TextParticle(ClientLevel level, double x, double y, double z, Component text, int color, int lifetime) {
        this(level, x, y, z, text, color, lifetime, null);
    }

    public TextParticle(ClientLevel level, double x, double y, double z, Component text, int color, int lifetime, @Nullable Float customScale) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.text = text;
        this.color = color;
        this.lifetime = lifetime;
        this.customScale = customScale;
        this.currentScale = this.initialScale = customScale != null ? customScale.floatValue() : 0.5f + level.f_46441_.m_188501_() * 0.5f;
    }

    public void tick() {
        ++this.age;
        this.currentScale *= 0.99f;
    }

    public boolean shouldRemove() {
        return this.age >= this.lifetime;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, Camera camera) {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        Vec3 camPos = camera.m_90583_();
        poseStack.m_85836_();
        poseStack.m_85837_(this.x - camPos.f_82479_, this.y - camPos.f_82480_, this.z - camPos.f_82481_);
        poseStack.m_252781_(camera.m_253121_());
        float scaleFactor = this.currentScale * (1.0f - (float)this.age / (float)this.lifetime);
        poseStack.m_85841_(-0.025f * scaleFactor, -0.025f * scaleFactor, 0.025f * scaleFactor);
        int alpha = (int)((1.0f - (float)this.age / (float)this.lifetime) * 255.0f) << 24;
        int argb = alpha | this.color & 0xFFFFFF;
        font.m_272077_(this.text, 0.0f, 0.0f, argb, true, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.POLYGON_OFFSET, 0, 0xF000F0);
        poseStack.m_85849_();
    }
}

