/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.bettercombat.skills;

import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import sleys.lazyutilities.core.LazyUtilitiesCore;
import sleys.lazyutilities.core.utilities.network.CTSFocalTagSyncSender;
import sleys.lazyutilities.core.utilities.network.STCFocalTagSyncSender;

public class ArmorAbilityTagSyncHandler {
    private final Player player;
    private final LazyUtilitiesCore.ExecutionType type;

    public ArmorAbilityTagSyncHandler(Player player, LazyUtilitiesCore.ExecutionType type) {
        this.player = player;
        this.type = type;
    }

    public CompoundTag getPersistentData() {
        return this.player.getPersistentData();
    }

    public void handleAbility(String tag, boolean inCooldown, Runnable onInitiate, @Nullable Runnable onUpdate, @Nullable Runnable onRemove, @Nullable Runnable onSkillFail, @Nullable Runnable onSkillFailExecution) {
        BiConsumer<String, Boolean> syncSender;
        CompoundTag data = this.getPersistentData();
        boolean activeAbility = data.m_128471_(tag);
        boolean failAbility = data.m_128471_(tag + "_fail");
        boolean failExecutionActive = data.m_128471_(tag + "_fail_execution");
        BiConsumer<String, Boolean> biConsumer = syncSender = this.type == LazyUtilitiesCore.ExecutionType.SERVER ? (name, value) -> STCFocalTagSyncSender.sendBoolean((ServerPlayer)this.player, name, value) : CTSFocalTagSyncSender::sendBoolean;
        if (inCooldown) {
            if (activeAbility) {
                if (onUpdate != null) {
                    onUpdate.run();
                }
            } else {
                data.m_128379_(tag, true);
                syncSender.accept(tag, true);
                onInitiate.run();
            }
            if (failAbility && onSkillFail != null) {
                data.m_128473_(tag + "_fail");
                syncSender.accept(tag + "_fail", false);
                onSkillFail.run();
            }
        } else {
            if (activeAbility) {
                data.m_128473_(tag);
                syncSender.accept(tag, false);
                if (onRemove != null) {
                    onRemove.run();
                }
            }
            if (failExecutionActive && onSkillFailExecution != null) {
                data.m_128473_(tag + "_fail_execution");
                syncSender.accept(tag + "_fail_execution", false);
                onSkillFailExecution.run();
            }
        }
    }
}

