/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.bettercombat.forgeevent;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sleys.lazyutilities.core.config.LazyUtilitiesConfigCommon;
import sleys.lazyutilities.core.utilities.logic.PlayerLogicUtilities;
import sleys.lazyutilities.modules.bettercombat.interfaces.IOnTickPassive;

public class WeaponTickEvent {
    @SubscribeEvent
    public static void onClientWeapon(PassiveClientThread event) {
        ItemStack playerItem = event.player.m_21205_();
        Item item = playerItem.m_41720_();
        if (item instanceof IOnTickPassive) {
            IOnTickPassive interactionType = (IOnTickPassive)item;
            interactionType.clientThread(event, event.player, event.level, event.clientData);
        }
    }

    @SubscribeEvent
    public static void onServerWeapon(PassiveServerThread event) {
        ItemStack playerItem = event.serverPlayer.m_21205_();
        Item item = playerItem.m_41720_();
        if (item instanceof IOnTickPassive) {
            IOnTickPassive interactionType = (IOnTickPassive)item;
            interactionType.serverThread(event, event.serverPlayer, event.serverLevel, event.serverData);
        }
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (LazyUtilitiesConfigCommon.getErrorHandlerBetterCombat() != LazyUtilitiesConfigCommon.ErrorHandler.EXCEPTION) {
            try {
                WeaponTickEvent.onPlayerTickPayload(event);
            }
            catch (Exception exception) {}
        } else {
            WeaponTickEvent.onPlayerTickPayload(event);
        }
    }

    private static void onPlayerTickPayload(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (PlayerLogicUtilities.isValidPlayer(player)) {
            if (event.side.isClient()) {
                MinecraftForge.EVENT_BUS.post((Event)new PassiveClientThread(event));
            }
            if (event.side.isServer()) {
                MinecraftForge.EVENT_BUS.post((Event)new PassiveServerThread(event));
            }
        }
    }

    public static class PassiveClientThread
    extends Event {
        private final Item item;
        private final TickEvent.PlayerTickEvent forgeEvent;
        private final Player player;
        private final Level level;
        private final CompoundTag clientData;

        public PassiveClientThread(TickEvent.PlayerTickEvent forgeEvent) {
            this.forgeEvent = forgeEvent;
            this.player = forgeEvent.player;
            this.item = this.player.m_21205_().m_41720_();
            this.level = this.player.m_9236_();
            this.clientData = this.player.getPersistentData();
        }

        public Player getPlayer() {
            return this.player;
        }

        public Level getLevel() {
            return this.level;
        }

        public CompoundTag getClientData() {
            return this.clientData;
        }

        public Item getItem() {
            return this.item;
        }

        public TickEvent.PlayerTickEvent getForgeEvent() {
            return this.forgeEvent;
        }
    }

    public static class PassiveServerThread
    extends Event {
        private final Item item;
        private final TickEvent.PlayerTickEvent forgeEvent;
        private final ServerLevel serverLevel;
        private final ServerPlayer serverPlayer;
        private final CompoundTag serverData;

        public PassiveServerThread(TickEvent.PlayerTickEvent forgeEvent) {
            this.forgeEvent = forgeEvent;
            this.serverPlayer = (ServerPlayer)forgeEvent.player;
            this.item = this.serverPlayer.m_21205_().m_41720_();
            this.serverData = this.serverPlayer.getPersistentData();
            this.serverLevel = this.serverPlayer.m_284548_();
        }

        public ServerPlayer getServerPlayer() {
            return this.serverPlayer;
        }

        public ServerLevel getServerLevel() {
            return this.serverLevel;
        }

        public CompoundTag getServerData() {
            return this.serverData;
        }

        public Item getItem() {
            return this.item;
        }

        public TickEvent.PlayerTickEvent getForgeEvent() {
            return this.forgeEvent;
        }
    }
}

