/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.modules.bettercombat.forgeevent;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import sleys.lazyutilities.core.config.LazyUtilitiesConfigCommon;
import sleys.lazyutilities.core.utilities.logic.PlayerLogicUtilities;
import sleys.lazyutilities.modules.bettercombat.interfaces.IOnEquipment;

public class WeaponKeyEvent {
    @SubscribeEvent
    public static void onTimeHandEvent(ItemHandEvent event) {
        ItemStack relevantStack;
        Item item;
        Player player = event.getPlayer();
        if (PlayerLogicUtilities.isValidPlayer(player) && (item = (relevantStack = event.getEventType() == ItemHandEvent.EventType.EQUIP ? event.getTo() : event.getFrom()).m_41720_()) instanceof IOnEquipment) {
            IOnEquipment equipment = (IOnEquipment)item;
            CompoundTag data = player.getPersistentData();
            Level level = player.m_9236_();
            if (event.getEventType() == ItemHandEvent.EventType.EQUIP) {
                equipment.onInitiate(event, player, level, data);
            } else {
                equipment.onRemove(event, player, level, data);
            }
        }
    }

    @SubscribeEvent
    public static void onEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        if (LazyUtilitiesConfigCommon.getErrorHandlerBetterCombat() != LazyUtilitiesConfigCommon.ErrorHandler.EXCEPTION) {
            try {
                WeaponKeyEvent.onEquipmentChangePayload(event);
            }
            catch (Exception exception) {}
        } else {
            WeaponKeyEvent.onEquipmentChangePayload(event);
        }
    }

    private static void onEquipmentChangePayload(LivingEquipmentChangeEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && PlayerLogicUtilities.isValidPlayer(player = (Player)livingEntity)) {
            boolean isSwapping;
            EquipmentSlot slot = event.getSlot();
            if (slot != EquipmentSlot.MAINHAND) {
                return;
            }
            ItemStack fromStack = event.getFrom();
            ItemStack toStack = event.getTo();
            boolean isUnequipping = !fromStack.m_41619_() && toStack.m_41619_();
            boolean isEquipping = fromStack.m_41619_() && !toStack.m_41619_();
            boolean bl = isSwapping = !fromStack.m_41619_() && !toStack.m_41619_();
            if (isEquipping) {
                if (toStack.m_41720_() instanceof IOnEquipment) {
                    MinecraftForge.EVENT_BUS.post((Event)new ItemHandEvent(event, player, ItemHandEvent.EventType.EQUIP));
                }
            } else if (isUnequipping) {
                if (fromStack.m_41720_() instanceof IOnEquipment) {
                    MinecraftForge.EVENT_BUS.post((Event)new ItemHandEvent(event, player, ItemHandEvent.EventType.UNEQUIP));
                }
            } else if (isSwapping) {
                boolean itemsAreDifferent;
                boolean bl2 = itemsAreDifferent = !WeaponKeyEvent.areItemsEquivalent(fromStack, toStack);
                if (itemsAreDifferent) {
                    if (fromStack.m_41720_() instanceof IOnEquipment) {
                        MinecraftForge.EVENT_BUS.post((Event)new ItemHandEvent(event, player, ItemHandEvent.EventType.UNEQUIP));
                    }
                    if (toStack.m_41720_() instanceof IOnEquipment) {
                        MinecraftForge.EVENT_BUS.post((Event)new ItemHandEvent(event, player, ItemHandEvent.EventType.EQUIP));
                    }
                }
            }
        }
    }

    private static boolean areItemsEquivalent(ItemStack stackFrom, ItemStack stackTo) {
        if (stackFrom.m_41619_() && stackTo.m_41619_()) {
            return true;
        }
        if (stackFrom.m_41619_() || stackTo.m_41619_()) {
            return false;
        }
        return stackFrom.m_41720_().equals(stackTo.m_41720_());
    }

    public static class ItemHandEvent
    extends Event {
        private final LivingEquipmentChangeEvent forgeEvent;
        @NotNull
        private final ItemStack from;
        @NotNull
        private final ItemStack to;
        private final EquipmentSlot slot;
        private final Player player;
        private final EventType eventType;

        public ItemHandEvent(LivingEquipmentChangeEvent forgeEvent, Player player, EventType eventType) {
            this.forgeEvent = forgeEvent;
            this.from = forgeEvent.getFrom();
            this.to = forgeEvent.getTo();
            this.slot = forgeEvent.getSlot();
            this.player = player;
            this.eventType = eventType;
        }

        public Player getPlayer() {
            return this.player;
        }

        @NotNull
        public ItemStack getFrom() {
            return this.from;
        }

        @NotNull
        public ItemStack getTo() {
            return this.to;
        }

        public EquipmentSlot getSlot() {
            return this.slot;
        }

        public LivingEquipmentChangeEvent getForgeEvent() {
            return this.forgeEvent;
        }

        public EventType getEventType() {
            return this.eventType;
        }

        public static enum EventType {
            EQUIP,
            UNEQUIP;

        }
    }
}

