/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.core.utilities.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;
import sleys.lazyutilities.core.utilities.network.STCTextParticlePacketClient;

public record STCTextParticlePacket(double x, double y, double z, Component text, int color, int lifetime, @Nullable Float scale) {
    public STCTextParticlePacket(double x, double y, double z, Component text, int color, int lifetime) {
        this(x, y, z, text, color, lifetime, null);
    }

    public static void encode(STCTextParticlePacket msg, FriendlyByteBuf buffer) {
        buffer.writeDouble(msg.x);
        buffer.writeDouble(msg.y);
        buffer.writeDouble(msg.z);
        buffer.m_130083_(msg.text);
        buffer.writeInt(msg.color);
        buffer.writeInt(msg.lifetime);
        buffer.writeBoolean(msg.scale != null);
        if (msg.scale != null) {
            buffer.writeFloat(msg.scale.floatValue());
        }
    }

    public static STCTextParticlePacket decode(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        Component text = buffer.m_130238_();
        int color = buffer.readInt();
        int lifetime = buffer.readInt();
        Float scale = buffer.readBoolean() ? Float.valueOf(buffer.readFloat()) : null;
        return new STCTextParticlePacket(x, y, z, text, color, lifetime, scale);
    }

    public static void handle(STCTextParticlePacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> STCTextParticlePacketClient.handleTextParticlePacket(msg.x, msg.y, msg.z, msg.text, msg.color, msg.lifetime, msg.scale));
        ctx.get().setPacketHandled(true);
    }
}

