/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.core.utilities.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import sleys.lazyutilities.core.utilities.network.STCParticlePacketClient;

public record STCParticlePacket(double x, double y, double z, double speedX, double speedY, double speedZ, ParticleOptions particle) {
    public static void encode(STCParticlePacket packet, FriendlyByteBuf buffer) {
        buffer.writeDouble(packet.x);
        buffer.writeDouble(packet.y);
        buffer.writeDouble(packet.z);
        buffer.writeDouble(packet.speedX);
        buffer.writeDouble(packet.speedY);
        buffer.writeDouble(packet.speedZ);
        buffer.m_130085_(Objects.requireNonNull(BuiltInRegistries.f_257034_.m_7981_((Object)packet.particle.m_6012_())));
    }

    public static STCParticlePacket decode(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        double speedX = buffer.readDouble();
        double speedY = buffer.readDouble();
        double speedZ = buffer.readDouble();
        ParticleType particleType = (ParticleType)BuiltInRegistries.f_257034_.m_7745_(buffer.m_130281_());
        ParticleOptions particle = (ParticleOptions)particleType;
        return new STCParticlePacket(x, y, z, speedX, speedY, speedZ, particle);
    }

    public static void handle(STCParticlePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> STCParticlePacketClient.handleParticlePacket(packet.particle, packet.x, packet.y, packet.z, packet.speedX, packet.speedY, packet.speedZ));
        context.setPacketHandled(true);
    }
}

