/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.core.utilities.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public record CTSParticlePacket(double x, double y, double z, double speedX, double speedY, double speedZ, ParticleOptions particle) {
    public static void encode(CTSParticlePacket packet, FriendlyByteBuf buffer) {
        buffer.writeDouble(packet.x);
        buffer.writeDouble(packet.y);
        buffer.writeDouble(packet.z);
        buffer.writeDouble(packet.speedX);
        buffer.writeDouble(packet.speedY);
        buffer.writeDouble(packet.speedZ);
        buffer.m_130085_(Objects.requireNonNull(BuiltInRegistries.f_257034_.m_7981_((Object)packet.particle.m_6012_())));
    }

    public static CTSParticlePacket decode(FriendlyByteBuf buffer) {
        double x = buffer.readDouble();
        double y = buffer.readDouble();
        double z = buffer.readDouble();
        double speedX = buffer.readDouble();
        double speedY = buffer.readDouble();
        double speedZ = buffer.readDouble();
        ParticleType particleType = (ParticleType)BuiltInRegistries.f_257034_.m_7745_(buffer.m_130281_());
        ParticleOptions particle = (ParticleOptions)particleType;
        return new CTSParticlePacket(x, y, z, speedX, speedY, speedZ, particle);
    }

    public static void handle(CTSParticlePacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            ServerLevel level = player.m_284548_();
            level.m_8767_(packet.particle, packet.x, packet.y, packet.z, 1, packet.speedX, packet.speedY, packet.speedZ, 0.0);
        });
        context.setPacketHandled(true);
    }
}

