/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.core.utilities.logic;

import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class PlayerLogicUtilities {
    @Nullable
    public static Player getPlayerEntity(Object socket) {
        if (socket instanceof Player) {
            Player player = (Player)socket;
            return player;
        }
        return null;
    }

    public static boolean isValidPlayer(Player player) {
        return player != null && !player.m_5833_() && !player.m_213877_() && !player.m_21224_() && player.m_6084_();
    }

    public static boolean isValidPatchedPlayer(PlayerPatch<?> patchPlayer) {
        return patchPlayer != null && !((Player)patchPlayer.getOriginal()).m_5833_() && !((Player)patchPlayer.getOriginal()).m_213877_() && !((Player)patchPlayer.getOriginal()).m_21224_() && ((Player)patchPlayer.getOriginal()).m_6084_();
    }

    public static Player safeParametricePlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return null;
        }
        Player player = event.player;
        if (!PlayerLogicUtilities.isValidPlayer(player)) {
            return null;
        }
        return player;
    }

    public static Player safeParametricePlayerTickEvent(TickEvent.ClientTickEvent event, Player player) {
        if (event.phase != TickEvent.Phase.END) {
            return null;
        }
        if (!PlayerLogicUtilities.isValidPlayer(player)) {
            return null;
        }
        return player;
    }

    public static PlayerPatch<?> safeParametricePlayerPatchTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return null;
        }
        Player player = event.player;
        if (!PlayerLogicUtilities.isValidPlayer(player)) {
            return null;
        }
        PlayerPatch patch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        if (!PlayerLogicUtilities.isValidPatchedPlayer(patch)) {
            return null;
        }
        return patch;
    }

    public static PlayerPatch<?> safeParametricePlayerPatchTickEvent(TickEvent.ClientTickEvent event, Player player) {
        if (event.phase != TickEvent.Phase.END) {
            return null;
        }
        if (!PlayerLogicUtilities.isValidPlayer(player)) {
            return null;
        }
        PlayerPatch patch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        if (!PlayerLogicUtilities.isValidPatchedPlayer(patch)) {
            return null;
        }
        return patch;
    }
}

