/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.core.utilities.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sleys.lazyutilities.modules.epicfight.LZEpicFightMod;

public class FileReadUtilities {
    public static String processFileName(File file) {
        int parenIndex;
        String baseName = file.getName().split("-")[0];
        if (baseName.contains(".")) {
            baseName = baseName.substring(0, baseName.lastIndexOf(46));
        }
        if ((parenIndex = baseName.indexOf(40)) != -1) {
            baseName = baseName.substring(0, parenIndex);
        }
        int versionIndex = -1;
        for (int i = 0; i < baseName.length() - 1; ++i) {
            if (baseName.charAt(i) != 'v' && baseName.charAt(i) != 'V' || !Character.isDigit(baseName.charAt(i + 1))) continue;
            versionIndex = i;
            break;
        }
        if (versionIndex != -1) {
            baseName = baseName.substring(0, versionIndex);
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < baseName.length(); ++i) {
            char c = baseName.charAt(i);
            if (c == '_') {
                result.append(" ");
                continue;
            }
            if (i > 0 && Character.isUpperCase(c)) {
                char next;
                char prev = baseName.charAt(i - 1);
                char c2 = next = i + 1 < baseName.length() ? (char)baseName.charAt(i + 1) : (char)' ';
                if (!Character.isUpperCase(prev) || Character.isLowerCase(next)) {
                    result.append(" ");
                }
            }
            result.append(c);
        }
        String processed = result.toString().trim().replaceAll("\\s+", " ");
        StringBuilder finalResult = new StringBuilder(processed.length());
        boolean capitalizeNext = true;
        for (int i = 0; i < processed.length(); ++i) {
            char c = processed.charAt(i);
            if (capitalizeNext && Character.isLetter(c)) {
                finalResult.append(Character.toUpperCase(c));
                capitalizeNext = false;
            } else {
                finalResult.append(c);
            }
            if (c != ' ') continue;
            capitalizeNext = true;
        }
        return finalResult.toString().trim();
    }

    public static String extractFileModId(File file) {
        String modId = FileReadUtilities.extractModIdFromTOML(file);
        if (modId != null) {
            return modId;
        }
        return FileReadUtilities.extractModIdFromAssets(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String extractModIdFromTOML(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            ZipEntry entry = zipFile.getEntry("META-INF/mods.toml");
            if (entry == null) return null;
            try (InputStream stream = zipFile.getInputStream(entry);
                 BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                String modId;
                String line;
                do {
                    if ((line = reader.readLine()) == null) return null;
                } while (!line.trim().startsWith("modId=") || (modId = line.split("=")[1].split("#")[0].replace("\"", "").trim()).isEmpty());
                String string = modId;
                return string;
            }
        }
        catch (IOException e) {
            LZEpicFightMod.LOGGER.error("[LZM: Epic Fight] Error al intentar leer el archivo mods.toml: {}", (Object)e.getMessage());
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String extractModIdFromAssets(File file) {
        try (ZipFile zipFile = new ZipFile(file);){
            ArrayList<String> namespaces = new ArrayList<String>();
            Set<String> excludedNamespaces = Set.of("minecraft", "forge");
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            for (ZipEntry zipEntry : Collections.list(entries)) {
                String namespace;
                String[] parts;
                if (!zipEntry.getName().startsWith("assets/") || !zipEntry.isDirectory() || (parts = zipEntry.getName().split("/")).length <= 1 || excludedNamespaces.contains(namespace = parts[1]) || namespaces.contains(namespace)) continue;
                namespaces.add(namespace);
            }
            List<String> priorityNamespaces = List.of("epicfight");
            for (String priority : priorityNamespaces) {
                if (!namespaces.contains(priority)) continue;
                String string = priority;
                return string;
            }
            if (namespaces.isEmpty()) return null;
            String string = (String)namespaces.get(0);
            return string;
        }
        catch (Exception e) {
            LZEpicFightMod.LOGGER.error("[LZM: Epic Fight] Fallo al intentar obtener el ModId: {}", (Object)e.getMessage());
        }
        return null;
    }
}

