/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.core.packers.reader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.jetbrains.annotations.Nullable;
import sleys.lazyutilities.core.LazyUtilitiesMod;

public class LazyUtilitiesDataAccessor
extends AbstractPackResources {
    private final FileSystem fs;
    private final Path root;
    private final Path assetsRoot;
    private final Set<String> registeredPaths = new HashSet<String>();
    private final File zipFile;

    public LazyUtilitiesDataAccessor(File zipFile) throws IOException {
        super(zipFile.getName(), false);
        this.zipFile = zipFile;
        if (zipFile.isDirectory()) {
            this.fs = null;
            this.root = zipFile.toPath();
        } else {
            this.fs = FileSystems.newFileSystem(zipFile.toPath(), (ClassLoader)null);
            this.root = this.fs.getPath("/", new String[0]);
        }
        this.assetsRoot = this.root.resolve("data");
        Path metaPath = this.root.resolve("pack.mcmeta");
        if (!Files.exists(metaPath, new LinkOption[0])) {
            throw new IOException("[Lazy Utilities -/- Data] pack.mcmeta no encontrado en: " + String.valueOf(metaPath));
        }
    }

    public IoSupplier<InputStream> m_8017_(String ... paths) {
        Path path = this.root.resolve(String.join((CharSequence)"/", paths)).normalize();
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        return IoSupplier.m_246697_((Path)path);
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        Path path = this.assetsRoot.resolve(location.m_135827_()).resolve(location.m_135815_()).normalize();
        if (!path.startsWith(this.assetsRoot)) {
            LazyUtilitiesMod.LOGGER.warn("[Lazy Utilities -/- Data] Intento de acceso a ruta no permitida: {}", (Object)path);
            return null;
        }
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        return IoSupplier.m_246697_((Path)path);
    }

    public void m_8031_(PackType type, String namespace, String path, PackResources.ResourceOutput output) {
        Path nsRoot = this.assetsRoot.resolve(namespace).normalize();
        Path searchPath = nsRoot.resolve(path).normalize();
        if (!searchPath.startsWith(this.assetsRoot)) {
            LazyUtilitiesMod.LOGGER.warn("[Lazy Utilities -/- Data] Ruta no permitida: {}", (Object)searchPath);
            return;
        }
        if (!Files.exists(searchPath, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.walk(searchPath, new FileVisitOption[0]);){
            stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                String relative = nsRoot.relativize((Path)file).toString().replace("\\", "/");
                if (!relative.matches("[\\w\\-./+]+")) {
                    return;
                }
                ResourceLocation loc = ResourceLocation.m_135820_((String)(namespace + ":" + relative));
                if (loc != null && this.registeredPaths.add(loc.toString())) {
                    output.accept((Object)loc, (Object)IoSupplier.m_246697_((Path)file));
                } else {
                    LazyUtilitiesMod.LOGGER.error("[Lazy Utilities -/- Data] Saltanto recurso invalido: {}", (Object)(namespace + ":" + relative));
                }
            });
        }
        catch (IOException e) {
            LazyUtilitiesMod.LOGGER.error("[Lazy Utilities -/- Data] Error listando recursos: {}", (Object)e.getMessage());
        }
    }

    public Set<String> m_5698_(PackType type) {
        Set<String> set;
        block9: {
            if (!Files.exists(this.assetsRoot, new LinkOption[0])) {
                return Set.of();
            }
            Stream<Path> stream = Files.list(this.assetsRoot);
            try {
                set = stream.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.getFileName().toString()).collect(Collectors.toSet());
                if (stream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LazyUtilitiesMod.LOGGER.error("[Lazy Utilities -/- Data] Error en namespaces: {}", (Object)e.getMessage());
                    return Set.of();
                }
            }
            stream.close();
        }
        return set;
    }

    public String m_5542_() {
        return this.zipFile.toString();
    }

    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> deserializer) {
        if (!"pack".equals(deserializer.m_7991_())) {
            return null;
        }
        JsonObject fallbackPack = new JsonObject();
        fallbackPack.addProperty("pack_format", (Number)15);
        JsonObject descObj = new JsonObject();
        descObj.addProperty("text", "Data Loaded From -> " + this.zipFile.getName());
        descObj.addProperty("color", "gold");
        fallbackPack.add("description", (JsonElement)descObj);
        return (T)deserializer.m_6322_(fallbackPack);
    }

    public void close() {
        try {
            if (this.fs != null && this.fs.isOpen()) {
                this.fs.close();
            }
        }
        catch (IOException e) {
            LazyUtilitiesMod.LOGGER.error("[Lazy Utilities -/- Data] Error cerrando FileSystem", (Throwable)e);
        }
    }
}

