/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.core.forgeevents.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import sleys.lazyutilities.core.client.keys.LazyUtilitiesKeyBinding;
import sleys.lazyutilities.core.config.LazyUtilitiesConfigCommon;
import sleys.lazyutilities.core.interfaces.IWeaponCodex;
import sleys.lazyutilities.core.interfaces.IWeaponCodexBC;
import sleys.lazyutilities.core.interfaces.IWeaponCodexEF;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

public class RenderWeaponCodexTooltipEvent {
    private static final Component keyTooltip = LazyUtilitiesKeyBinding.extendItemDetails.m_90863_();
    private static final Component itemWeaponCodex = Component.m_237110_((String)"lazy_utilities.key.tooltip_codex", (Object[])new Object[]{keyTooltip}).m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component itemWeaponCodexEF = Component.m_237110_((String)"lazy_utilities.key.tooltip_codex_ef", (Object[])new Object[]{keyTooltip}).m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component itemWeaponCodexBC = Component.m_237110_((String)"lazy_utilities.key.tooltip_codex_bc", (Object[])new Object[]{keyTooltip}).m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component itemWeaponCodexEF_CodexFinal = Component.m_237115_((String)"lazy_utilities.key.tooltip_codex_ef.codex_final").m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component itemWeaponCodexBC_CodexFinal = Component.m_237115_((String)"lazy_utilities.key.tooltip_codex_bc.codex_final").m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component itemWeaponCodex_Lore = Component.m_237115_((String)"lazy_utilities.key.tooltip_codex.lore").m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component itemWeaponCodex_LoreFinal = Component.m_237115_((String)"lazy_utilities.key.tooltip_codex.lore_final").m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component itemWeaponCodex_Passive = Component.m_237115_((String)"lazy_utilities.key.tooltip_codex.passives").m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component itemWeaponCodex_PassiveFinal = Component.m_237115_((String)"lazy_utilities.key.tooltip_codex.passives_final").m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component itemWeaponCodex_Skill = Component.m_237115_((String)"lazy_utilities.key.tooltip_codex.skills").m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component itemWeaponCodex_SkillFinal = Component.m_237115_((String)"lazy_utilities.key.tooltip_codex.skills_final").m_130940_(ChatFormatting.DARK_GRAY);

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void upperInterfaceTooltipEvent(ItemTooltipEvent event) {
        if (LazyUtilitiesConfigCommon.getErrorHandlerLazyUtilities() != LazyUtilitiesConfigCommon.ErrorHandler.EXCEPTION) {
            try {
                RenderWeaponCodexTooltipEvent.upperInterfaceTooltipPayload(event);
            }
            catch (Exception exception) {}
        } else {
            RenderWeaponCodexTooltipEvent.upperInterfaceTooltipPayload(event);
        }
    }

    private static void upperInterfaceTooltipPayload(ItemTooltipEvent event) {
        Item item;
        if (event == null) {
            return;
        }
        if (event.getEntity() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        boolean isUnImplemented = false;
        boolean isUnImplementedEF = false;
        Item item2 = stack.m_41720_();
        if (item2 instanceof IWeaponCodex) {
            IWeaponCodex commonCodex = (IWeaponCodex)item2;
            isUnImplemented = commonCodex.isUnImplemented(stack);
        }
        if ((item2 = stack.m_41720_()) instanceof IWeaponCodexEF) {
            IWeaponCodexEF efCodex = (IWeaponCodexEF)item2;
            isUnImplementedEF = efCodex.isUnImplementedInnateSkill();
        }
        if (isUnImplemented && isUnImplementedEF) {
            return;
        }
        boolean hasCodex = stack.m_41720_() instanceof IWeaponCodex;
        boolean existCap = RenderWeaponCodexTooltipEvent.getSafeEpicFightCapability(event);
        boolean hasEF = stack.m_41720_() instanceof IWeaponCodexEF && existCap;
        boolean hasBC = stack.m_41720_() instanceof IWeaponCodexBC;
        if (!(hasBC || hasEF || hasCodex)) {
            return;
        }
        boolean hasLore = false;
        boolean hasSkills = false;
        boolean hasPassive = false;
        if (hasCodex && (item = stack.m_41720_()) instanceof IWeaponCodex) {
            IWeaponCodex codex = (IWeaponCodex)item;
            hasLore = codex.existWeaponLore(stack);
            hasSkills = codex.existSkills(stack);
            hasPassive = codex.existPassives(stack);
        }
        List tooltips = event.getToolTip();
        MutableComponent finalTooltip = Component.m_237113_((String)"").m_130940_(ChatFormatting.DARK_GRAY);
        if (hasCodex) {
            boolean willAppendEFOrBC;
            finalTooltip.m_7220_(itemWeaponCodex);
            ArrayList<Component> codexElements = new ArrayList<Component>();
            if (hasLore) {
                codexElements.add(itemWeaponCodex_Lore);
            }
            if (hasPassive) {
                codexElements.add(itemWeaponCodex_Passive);
            }
            if (hasSkills) {
                codexElements.add(itemWeaponCodex_Skill);
            }
            boolean bl = willAppendEFOrBC = hasEF || hasBC;
            if (!codexElements.isEmpty()) {
                for (int i = 0; i < codexElements.size(); ++i) {
                    boolean isLastCodexElement;
                    boolean bl2 = isLastCodexElement = i == codexElements.size() - 1;
                    if (!isLastCodexElement) {
                        finalTooltip.m_7220_((Component)codexElements.get(i));
                        continue;
                    }
                    if (!willAppendEFOrBC) {
                        if (codexElements.get(i) == itemWeaponCodex_Lore) {
                            finalTooltip.m_7220_(itemWeaponCodex_LoreFinal);
                            continue;
                        }
                        if (codexElements.get(i) == itemWeaponCodex_Passive) {
                            finalTooltip.m_7220_(itemWeaponCodex_PassiveFinal);
                            continue;
                        }
                        if (codexElements.get(i) != itemWeaponCodex_Skill) continue;
                        finalTooltip.m_7220_(itemWeaponCodex_SkillFinal);
                        continue;
                    }
                    finalTooltip.m_7220_((Component)codexElements.get(i));
                }
            }
            if (hasEF) {
                finalTooltip.m_7220_(itemWeaponCodexEF_CodexFinal);
            } else if (hasBC) {
                finalTooltip.m_7220_(itemWeaponCodexBC_CodexFinal);
            }
        } else {
            finalTooltip = hasEF ? Component.m_237113_((String)"").m_130940_(ChatFormatting.DARK_GRAY).m_7220_(itemWeaponCodexEF) : Component.m_237113_((String)"").m_130940_(ChatFormatting.DARK_GRAY).m_7220_(itemWeaponCodexBC);
        }
        tooltips.add(Component.m_237113_((String)""));
        tooltips.add(finalTooltip);
    }

    public static boolean getSafeEpicFightCapability(ItemTooltipEvent event) {
        if (FMLLoader.getLoadingModList().getModFileById("epicfight") != null) {
            return EpicFightCapabilities.getItemStackCapabilityOr((ItemStack)event.getItemStack(), null) != null;
        }
        return false;
    }
}

