/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.core.forgeevents.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sleys.lazyutilities.core.client.keys.LazyUtilitiesKeyBinding;
import sleys.lazyutilities.core.config.LazyUtilitiesConfigCommon;
import sleys.lazyutilities.core.interfaces.IArmorCodex;

public class RenderArmorCodexTooltipEvent {
    private static final Component keyTooltip = LazyUtilitiesKeyBinding.extendItemDetails.m_90863_();
    private static final Component itemArmorCodex = Component.m_237110_((String)"lazy_utilities.key.armortip_codex", (Object[])new Object[]{keyTooltip}).m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component itemArmorCodex_Passive = Component.m_237115_((String)"lazy_utilities.key.armortip_codex.passives").m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component itemArmorCodex_PassiveFinal = Component.m_237115_((String)"lazy_utilities.key.armortip_codex.passives_final").m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component itemArmorCodex_Skill = Component.m_237115_((String)"lazy_utilities.key.armortip_codex.skills").m_130940_(ChatFormatting.DARK_GRAY);
    private static final Component itemArmorCodex_SkillFinal = Component.m_237115_((String)"lazy_utilities.key.armortip_codex.skills_final").m_130940_(ChatFormatting.DARK_GRAY);

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void upperInterfaceArmortipEvent(ItemTooltipEvent event) {
        if (LazyUtilitiesConfigCommon.getErrorHandlerLazyUtilities() != LazyUtilitiesConfigCommon.ErrorHandler.EXCEPTION) {
            try {
                RenderArmorCodexTooltipEvent.upperInterfaceArmortipPayload(event);
            }
            catch (Exception exception) {}
        } else {
            RenderArmorCodexTooltipEvent.upperInterfaceArmortipPayload(event);
        }
    }

    private static void upperInterfaceArmortipPayload(ItemTooltipEvent event) {
        if (event == null) {
            return;
        }
        if (event.getEntity() == null) {
            return;
        }
        ItemStack stack = event.getItemStack();
        Item item = stack.m_41720_();
        if (item instanceof IArmorCodex) {
            IArmorCodex codex = (IArmorCodex)item;
            if (codex.isUnImplemented(stack)) {
                return;
            }
            boolean hasSkills = codex.existSkills(stack);
            boolean hasPassive = codex.existPassives(stack);
            List tooltips = event.getToolTip();
            MutableComponent finalTooltip = Component.m_237113_((String)"").m_130940_(ChatFormatting.DARK_GRAY);
            finalTooltip.m_7220_(itemArmorCodex);
            ArrayList<Component> codexElements = new ArrayList<Component>();
            if (hasPassive) {
                codexElements.add(itemArmorCodex_Passive);
            }
            if (hasSkills) {
                codexElements.add(itemArmorCodex_Skill);
            }
            if (!codexElements.isEmpty()) {
                for (int i = 0; i < codexElements.size(); ++i) {
                    boolean isLastCodexElement;
                    boolean bl = isLastCodexElement = i == codexElements.size() - 1;
                    if (!isLastCodexElement) {
                        finalTooltip.m_7220_((Component)codexElements.get(i));
                        continue;
                    }
                    if (codexElements.get(i) == itemArmorCodex_Passive) {
                        finalTooltip.m_7220_(itemArmorCodex_PassiveFinal);
                        continue;
                    }
                    if (codexElements.get(i) != itemArmorCodex_Skill) continue;
                    finalTooltip.m_7220_(itemArmorCodex_SkillFinal);
                }
            }
            tooltips.add(Component.m_237113_((String)""));
            tooltips.add(finalTooltip);
        }
    }
}

