/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.core.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ElementsModuleConfig {
    public static final ForgeConfigSpec ELEMENTS_CONFIG;
    public static final ForgeConfigSpec.BooleanValue ALLOW_REACTIONS;
    public static final ForgeConfigSpec.BooleanValue ALLOW_ELEMENTS_IN_ENVIRONMENT;
    public static final ForgeConfigSpec.BooleanValue DEPURATE_REACTIONS;
    public static final ForgeConfigSpec.BooleanValue DEPURATE_ICD;
    public static final ForgeConfigSpec.BooleanValue DEPURATE_ERCS;
    public static final ForgeConfigSpec.BooleanValue DEPURATE_DAMAGE;

    public static boolean isAllowReactions() {
        return (Boolean)ALLOW_REACTIONS.get();
    }

    public static boolean isAllowElementsInEnvironment() {
        return (Boolean)ALLOW_ELEMENTS_IN_ENVIRONMENT.get();
    }

    public static boolean isDepurateReactions() {
        return (Boolean)DEPURATE_REACTIONS.get();
    }

    public static boolean isDepurateICD() {
        return (Boolean)DEPURATE_ICD.get();
    }

    public static boolean isDepurateERCS() {
        return (Boolean)DEPURATE_ERCS.get();
    }

    public static boolean isDepurateEDS() {
        return (Boolean)DEPURATE_DAMAGE.get();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.push("Lazy Utilities (Element Module -/- System)");
        ALLOW_REACTIONS = builder.comment("Disables reactions; that is, elements can no longer interact with other elements").define("allowReactions", false);
        ALLOW_ELEMENTS_IN_ENVIRONMENT = builder.comment("Prevents the environment from adding elements to living entities").define("allowElementsInEnvironment", false);
        builder.pop();
        builder.push("Lazy Utilities (Element Module -/- Debugging)");
        DEPURATE_REACTIONS = builder.comment("Allows debugging of data supplied by the elementary reaction matrix").define("depurateReactions", false);
        DEPURATE_ICD = builder.comment("Allows debugging of data supplied by ICD (Internal Cooldown Dealer) System, allows obtaining the weapon element, the causing entity and the target and transferring data to the target entity").define("depurateICD", false);
        DEPURATE_ERCS = builder.comment("Allows debugging of data supplied by ERCS (Elemental Reactions Cooldown System), provides the re-addition time for each elementary reaction, both for forward and reverse").define("depurateERCS", false);
        DEPURATE_DAMAGE = builder.comment("Allows debugging of data supplied by EDS (Elemental Damage System), shows how the characteristics apply to damage caused by the player or as a result of the player").define("depurateDamage", false);
        builder.pop();
        ELEMENTS_CONFIG = builder.build();
    }
}

