/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.core.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import sleys.lazyutilities.core.LazyUtilitiesMod;

public class LazyUtilitiesCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lazy-utilities").requires(src -> src.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reload").then(Commands.m_82127_((String)"mod").then(Commands.m_82129_((String)"modid", (ArgumentType)StringArgumentType.string()).executes(ctx -> LazyUtilitiesCommands.reloadSingle((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"modid")))))).then(Commands.m_82127_((String)"mod-list").then(Commands.m_82129_((String)"mods", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> LazyUtilitiesCommands.reloadList((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"mods")))))).then(Commands.m_82127_((String)"mod-tree").then(Commands.m_82129_((String)"modid", (ArgumentType)StringArgumentType.string()).executes(ctx -> LazyUtilitiesCommands.reloadTree((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"modid")))))).then(Commands.m_82127_((String)"mod-root").then(Commands.m_82129_((String)"modid", (ArgumentType)StringArgumentType.string()).executes(ctx -> LazyUtilitiesCommands.reloadRoot((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"modid")))))));
    }

    private static int reloadSingle(CommandSourceStack source, String modid) {
        MinecraftServer server = source.m_81377_();
        source.m_288197_(() -> Component.m_237113_((String)("trying to reload repositories for: " + modid)).m_130940_(ChatFormatting.YELLOW), true);
        if (ModList.get().isLoaded(modid)) {
            LazyUtilitiesCommands.reloadModResources(server, modid);
            source.m_288197_(() -> Component.m_237113_((String)("Mod: " + modid + ", reloaded successfully")).m_130940_(ChatFormatting.GREEN), true);
            return 1;
        }
        source.m_288197_(() -> Component.m_237113_((String)("Mod: " + modid + ", out of range")).m_130940_(ChatFormatting.RED), true);
        return 0;
    }

    private static int reloadList(CommandSourceStack source, String modsArg) {
        String[] rawMods = modsArg.split("\\s+");
        ArrayList<String> validMods = new ArrayList<String>();
        ArrayList<String> invalidMods = new ArrayList<String>();
        for (String modid : rawMods) {
            if (ModList.get().isLoaded(modid)) {
                validMods.add(modid);
                continue;
            }
            invalidMods.add(modid);
        }
        source.m_288197_(() -> Component.m_237113_((String)("Trying to reload repositories for: " + modsArg)).m_130940_(ChatFormatting.YELLOW), true);
        for (String modid : invalidMods) {
            source.m_288197_(() -> Component.m_237113_((String)("Mod: " + modid + ", out of range")).m_130940_(ChatFormatting.RED), true);
        }
        if (validMods.isEmpty()) {
            return 0;
        }
        if (validMods.size() == 1) {
            LazyUtilitiesCommands.reloadModResources(source.m_81377_(), (String)validMods.get(0));
            source.m_288197_(() -> Component.m_237113_((String)("Mod: " + (String)validMods.get(0) + ", reloaded successfully")).m_130940_(ChatFormatting.GREEN), true);
        } else {
            LazyUtilitiesCommands.reloadModResourcesBatch(source.m_81377_(), validMods);
            source.m_288197_(() -> Component.m_237113_((String)("Reloaded " + validMods.size() + " mods.")).m_130940_(ChatFormatting.AQUA), true);
        }
        return validMods.size();
    }

    private static int reloadRoot(CommandSourceStack source, String root) {
        source.m_288197_(() -> Component.m_237113_((String)("Trying to reload repository root for: " + root)).m_130940_(ChatFormatting.YELLOW), true);
        if (!ModList.get().isLoaded(root)) {
            source.m_81352_((Component)Component.m_237113_((String)("Mod: " + root + ", out of range.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        Set<String> mods = LazyUtilitiesCommands.collectDependencies(root);
        LazyUtilitiesCommands.reloadModResourcesBatch(source.m_81377_(), mods);
        source.m_288197_(() -> LazyUtilitiesCommands.formatReloadMessage(root, mods, true), true);
        return mods.size();
    }

    private static int reloadTree(CommandSourceStack source, String tree) {
        source.m_288197_(() -> Component.m_237113_((String)("Trying to reload repository tree for: " + tree)).m_130940_(ChatFormatting.YELLOW), true);
        if (!ModList.get().isLoaded(tree)) {
            source.m_81352_((Component)Component.m_237113_((String)("Mod: " + tree + ", out of range.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        Set<String> mods = LazyUtilitiesCommands.collectDependents(tree);
        LazyUtilitiesCommands.reloadModResourcesBatch(source.m_81377_(), mods);
        source.m_288197_(() -> LazyUtilitiesCommands.formatReloadMessage(tree, mods, false), true);
        return mods.size();
    }

    private static void reloadModResources(MinecraftServer server, String modid) {
        PackRepository packRepository = server.m_129891_();
        ArrayList<String> activePacks = new ArrayList<String>(packRepository.m_10523_());
        String targetPack = null;
        int packIndex = -1;
        for (int i = 0; i < activePacks.size(); ++i) {
            String id = (String)activePacks.get(i);
            if (!id.toLowerCase().contains(modid.toLowerCase())) continue;
            targetPack = id;
            packIndex = i;
            break;
        }
        LazyUtilitiesMod.LOGGER.info("Recargando repositorio para: {}", targetPack);
        activePacks.remove(packIndex);
        activePacks.add(packIndex, targetPack);
        server.m_129861_(activePacks);
    }

    private static void reloadModResourcesBatch(MinecraftServer server, Collection<String> modids) {
        PackRepository packRepository = server.m_129891_();
        ArrayList activePacks = new ArrayList(packRepository.m_10523_());
        HashMap<String, Integer> packPositions = new HashMap<String, Integer>();
        for (int i = 0; i < activePacks.size(); ++i) {
            packPositions.put((String)activePacks.get(i), i);
        }
        LinkedHashSet<String> targetPacks = new LinkedHashSet<String>();
        block1: for (String modid : modids) {
            for (String id : activePacks) {
                if (!id.toLowerCase().contains(modid.toLowerCase())) continue;
                targetPacks.add(id);
                continue block1;
            }
        }
        if (targetPacks.isEmpty()) {
            return;
        }
        ArrayList<String> newPackOrder = new ArrayList<String>(activePacks);
        for (String id : targetPacks) {
            int index;
            if (!ModList.get().isLoaded(id) || (index = packPositions.getOrDefault(id, -1).intValue()) == -1) continue;
            newPackOrder.remove(index);
            newPackOrder.add(index, id);
        }
        LazyUtilitiesMod.LOGGER.info("Recargando repositorios para: {}", targetPacks);
        server.m_129861_(newPackOrder);
    }

    private static Set<String> collectDependencies(String root) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        LazyUtilitiesCommands.collectDepsRecursive(root, result);
        return result;
    }

    private static Set<String> collectDependents(String base) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        LazyUtilitiesCommands.collectDependentsRecursive(base, result);
        return result;
    }

    private static void collectDepsRecursive(String modid, Set<String> acc) {
        if (!ModList.get().isLoaded(modid) || acc.contains(modid)) {
            return;
        }
        acc.add(modid);
        ModInfo info = ModList.get().getModContainerById(modid).map(ModContainer::getModInfo).orElse(null);
        if (info == null) {
            return;
        }
        info.getDependencies().forEach(dep -> LazyUtilitiesCommands.collectDepsRecursive(dep.getModId(), acc));
    }

    private static Component formatReloadMessage(String root, Set<String> mods, boolean isRoot) {
        LinkedHashSet<String> others = new LinkedHashSet<String>(mods);
        others.remove(root);
        String label = isRoot ? "dependencies" : "dependents";
        MutableComponent mainMessage = Component.m_237113_((String)"Loaded repository for ").m_130940_(ChatFormatting.GREEN);
        mainMessage.m_7220_((Component)Component.m_237113_((String)root).m_130940_(ChatFormatting.DARK_GREEN));
        if (!others.isEmpty()) {
            mainMessage.m_7220_((Component)Component.m_237113_((String)(" and its " + label)).m_130940_(ChatFormatting.GREEN));
            mainMessage.m_7220_((Component)Component.m_237113_((String)": [").m_130940_(ChatFormatting.GREEN));
            mainMessage.m_7220_((Component)Component.m_237113_((String)String.join((CharSequence)", ", others)).m_130940_(ChatFormatting.AQUA));
            mainMessage.m_7220_((Component)Component.m_237113_((String)"]").m_130940_(ChatFormatting.GREEN));
        }
        return mainMessage;
    }

    private static void collectDependentsRecursive(String modid, Set<String> acc) {
        if (acc.contains(modid)) {
            return;
        }
        acc.add(modid);
        for (IModInfo info : ModList.get().getMods()) {
            boolean depends = info.getDependencies().stream().anyMatch(dep -> dep.getModId().equalsIgnoreCase(modid));
            if (!depends) continue;
            LazyUtilitiesCommands.collectDependentsRecursive(info.getModId(), acc);
        }
    }

    public static class CommandRegistry {
        @SubscribeEvent
        public static void registerCommandEvent(RegisterCommandsEvent event) {
            CommandDispatcher dispatcher = event.getDispatcher();
            LazyUtilitiesCommands.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        }
    }
}

