/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.core.client.shaderfx;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sleys.lazyutilities.core.LazyUtilitiesMod;
import sleys.lazyutilities.core.utilities.screen.ScreenUtilities;

public class RadialBlur {
    private static PostChain radialBlurChain;
    private static final ResourceLocation POST_CHAIN_LOCATION;

    public static boolean existRadialBlur() {
        return radialBlurChain != null;
    }

    public static void triggerRadialBlurEffect() {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            try {
                mc.f_91063_.m_109128_(POST_CHAIN_LOCATION);
                PostChain actuallyEffect = mc.f_91063_.m_109149_();
                if (actuallyEffect != null && actuallyEffect.m_110022_().equals("lazy_utilities:shaders/post/radial_blur.json")) {
                    radialBlurChain = actuallyEffect;
                }
            }
            catch (Exception e) {
                LazyUtilitiesMod.LOGGER.error("Failed to load impact shader", (Throwable)e);
            }
        });
    }

    public static void updateUniforms() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        PostChain chain = mc.f_91063_.m_109149_();
        if (chain == null) {
            return;
        }
        for (PostPass pass : chain.f_110009_) {
            EffectInstance effect = pass.m_110074_();
            if (!pass.m_173046_().equals("lazy_utilities:radial_fast_blur/radial_blur")) continue;
            ScreenUtilities.setUniformSafe(effect, "Strength", 0.12f);
            ScreenUtilities.setUniformSafe(effect, "Samples", 12);
            ScreenUtilities.setUniformSafe(effect, "FocalUV", new float[]{0.5f, 0.45f});
        }
    }

    public static void clearRadialBlur() {
        if (radialBlurChain != null) {
            radialBlurChain.close();
            radialBlurChain = null;
        }
    }

    static {
        POST_CHAIN_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"lazy_utilities", (String)"shaders/post/radial_blur.json");
    }

    public static class RadialBlurTickEvent {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END && radialBlurChain != null) {
                RadialBlur.updateUniforms();
            }
        }

        @SubscribeEvent
        public static void onRender(RenderLevelStageEvent event) {
            if (radialBlurChain != null && event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
                RenderSystem.disableDepthTest();
                radialBlurChain.m_110023_(event.getPartialTick());
                RenderSystem.enableDepthTest();
            }
        }
    }
}

