/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.core.client.shaderfx;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EffectInstance;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sleys.lazyutilities.core.LazyUtilitiesMod;

public class ImpactFrame {
    public static PostChain impactChain;
    public static int effectTimer;
    public static float currentIntensity;
    public static final ResourceLocation POST_CHAIN_LOCATION;

    public static void triggerImpactEffect(int durationTicks) {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            try {
                mc.f_91063_.m_109128_(POST_CHAIN_LOCATION);
                effectTimer = durationTicks;
                currentIntensity = 1.0f;
                PostChain actuallyEffect = mc.f_91063_.m_109149_();
                if (actuallyEffect != null && actuallyEffect.m_110022_().equals("lazy_utilities:shaders/post/impact_frame.json")) {
                    impactChain = actuallyEffect;
                }
            }
            catch (Exception e) {
                LazyUtilitiesMod.LOGGER.error("Failed to load impact shader", (Throwable)e);
            }
        });
    }

    public static void clearImpactFrame() {
        if (impactChain != null) {
            impactChain.close();
            impactChain = null;
        }
        effectTimer = 0;
        currentIntensity = 0.0f;
    }

    public static void updateUniforms() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null) {
            return;
        }
        PostChain chain = mc.f_91063_.m_109149_();
        if (chain == null) {
            return;
        }
        float time = mc.f_91073_.m_46467_();
        for (PostPass pass : chain.f_110009_) {
            if (!pass.m_173046_().equals("lazy_utilities:noise_overlay")) continue;
            EffectInstance effect = pass.m_110074_();
            ImpactFrame.setUniformSafe(effect, "Time", time);
            ImpactFrame.setUniformSafe(effect, "Intensity", currentIntensity);
            ImpactFrame.setUniformSafe(effect, "FocalUV", new float[]{0.5f, 0.5f});
            ImpactFrame.setUniformSafe(effect, "Scale", 2.5f);
            ImpactFrame.setUniformSafe(effect, "ColorFilter", new float[]{1.0f, 1.0f, 1.0f});
        }
    }

    private static void setUniformSafe(EffectInstance effect, String name, float value) {
        if (effect.m_108952_(name) != null) {
            Objects.requireNonNull(effect.m_108952_(name)).m_5985_(value);
        }
    }

    private static void setUniformSafe(EffectInstance effect, String name, float[] values) {
        if (effect.m_108952_(name) != null) {
            Objects.requireNonNull(effect.m_108952_(name)).m_5941_(values);
        }
    }

    static {
        POST_CHAIN_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"lazy_utilities", (String)"shaders/post/impact_frame.json");
    }

    public static class ShaderTickEvent {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase == TickEvent.Phase.END && effectTimer > 0) {
                currentIntensity = (float)(--effectTimer) / 40.0f;
                ImpactFrame.updateUniforms();
                if (effectTimer <= 0) {
                    ImpactFrame.clearImpactFrame();
                }
            }
        }

        @SubscribeEvent
        public static void onRender(RenderLevelStageEvent event) {
            if (impactChain != null && event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
                RenderSystem.disableDepthTest();
                impactChain.m_110023_(event.getPartialTick());
                RenderSystem.enableDepthTest();
            }
        }
    }
}

