/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.core.client.screens.tabs.armor;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import sleys.lazyutilities.core.client.screens.tab.CodexTab;
import yesman.epicfight.api.utils.math.QuaternionUtils;

public class ArmorAttributeTab
extends CodexTab {
    private final ItemStack stack;
    private final EquipmentSlot slot;
    private final List<FormattedCharSequence> attributeLines;
    private final int maxWidth = 135;
    private float rotationAngle = 0.0f;
    private final Component itemName;
    private final int correctionFactor;

    public ArmorAttributeTab(ItemStack stack, EquipmentSlot slot, int correctionFactor, Component itemName, String tabName) {
        super((Component)Component.m_237115_((String)tabName));
        this.correctionFactor = correctionFactor;
        this.stack = stack.m_41777_();
        this.slot = slot;
        this.itemName = itemName;
        this.attributeLines = this.extractAttributeLines();
    }

    private List<FormattedCharSequence> extractAttributeLines() {
        Minecraft mc = Minecraft.m_91087_();
        Font font = mc.f_91062_;
        ArrayList<FormattedCharSequence> lines = new ArrayList<FormattedCharSequence>();
        List tooltip = this.stack.m_41651_((Player)mc.f_91074_, (TooltipFlag)TooltipFlag.Default.f_256752_);
        for (int i = 1; i < tooltip.size(); ++i) {
            Component line = (Component)tooltip.get(i);
            if (this.isCommentLine(line)) continue;
            lines.addAll(font.m_92923_((FormattedText)line, 135));
        }
        return lines;
    }

    @Override
    public void renderContent(GuiGraphics gg, int x, int y, int mouseX, int mouseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        this.renderArmorStandWithItem(gg, this.stack, this.slot, x, y);
        int offsetY = y + 27 + this.correctionFactor;
        List wrappedName = font.m_92923_((FormattedText)this.itemName, 125);
        for (FormattedCharSequence line : wrappedName) {
            int lineWidth = font.m_92724_(line);
            int adjustedX = x + 60 - lineWidth / 2;
            gg.m_280649_(font, line, adjustedX, offsetY, 0xFFFFFF, false);
            offsetY += 10;
        }
        gg.m_280509_(x, offsetY, x + 135 - 5, offsetY + 1, -10066330);
        offsetY += 8;
        for (FormattedCharSequence line : this.attributeLines) {
            gg.m_280649_(font, line, x, offsetY, 0xCCCCCC, false);
            offsetY += 10;
        }
    }

    private void renderArmorStandWithItem(GuiGraphics gg, ItemStack stack, EquipmentSlot slot, int x, int y) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            ArmorStand armorStand = new ArmorStand((Level)mc.f_91073_, 0.0, 0.0, 0.0);
            armorStand.m_6842_(false);
            armorStand.m_31675_(true);
            armorStand.m_31678_(true);
            armorStand.m_31681_(true);
            armorStand.m_8061_(slot, stack);
            gg.m_280168_().m_85836_();
            gg.m_280168_().m_252880_((float)(x + 60), (float)(y + 22 + this.correctionFactor), 150.0f);
            gg.m_280168_().m_252781_(QuaternionUtils.ZP.rotation(3.1415f));
            gg.m_280168_().m_85841_(27.0f, 27.0f, 27.0f);
            this.rotationAngle += mc.m_91297_() * 3.5f;
            Quaternionf baseQuaternion = new Quaternionf().add(0.0f, 0.0f, 0.0f, 1.0f);
            float sinAngle = (float)Math.sin(Math.PI / 180 * (double)this.rotationAngle * 0.5);
            float cosAngle = (float)Math.cos(Math.PI / 180 * (double)this.rotationAngle * 0.5);
            baseQuaternion.set(0.0f, sinAngle, 0.0f, cosAngle);
            baseQuaternion.normalize();
            gg.m_280168_().m_272245_(baseQuaternion, 0.0f, 1.0f, 0.0f);
            EntityRenderDispatcher dispatcher = mc.m_91290_();
            dispatcher.m_114468_(false);
            MultiBufferSource.BufferSource buffer = mc.m_91269_().m_110104_();
            dispatcher.m_114384_((Entity)armorStand, 0.0, 0.0, 0.0, 0.0f, mc.m_91297_(), gg.m_280168_(), (MultiBufferSource)buffer, 0xF000F0);
            buffer.m_109911_();
            dispatcher.m_114468_(true);
            gg.m_280168_().m_85849_();
        }
    }

    @Override
    public int getContentHeight() {
        int baseHeight = 85;
        int contentHeight = this.attributeLines.size() * 9;
        return baseHeight + (contentHeight > 0 ? contentHeight : 10) + 15;
    }

    private boolean isCommentLine(Component line) {
        Style style = line.m_7383_();
        return style.m_131135_() != null && style.m_131135_().m_131265_() == 0x555555;
    }
}

