/*
 * Decompiled with CFR 0.152.
 */
package sleys.lazyutilities.core.client.screens.scroll;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public abstract class ScrollCodexPanel
extends AbstractWidget {
    protected final Minecraft minecraft;
    protected double scrollAmount = 0.0;
    protected boolean scrolling = false;

    public ScrollCodexPanel(Minecraft mc, int x, int y, int width, int height, int i) {
        super(x, y, width, height, CommonComponents.f_237098_);
        this.minecraft = mc;
    }

    public abstract int getContentHeight();

    public void setScrollAmount(double amount) {
        this.scrollAmount = Mth.m_14008_((double)amount, (double)0.0, (double)Math.max(0, this.getContentHeight() - this.f_93619_));
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.scrolling = true;
            return true;
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling) {
            this.setScrollAmount(this.scrollAmount - dragY);
            return true;
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.setScrollAmount(this.scrollAmount - delta * 10.0);
            return true;
        }
        return false;
    }

    public abstract void drawPanel(GuiGraphics var1, int var2, int var3, Tesselator var4, int var5, int var6);

    public void m_88315_(@NotNull GuiGraphics gg, int mouseX, int mouseY, float partialTick) {
        this.enableScissor(gg);
        Tesselator tess = Tesselator.m_85913_();
        BufferBuilder buffer = tess.m_85915_();
        gg.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, 0x66000000);
        this.drawPanel(gg, this.m_252754_() + this.f_93618_, this.m_252907_() - (int)this.scrollAmount, tess, mouseX, mouseY);
        this.disableScissor(gg);
        this.renderScrollBar(gg);
    }

    protected void enableScissor(GuiGraphics gg) {
        gg.m_280588_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_);
    }

    protected void disableScissor(GuiGraphics gg) {
        gg.m_280618_();
    }

    protected void renderScrollBar(GuiGraphics gg) {
        int contentHeight = this.getContentHeight();
        if (contentHeight > this.f_93619_) {
            int scrollBarWidth = 4;
            int scrollBarX = this.m_252754_() + this.f_93618_ - scrollBarWidth - 2;
            int scrollBarHeight = (int)((float)this.f_93619_ / (float)contentHeight * (float)this.f_93619_);
            scrollBarHeight = Math.max(20, scrollBarHeight);
            int scrollBarY = this.m_252907_() + (int)((float)this.scrollAmount / (float)(contentHeight - this.f_93619_) * (float)(this.f_93619_ - scrollBarHeight));
            gg.m_280509_(scrollBarX + 5, scrollBarY, scrollBarX + scrollBarWidth - 3, scrollBarY + scrollBarHeight, -5592406);
        }
    }

    public void renderContent(GuiGraphics gg, Runnable contentRenderer) {
        this.enableScissor(gg);
        contentRenderer.run();
        this.disableScissor(gg);
    }
}

