/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.terraform.noise;

public class OpenSimplexNoise2S {
    private static final long PRIME_X = 5910200641878280303L;
    private static final long PRIME_Y = 6452764530575939509L;
    private static final long PRIME_Z = 6614699811220273867L;
    private static final long PRIME_W = 6254464313819354443L;
    private static final long HASH_MULTIPLIER = 6026932503003350773L;
    private static final long SEED_FLIP_3D = -5968755714895566377L;
    private static final double ROOT2OVER2 = 0.7071067811865476;
    private static final double SKEW_2D = 0.366025403784439;
    private static final double UNSKEW_2D = -0.21132486540518713;
    private static final double ROOT3OVER3 = 0.577350269189626;
    private static final double FALLBACK_ROTATE3 = 0.6666666666666666;
    private static final double ROTATE3_ORTHOGONALIZER = -0.21132486540518713;
    private static final float SKEW_4D = 0.309017f;
    private static final float UNSKEW_4D = -0.1381966f;
    private static final int N_GRADS_2D_EXPONENT = 7;
    private static final int N_GRADS_3D_EXPONENT = 8;
    private static final int N_GRADS_4D_EXPONENT = 9;
    private static final int N_GRADS_2D = 128;
    private static final int N_GRADS_3D = 256;
    private static final int N_GRADS_4D = 512;
    private static final double NORMALIZER_2D = 0.05481866495625118;
    private static final double NORMALIZER_3D = 0.2781926117527186;
    private static final double NORMALIZER_4D = 0.11127401889945551;
    private static final float RSQUARED_2D = 0.6666667f;
    private static final float RSQUARED_3D = 0.75f;
    private static final float RSQUARED_4D = 0.8f;
    private static final long DEFAULT_SEED = 0L;
    private long seed = -1L;
    private static final float[] GRADIENTS_2D;
    private static final float[] GRADIENTS_3D;
    private static final float[] GRADIENTS_4D;
    private static final int[] LOOKUP_4D_A;
    private static final LatticeVertex4D[] LOOKUP_4D_B;

    public OpenSimplexNoise2S() {
        this(0L);
    }

    public OpenSimplexNoise2S(long seed) {
        this.seed = seed;
    }

    public float sample(double x, double y) {
        return OpenSimplexNoise2S.noise2(this.seed, x, y);
    }

    public float sample(double x, double y, double z) {
        return OpenSimplexNoise2S.noise3_ImproveXZ(this.seed, x, y, z);
    }

    public long getSeed() {
        return this.seed;
    }

    public static float noise2(long seed, double x, double y) {
        double s = 0.366025403784439 * (x + y);
        double xs = x + s;
        double ys = y + s;
        return OpenSimplexNoise2S.noise2_UnskewedBase(seed, xs, ys);
    }

    public static float noise2_ImproveX(long seed, double x, double y) {
        double xx = x * 0.7071067811865476;
        double yy = y * 1.2247448713915896;
        return OpenSimplexNoise2S.noise2_UnskewedBase(seed, yy + xx, yy - xx);
    }

    private static float noise2_UnskewedBase(long seed, double xs, double ys) {
        int xsb = OpenSimplexNoise2S.fastFloor(xs);
        int ysb = OpenSimplexNoise2S.fastFloor(ys);
        float xi = (float)(xs - (double)xsb);
        float yi = (float)(ys - (double)ysb);
        long xsbp = (long)xsb * 5910200641878280303L;
        long ysbp = (long)ysb * 6452764530575939509L;
        float t = (xi + yi) * -0.21132487f;
        float dx0 = xi + t;
        float dy0 = yi + t;
        float a0 = 0.6666667f - dx0 * dx0 - dy0 * dy0;
        float value = a0 * a0 * (a0 * a0) * OpenSimplexNoise2S.grad(seed, xsbp, ysbp, dx0, dy0);
        float a1 = -3.1547005f * t + (-0.6666667f + a0);
        float dx1 = dx0 - 0.57735026f;
        float dy1 = dy0 - 0.57735026f;
        value += a1 * a1 * (a1 * a1) * OpenSimplexNoise2S.grad(seed, xsbp + 5910200641878280303L, ysbp + 6452764530575939509L, dx1, dy1);
        float xmyi = xi - yi;
        if ((double)t < -0.21132486540518713) {
            if (xi + xmyi > 1.0f) {
                dx2 = dx0 - 1.3660254f;
                dy2 = dy0 - 0.36602542f;
                a2 = 0.6666667f - dx2 * dx2 - dy2 * dy2;
                if (a2 > 0.0f) {
                    value += a2 * a2 * (a2 * a2) * OpenSimplexNoise2S.grad(seed, xsbp + -6626342789952991010L, ysbp + 6452764530575939509L, dx2, dy2);
                }
            } else {
                dx2 = dx0 - -0.21132487f;
                dy2 = dy0 - 0.7886751f;
                a2 = 0.6666667f - dx2 * dx2 - dy2 * dy2;
                if (a2 > 0.0f) {
                    value += a2 * a2 * (a2 * a2) * OpenSimplexNoise2S.grad(seed, xsbp, ysbp + 6452764530575939509L, dx2, dy2);
                }
            }
            if (yi - xmyi > 1.0f) {
                dx3 = dx0 - 0.36602542f;
                dy3 = dy0 - 1.3660254f;
                a3 = 0.6666667f - dx3 * dx3 - dy3 * dy3;
                if (a3 > 0.0f) {
                    value += a3 * a3 * (a3 * a3) * OpenSimplexNoise2S.grad(seed, xsbp + 5910200641878280303L, ysbp + -5541215012557672598L, dx3, dy3);
                }
            } else {
                dx3 = dx0 - 0.7886751f;
                dy3 = dy0 - -0.21132487f;
                a3 = 0.6666667f - dx3 * dx3 - dy3 * dy3;
                if (a3 > 0.0f) {
                    value += a3 * a3 * (a3 * a3) * OpenSimplexNoise2S.grad(seed, xsbp + 5910200641878280303L, ysbp, dx3, dy3);
                }
            }
        } else {
            float a2;
            float dy2;
            float dx2;
            if (xi + xmyi < 0.0f) {
                dx2 = dx0 + 0.7886751f;
                dy2 = dy0 + -0.21132487f;
                a2 = 0.6666667f - dx2 * dx2 - dy2 * dy2;
                if (a2 > 0.0f) {
                    value += a2 * a2 * (a2 * a2) * OpenSimplexNoise2S.grad(seed, xsbp - 5910200641878280303L, ysbp, dx2, dy2);
                }
            } else {
                dx2 = dx0 - 0.7886751f;
                dy2 = dy0 - -0.21132487f;
                a2 = 0.6666667f - dx2 * dx2 - dy2 * dy2;
                if (a2 > 0.0f) {
                    value += a2 * a2 * (a2 * a2) * OpenSimplexNoise2S.grad(seed, xsbp + 5910200641878280303L, ysbp, dx2, dy2);
                }
            }
            if (yi < xmyi) {
                dx2 = dx0 + -0.21132487f;
                dy2 = dy0 + 0.7886751f;
                a2 = 0.6666667f - dx2 * dx2 - dy2 * dy2;
                if (a2 > 0.0f) {
                    value += a2 * a2 * (a2 * a2) * OpenSimplexNoise2S.grad(seed, xsbp, ysbp - 6452764530575939509L, dx2, dy2);
                }
            } else {
                dx2 = dx0 - -0.21132487f;
                dy2 = dy0 - 0.7886751f;
                a2 = 0.6666667f - dx2 * dx2 - dy2 * dy2;
                if (a2 > 0.0f) {
                    value += a2 * a2 * (a2 * a2) * OpenSimplexNoise2S.grad(seed, xsbp, ysbp + 6452764530575939509L, dx2, dy2);
                }
            }
        }
        return value;
    }

    public static float noise3_ImproveXY(long seed, double x, double y, double z) {
        double xy = x + y;
        double s2 = xy * -0.21132486540518713;
        double zz = z * 0.577350269189626;
        double xr = x + s2 + zz;
        double yr = y + s2 + zz;
        double zr = xy * -0.577350269189626 + zz;
        return OpenSimplexNoise2S.noise3_UnrotatedBase(seed, xr, yr, zr);
    }

    public static float noise3_ImproveXZ(long seed, double x, double y, double z) {
        double xz = x + z;
        double s2 = xz * -0.211324865405187;
        double yy = y * 0.577350269189626;
        double xr = x + s2 + yy;
        double zr = z + s2 + yy;
        double yr = xz * -0.577350269189626 + yy;
        return OpenSimplexNoise2S.noise3_UnrotatedBase(seed, xr, yr, zr);
    }

    public static float noise3_Fallback(long seed, double x, double y, double z) {
        double r = 0.6666666666666666 * (x + y + z);
        double xr = r - x;
        double yr = r - y;
        double zr = r - z;
        return OpenSimplexNoise2S.noise3_UnrotatedBase(seed, xr, yr, zr);
    }

    private static float noise3_UnrotatedBase(long seed, double xr, double yr, double zr) {
        float aD;
        float a9;
        float a5;
        int xrb = OpenSimplexNoise2S.fastFloor(xr);
        int yrb = OpenSimplexNoise2S.fastFloor(yr);
        int zrb = OpenSimplexNoise2S.fastFloor(zr);
        float xi = (float)(xr - (double)xrb);
        float yi = (float)(yr - (double)yrb);
        float zi = (float)(zr - (double)zrb);
        long xrbp = (long)xrb * 5910200641878280303L;
        long yrbp = (long)yrb * 6452764530575939509L;
        long zrbp = (long)zrb * 6614699811220273867L;
        long seed2 = seed ^ 0xAD2AB84D169129D7L;
        int xNMask = (int)(-0.5f - xi);
        int yNMask = (int)(-0.5f - yi);
        int zNMask = (int)(-0.5f - zi);
        float x0 = xi + (float)xNMask;
        float y0 = yi + (float)yNMask;
        float z0 = zi + (float)zNMask;
        float a0 = 0.75f - x0 * x0 - y0 * y0 - z0 * z0;
        float value = a0 * a0 * (a0 * a0) * OpenSimplexNoise2S.grad(seed, xrbp + ((long)xNMask & 0x5205402B9270C86FL), yrbp + ((long)yNMask & 0x598CD327003817B5L), zrbp + ((long)zNMask & 0x5BCC226E9FA0BACBL), x0, y0, z0);
        float x1 = xi - 0.5f;
        float y1 = yi - 0.5f;
        float z1 = zi - 0.5f;
        float a1 = 0.75f - x1 * x1 - y1 * y1 - z1 * z1;
        value += a1 * a1 * (a1 * a1) * OpenSimplexNoise2S.grad(seed2, xrbp + 5910200641878280303L, yrbp + 6452764530575939509L, zrbp + 6614699811220273867L, x1, y1, z1);
        float xAFlipMask0 = (float)((xNMask | 1) << 1) * x1;
        float yAFlipMask0 = (float)((yNMask | 1) << 1) * y1;
        float zAFlipMask0 = (float)((zNMask | 1) << 1) * z1;
        float xAFlipMask1 = (float)(-2 - (xNMask << 2)) * x1 - 1.0f;
        float yAFlipMask1 = (float)(-2 - (yNMask << 2)) * y1 - 1.0f;
        float zAFlipMask1 = (float)(-2 - (zNMask << 2)) * z1 - 1.0f;
        boolean skip5 = false;
        float a2 = xAFlipMask0 + a0;
        if (a2 > 0.0f) {
            float x2 = x0 - (float)(xNMask | 1);
            float y2 = y0;
            float z2 = z0;
            value += a2 * a2 * (a2 * a2) * OpenSimplexNoise2S.grad(seed, xrbp + ((long)(~xNMask) & 0x5205402B9270C86FL), yrbp + ((long)yNMask & 0x598CD327003817B5L), zrbp + ((long)zNMask & 0x5BCC226E9FA0BACBL), x2, y2, z2);
        } else {
            float a4;
            float a3 = yAFlipMask0 + zAFlipMask0 + a0;
            if (a3 > 0.0f) {
                float x3 = x0;
                float y3 = y0 - (float)(yNMask | 1);
                float z3 = z0 - (float)(zNMask | 1);
                value += a3 * a3 * (a3 * a3) * OpenSimplexNoise2S.grad(seed, xrbp + ((long)xNMask & 0x5205402B9270C86FL), yrbp + ((long)(~yNMask) & 0x598CD327003817B5L), zrbp + ((long)(~zNMask) & 0x5BCC226E9FA0BACBL), x3, y3, z3);
            }
            if ((a4 = xAFlipMask1 + a1) > 0.0f) {
                float x4 = (float)(xNMask | 1) + x1;
                float y4 = y1;
                float z4 = z1;
                value += a4 * a4 * (a4 * a4) * OpenSimplexNoise2S.grad(seed2, xrbp + ((long)xNMask & 0xA40A805724E190DEL), yrbp + 6452764530575939509L, zrbp + 6614699811220273867L, x4, y4, z4);
                skip5 = true;
            }
        }
        boolean skip9 = false;
        float a6 = yAFlipMask0 + a0;
        if (a6 > 0.0f) {
            float x6 = x0;
            float y6 = y0 - (float)(yNMask | 1);
            float z6 = z0;
            value += a6 * a6 * (a6 * a6) * OpenSimplexNoise2S.grad(seed, xrbp + ((long)xNMask & 0x5205402B9270C86FL), yrbp + ((long)(~yNMask) & 0x598CD327003817B5L), zrbp + ((long)zNMask & 0x5BCC226E9FA0BACBL), x6, y6, z6);
        } else {
            float a8;
            float a7 = xAFlipMask0 + zAFlipMask0 + a0;
            if (a7 > 0.0f) {
                float x7 = x0 - (float)(xNMask | 1);
                float y7 = y0;
                float z7 = z0 - (float)(zNMask | 1);
                value += a7 * a7 * (a7 * a7) * OpenSimplexNoise2S.grad(seed, xrbp + ((long)(~xNMask) & 0x5205402B9270C86FL), yrbp + ((long)yNMask & 0x598CD327003817B5L), zrbp + ((long)(~zNMask) & 0x5BCC226E9FA0BACBL), x7, y7, z7);
            }
            if ((a8 = yAFlipMask1 + a1) > 0.0f) {
                float x8 = x1;
                float y8 = (float)(yNMask | 1) + y1;
                float z8 = z1;
                value += a8 * a8 * (a8 * a8) * OpenSimplexNoise2S.grad(seed2, xrbp + 5910200641878280303L, yrbp + ((long)yNMask & 0xB319A64E00702F6AL), zrbp + 6614699811220273867L, x8, y8, z8);
                skip9 = true;
            }
        }
        boolean skipD = false;
        float aA = zAFlipMask0 + a0;
        if (aA > 0.0f) {
            float xA = x0;
            float yA = y0;
            float zA = z0 - (float)(zNMask | 1);
            value += aA * aA * (aA * aA) * OpenSimplexNoise2S.grad(seed, xrbp + ((long)xNMask & 0x5205402B9270C86FL), yrbp + ((long)yNMask & 0x598CD327003817B5L), zrbp + ((long)(~zNMask) & 0x5BCC226E9FA0BACBL), xA, yA, zA);
        } else {
            float aC;
            float aB = xAFlipMask0 + yAFlipMask0 + a0;
            if (aB > 0.0f) {
                float xB = x0 - (float)(xNMask | 1);
                float yB = y0 - (float)(yNMask | 1);
                float zB = z0;
                value += aB * aB * (aB * aB) * OpenSimplexNoise2S.grad(seed, xrbp + ((long)(~xNMask) & 0x5205402B9270C86FL), yrbp + ((long)(~yNMask) & 0x598CD327003817B5L), zrbp + ((long)zNMask & 0x5BCC226E9FA0BACBL), xB, yB, zB);
            }
            if ((aC = zAFlipMask1 + a1) > 0.0f) {
                float xC = x1;
                float yC = y1;
                float zC = (float)(zNMask | 1) + z1;
                value += aC * aC * (aC * aC) * OpenSimplexNoise2S.grad(seed2, xrbp + 5910200641878280303L, yrbp + 6452764530575939509L, zrbp + ((long)zNMask & 0xB79844DD3F417596L), xC, yC, zC);
                skipD = true;
            }
        }
        if (!skip5 && (a5 = yAFlipMask1 + zAFlipMask1 + a1) > 0.0f) {
            float x5 = x1;
            float y5 = (float)(yNMask | 1) + y1;
            float z5 = (float)(zNMask | 1) + z1;
            value += a5 * a5 * (a5 * a5) * OpenSimplexNoise2S.grad(seed2, xrbp + 5910200641878280303L, yrbp + ((long)yNMask & 0xB319A64E00702F6AL), zrbp + ((long)zNMask & 0xB79844DD3F417596L), x5, y5, z5);
        }
        if (!skip9 && (a9 = xAFlipMask1 + zAFlipMask1 + a1) > 0.0f) {
            float x9 = (float)(xNMask | 1) + x1;
            float y9 = y1;
            float z9 = (float)(zNMask | 1) + z1;
            value += a9 * a9 * (a9 * a9) * OpenSimplexNoise2S.grad(seed2, xrbp + ((long)xNMask & 0xA40A805724E190DEL), yrbp + 6452764530575939509L, zrbp + ((long)zNMask & 0xB79844DD3F417596L), x9, y9, z9);
        }
        if (!skipD && (aD = xAFlipMask1 + yAFlipMask1 + a1) > 0.0f) {
            float xD = (float)(xNMask | 1) + x1;
            float yD = (float)(yNMask | 1) + y1;
            float zD = z1;
            value += aD * aD * (aD * aD) * OpenSimplexNoise2S.grad(seed2, xrbp + ((long)xNMask & 0xA40A805724E190DEL), yrbp + ((long)yNMask & 0xB319A64E00702F6AL), zrbp + 6614699811220273867L, xD, yD, zD);
        }
        return value;
    }

    public static float noise4_ImproveXYZ_ImproveXY(long seed, double x, double y, double z, double w) {
        double xy = x + y;
        double s2 = xy * -0.211324865405187;
        double zz = z * 0.2886751345948129;
        double ww = w * 1.118033988749894;
        double xr = x + (zz + ww + s2);
        double yr = y + (zz + ww + s2);
        double zr = xy * -0.577350269189626 + (zz + ww);
        double wr = z * -0.866025403784439 + ww;
        return OpenSimplexNoise2S.noise4_UnskewedBase(seed, xr, yr, zr, wr);
    }

    public static float noise4_ImproveXYZ_ImproveXZ(long seed, double x, double y, double z, double w) {
        double xz = x + z;
        double s2 = xz * -0.211324865405187;
        double yy = y * 0.2886751345948129;
        double ww = w * 1.118033988749894;
        double xr = x + (yy + ww + s2);
        double zr = z + (yy + ww + s2);
        double yr = xz * -0.577350269189626 + (yy + ww);
        double wr = y * -0.866025403784439 + ww;
        return OpenSimplexNoise2S.noise4_UnskewedBase(seed, xr, yr, zr, wr);
    }

    public static float noise4_ImproveXYZ(long seed, double x, double y, double z, double w) {
        double xyz = x + y + z;
        double ww = w * 1.118033988749894;
        double s2 = xyz * -0.16666666666666666 + ww;
        double xs = x + s2;
        double ys = y + s2;
        double zs = z + s2;
        double ws = -0.5 * xyz + ww;
        return OpenSimplexNoise2S.noise4_UnskewedBase(seed, xs, ys, zs, ws);
    }

    public static float noise4_ImproveXY_ImproveZW(long seed, double x, double y, double z, double w) {
        double s2 = (x + y) * -0.2852251398743488 + (z + w) * 0.8389706547061143;
        double t2 = (z + w) * 0.21939749883706436 + (x + y) * -0.48214856493302477;
        double xs = x + s2;
        double ys = y + s2;
        double zs = z + t2;
        double ws = w + t2;
        return OpenSimplexNoise2S.noise4_UnskewedBase(seed, xs, ys, zs, ws);
    }

    public static float noise4_Fallback(long seed, double x, double y, double z, double w) {
        double s = (double)0.309017f * (x + y + z + w);
        double xs = x + s;
        double ys = y + s;
        double zs = z + s;
        double ws = w + s;
        return OpenSimplexNoise2S.noise4_UnskewedBase(seed, xs, ys, zs, ws);
    }

    private static float noise4_UnskewedBase(long seed, double xs, double ys, double zs, double ws) {
        int xsb = OpenSimplexNoise2S.fastFloor(xs);
        int ysb = OpenSimplexNoise2S.fastFloor(ys);
        int zsb = OpenSimplexNoise2S.fastFloor(zs);
        int wsb = OpenSimplexNoise2S.fastFloor(ws);
        float xsi = (float)(xs - (double)xsb);
        float ysi = (float)(ys - (double)ysb);
        float zsi = (float)(zs - (double)zsb);
        float wsi = (float)(ws - (double)wsb);
        float ssi = (xsi + ysi + zsi + wsi) * -0.1381966f;
        float xi = xsi + ssi;
        float yi = ysi + ssi;
        float zi = zsi + ssi;
        float wi = wsi + ssi;
        long xsvp = (long)xsb * 5910200641878280303L;
        long ysvp = (long)ysb * 6452764530575939509L;
        long zsvp = (long)zsb * 6614699811220273867L;
        long wsvp = (long)wsb * 6254464313819354443L;
        int index = (OpenSimplexNoise2S.fastFloor(xs * 4.0) & 3) << 0 | (OpenSimplexNoise2S.fastFloor(ys * 4.0) & 3) << 2 | (OpenSimplexNoise2S.fastFloor(zs * 4.0) & 3) << 4 | (OpenSimplexNoise2S.fastFloor(ws * 4.0) & 3) << 6;
        float value = 0.0f;
        int secondaryIndexStartAndStop = LOOKUP_4D_A[index];
        int secondaryIndexStart = secondaryIndexStartAndStop & 0xFFFF;
        int secondaryIndexStop = secondaryIndexStartAndStop >> 16;
        for (int i = secondaryIndexStart; i < secondaryIndexStop; ++i) {
            LatticeVertex4D c = LOOKUP_4D_B[i];
            float dx = xi + c.dx;
            float dy = yi + c.dy;
            float dz = zi + c.dz;
            float dw = wi + c.dw;
            float a = dx * dx + dy * dy + (dz * dz + dw * dw);
            if (!(a < 0.8f)) continue;
            a -= 0.8f;
            a *= a;
            value += a * a * OpenSimplexNoise2S.grad(seed, xsvp + c.xsvp, ysvp + c.ysvp, zsvp + c.zsvp, wsvp + c.wsvp, dx, dy, dz, dw);
        }
        return value;
    }

    private static float grad(long seed, long xsvp, long ysvp, float dx, float dy) {
        long hash = seed ^ xsvp ^ ysvp;
        hash *= 6026932503003350773L;
        hash ^= hash >> 58;
        int gi = (int)hash & 0xFE;
        return GRADIENTS_2D[gi | 0] * dx + GRADIENTS_2D[gi | 1] * dy;
    }

    private static float grad(long seed, long xrvp, long yrvp, long zrvp, float dx, float dy, float dz) {
        long hash = seed ^ xrvp ^ (yrvp ^ zrvp);
        hash *= 6026932503003350773L;
        hash ^= hash >> 58;
        int gi = (int)hash & 0x3FC;
        return GRADIENTS_3D[gi | 0] * dx + GRADIENTS_3D[gi | 1] * dy + GRADIENTS_3D[gi | 2] * dz;
    }

    private static float grad(long seed, long xsvp, long ysvp, long zsvp, long wsvp, float dx, float dy, float dz, float dw) {
        long hash = seed ^ (xsvp ^ ysvp) ^ (zsvp ^ wsvp);
        hash *= 6026932503003350773L;
        hash ^= hash >> 57;
        int gi = (int)hash & 0x7FC;
        return GRADIENTS_4D[gi | 0] * dx + GRADIENTS_4D[gi | 1] * dy + (GRADIENTS_4D[gi | 2] * dz + GRADIENTS_4D[gi | 3] * dw);
    }

    private static int fastFloor(double x) {
        int xi = (int)x;
        return x < (double)xi ? xi - 1 : xi;
    }

    /*
     * Opcode count of 18967 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        int i;
        int i2;
        int i3;
        int i4;
        GRADIENTS_2D = new float[256];
        float[] grad2 = new float[]{0.38268343f, 0.9238795f, 0.9238795f, 0.38268343f, 0.9238795f, -0.38268343f, 0.38268343f, -0.9238795f, -0.38268343f, -0.9238795f, -0.9238795f, -0.38268343f, -0.9238795f, 0.38268343f, -0.38268343f, 0.9238795f, 0.13052619f, 0.9914449f, 0.6087614f, 0.7933533f, 0.7933533f, 0.6087614f, 0.9914449f, 0.13052619f, 0.9914449f, -0.13052619f, 0.7933533f, -0.6087614f, 0.6087614f, -0.7933533f, 0.13052619f, -0.9914449f, -0.13052619f, -0.9914449f, -0.6087614f, -0.7933533f, -0.7933533f, -0.6087614f, -0.9914449f, -0.13052619f, -0.9914449f, 0.13052619f, -0.7933533f, 0.6087614f, -0.6087614f, 0.7933533f, -0.13052619f, 0.9914449f};
        for (i4 = 0; i4 < grad2.length; ++i4) {
            grad2[i4] = (float)((double)grad2[i4] / 0.05481866495625118);
        }
        i4 = 0;
        int j = 0;
        while (i4 < GRADIENTS_2D.length) {
            if (j == grad2.length) {
                j = 0;
            }
            OpenSimplexNoise2S.GRADIENTS_2D[i4] = grad2[j];
            ++i4;
            ++j;
        }
        GRADIENTS_3D = new float[1024];
        float[] grad3 = new float[]{2.2247448f, 2.2247448f, -1.0f, 0.0f, 2.2247448f, 2.2247448f, 1.0f, 0.0f, 3.0862665f, 1.1721513f, 0.0f, 0.0f, 1.1721513f, 3.0862665f, 0.0f, 0.0f, -2.2247448f, 2.2247448f, -1.0f, 0.0f, -2.2247448f, 2.2247448f, 1.0f, 0.0f, -1.1721513f, 3.0862665f, 0.0f, 0.0f, -3.0862665f, 1.1721513f, 0.0f, 0.0f, -1.0f, -2.2247448f, -2.2247448f, 0.0f, 1.0f, -2.2247448f, -2.2247448f, 0.0f, 0.0f, -3.0862665f, -1.1721513f, 0.0f, 0.0f, -1.1721513f, -3.0862665f, 0.0f, -1.0f, -2.2247448f, 2.2247448f, 0.0f, 1.0f, -2.2247448f, 2.2247448f, 0.0f, 0.0f, -1.1721513f, 3.0862665f, 0.0f, 0.0f, -3.0862665f, 1.1721513f, 0.0f, -2.2247448f, -2.2247448f, -1.0f, 0.0f, -2.2247448f, -2.2247448f, 1.0f, 0.0f, -3.0862665f, -1.1721513f, 0.0f, 0.0f, -1.1721513f, -3.0862665f, 0.0f, 0.0f, -2.2247448f, -1.0f, -2.2247448f, 0.0f, -2.2247448f, 1.0f, -2.2247448f, 0.0f, -1.1721513f, 0.0f, -3.0862665f, 0.0f, -3.0862665f, 0.0f, -1.1721513f, 0.0f, -2.2247448f, -1.0f, 2.2247448f, 0.0f, -2.2247448f, 1.0f, 2.2247448f, 0.0f, -3.0862665f, 0.0f, 1.1721513f, 0.0f, -1.1721513f, 0.0f, 3.0862665f, 0.0f, -1.0f, 2.2247448f, -2.2247448f, 0.0f, 1.0f, 2.2247448f, -2.2247448f, 0.0f, 0.0f, 1.1721513f, -3.0862665f, 0.0f, 0.0f, 3.0862665f, -1.1721513f, 0.0f, -1.0f, 2.2247448f, 2.2247448f, 0.0f, 1.0f, 2.2247448f, 2.2247448f, 0.0f, 0.0f, 3.0862665f, 1.1721513f, 0.0f, 0.0f, 1.1721513f, 3.0862665f, 0.0f, 2.2247448f, -2.2247448f, -1.0f, 0.0f, 2.2247448f, -2.2247448f, 1.0f, 0.0f, 1.1721513f, -3.0862665f, 0.0f, 0.0f, 3.0862665f, -1.1721513f, 0.0f, 0.0f, 2.2247448f, -1.0f, -2.2247448f, 0.0f, 2.2247448f, 1.0f, -2.2247448f, 0.0f, 3.0862665f, 0.0f, -1.1721513f, 0.0f, 1.1721513f, 0.0f, -3.0862665f, 0.0f, 2.2247448f, -1.0f, 2.2247448f, 0.0f, 2.2247448f, 1.0f, 2.2247448f, 0.0f, 1.1721513f, 0.0f, 3.0862665f, 0.0f, 3.0862665f, 0.0f, 1.1721513f, 0.0f};
        for (i3 = 0; i3 < grad3.length; ++i3) {
            grad3[i3] = (float)((double)grad3[i3] / 0.2781926117527186);
        }
        i3 = 0;
        int j2 = 0;
        while (i3 < GRADIENTS_3D.length) {
            if (j2 == grad3.length) {
                j2 = 0;
            }
            OpenSimplexNoise2S.GRADIENTS_3D[i3] = grad3[j2];
            ++i3;
            ++j2;
        }
        GRADIENTS_4D = new float[2048];
        float[] grad4 = new float[]{-0.6740059f, -0.32398477f, -0.32398477f, 0.5794685f, -0.7504884f, -0.40046722f, 0.15296486f, 0.502986f, -0.7504884f, 0.15296486f, -0.40046722f, 0.502986f, -0.8828162f, 0.08164729f, 0.08164729f, 0.4553054f, -0.4553054f, -0.08164729f, -0.08164729f, 0.8828162f, -0.502986f, -0.15296486f, 0.40046722f, 0.7504884f, -0.502986f, 0.40046722f, -0.15296486f, 0.7504884f, -0.5794685f, 0.32398477f, 0.32398477f, 0.6740059f, -0.6740059f, -0.32398477f, 0.5794685f, -0.32398477f, -0.7504884f, -0.40046722f, 0.502986f, 0.15296486f, -0.7504884f, 0.15296486f, 0.502986f, -0.40046722f, -0.8828162f, 0.08164729f, 0.4553054f, 0.08164729f, -0.4553054f, -0.08164729f, 0.8828162f, -0.08164729f, -0.502986f, -0.15296486f, 0.7504884f, 0.40046722f, -0.502986f, 0.40046722f, 0.7504884f, -0.15296486f, -0.5794685f, 0.32398477f, 0.6740059f, 0.32398477f, -0.6740059f, 0.5794685f, -0.32398477f, -0.32398477f, -0.7504884f, 0.502986f, -0.40046722f, 0.15296486f, -0.7504884f, 0.502986f, 0.15296486f, -0.40046722f, -0.8828162f, 0.4553054f, 0.08164729f, 0.08164729f, -0.4553054f, 0.8828162f, -0.08164729f, -0.08164729f, -0.502986f, 0.7504884f, -0.15296486f, 0.40046722f, -0.502986f, 0.7504884f, 0.40046722f, -0.15296486f, -0.5794685f, 0.6740059f, 0.32398477f, 0.32398477f, 0.5794685f, -0.6740059f, -0.32398477f, -0.32398477f, 0.502986f, -0.7504884f, -0.40046722f, 0.15296486f, 0.502986f, -0.7504884f, 0.15296486f, -0.40046722f, 0.4553054f, -0.8828162f, 0.08164729f, 0.08164729f, 0.8828162f, -0.4553054f, -0.08164729f, -0.08164729f, 0.7504884f, -0.502986f, -0.15296486f, 0.40046722f, 0.7504884f, -0.502986f, 0.40046722f, -0.15296486f, 0.6740059f, -0.5794685f, 0.32398477f, 0.32398477f, -0.753341f, -0.3796829f, -0.3796829f, -0.3796829f, -0.78216845f, -0.43214726f, -0.43214726f, 0.121284805f, -0.78216845f, -0.43214726f, 0.121284805f, -0.43214726f, -0.78216845f, 0.121284805f, -0.43214726f, -0.43214726f, -0.85865086f, -0.5086297f, 0.04480237f, 0.04480237f, -0.85865086f, 0.04480237f, -0.5086297f, 0.04480237f, -0.85865086f, 0.04480237f, 0.04480237f, -0.5086297f, -0.9982829f, -0.033819415f, -0.033819415f, -0.033819415f, -0.3796829f, -0.753341f, -0.3796829f, -0.3796829f, -0.43214726f, -0.78216845f, -0.43214726f, 0.121284805f, -0.43214726f, -0.78216845f, 0.121284805f, -0.43214726f, 0.121284805f, -0.78216845f, -0.43214726f, -0.43214726f, -0.5086297f, -0.85865086f, 0.04480237f, 0.04480237f, 0.04480237f, -0.85865086f, -0.5086297f, 0.04480237f, 0.04480237f, -0.85865086f, 0.04480237f, -0.5086297f, -0.033819415f, -0.9982829f, -0.033819415f, -0.033819415f, -0.3796829f, -0.3796829f, -0.753341f, -0.3796829f, -0.43214726f, -0.43214726f, -0.78216845f, 0.121284805f, -0.43214726f, 0.121284805f, -0.78216845f, -0.43214726f, 0.121284805f, -0.43214726f, -0.78216845f, -0.43214726f, -0.5086297f, 0.04480237f, -0.85865086f, 0.04480237f, 0.04480237f, -0.5086297f, -0.85865086f, 0.04480237f, 0.04480237f, 0.04480237f, -0.85865086f, -0.5086297f, -0.033819415f, -0.033819415f, -0.9982829f, -0.033819415f, -0.3796829f, -0.3796829f, -0.3796829f, -0.753341f, -0.43214726f, -0.43214726f, 0.121284805f, -0.78216845f, -0.43214726f, 0.121284805f, -0.43214726f, -0.78216845f, 0.121284805f, -0.43214726f, -0.43214726f, -0.78216845f, -0.5086297f, 0.04480237f, 0.04480237f, -0.85865086f, 0.04480237f, -0.5086297f, 0.04480237f, -0.85865086f, 0.04480237f, 0.04480237f, -0.5086297f, -0.85865086f, -0.033819415f, -0.033819415f, -0.033819415f, -0.9982829f, -0.32398477f, -0.6740059f, -0.32398477f, 0.5794685f, -0.40046722f, -0.7504884f, 0.15296486f, 0.502986f, 0.15296486f, -0.7504884f, -0.40046722f, 0.502986f, 0.08164729f, -0.8828162f, 0.08164729f, 0.4553054f, -0.08164729f, -0.4553054f, -0.08164729f, 0.8828162f, -0.15296486f, -0.502986f, 0.40046722f, 0.7504884f, 0.40046722f, -0.502986f, -0.15296486f, 0.7504884f, 0.32398477f, -0.5794685f, 0.32398477f, 0.6740059f, -0.32398477f, -0.32398477f, -0.6740059f, 0.5794685f, -0.40046722f, 0.15296486f, -0.7504884f, 0.502986f, 0.15296486f, -0.40046722f, -0.7504884f, 0.502986f, 0.08164729f, 0.08164729f, -0.8828162f, 0.4553054f, -0.08164729f, -0.08164729f, -0.4553054f, 0.8828162f, -0.15296486f, 0.40046722f, -0.502986f, 0.7504884f, 0.40046722f, -0.15296486f, -0.502986f, 0.7504884f, 0.32398477f, 0.32398477f, -0.5794685f, 0.6740059f, -0.32398477f, -0.6740059f, 0.5794685f, -0.32398477f, -0.40046722f, -0.7504884f, 0.502986f, 0.15296486f, 0.15296486f, -0.7504884f, 0.502986f, -0.40046722f, 0.08164729f, -0.8828162f, 0.4553054f, 0.08164729f, -0.08164729f, -0.4553054f, 0.8828162f, -0.08164729f, -0.15296486f, -0.502986f, 0.7504884f, 0.40046722f, 0.40046722f, -0.502986f, 0.7504884f, -0.15296486f, 0.32398477f, -0.5794685f, 0.6740059f, 0.32398477f, -0.32398477f, -0.32398477f, 0.5794685f, -0.6740059f, -0.40046722f, 0.15296486f, 0.502986f, -0.7504884f, 0.15296486f, -0.40046722f, 0.502986f, -0.7504884f, 0.08164729f, 0.08164729f, 0.4553054f, -0.8828162f, -0.08164729f, -0.08164729f, 0.8828162f, -0.4553054f, -0.15296486f, 0.40046722f, 0.7504884f, -0.502986f, 0.40046722f, -0.15296486f, 0.7504884f, -0.502986f, 0.32398477f, 0.32398477f, 0.6740059f, -0.5794685f, -0.32398477f, 0.5794685f, -0.6740059f, -0.32398477f, -0.40046722f, 0.502986f, -0.7504884f, 0.15296486f, 0.15296486f, 0.502986f, -0.7504884f, -0.40046722f, 0.08164729f, 0.4553054f, -0.8828162f, 0.08164729f, -0.08164729f, 0.8828162f, -0.4553054f, -0.08164729f, -0.15296486f, 0.7504884f, -0.502986f, 0.40046722f, 0.40046722f, 0.7504884f, -0.502986f, -0.15296486f, 0.32398477f, 0.6740059f, -0.5794685f, 0.32398477f, -0.32398477f, 0.5794685f, -0.32398477f, -0.6740059f, -0.40046722f, 0.502986f, 0.15296486f, -0.7504884f, 0.15296486f, 0.502986f, -0.40046722f, -0.7504884f, 0.08164729f, 0.4553054f, 0.08164729f, -0.8828162f, -0.08164729f, 0.8828162f, -0.08164729f, -0.4553054f, -0.15296486f, 0.7504884f, 0.40046722f, -0.502986f, 0.40046722f, 0.7504884f, -0.15296486f, -0.502986f, 0.32398477f, 0.6740059f, 0.32398477f, -0.5794685f, 0.5794685f, -0.32398477f, -0.6740059f, -0.32398477f, 0.502986f, -0.40046722f, -0.7504884f, 0.15296486f, 0.502986f, 0.15296486f, -0.7504884f, -0.40046722f, 0.4553054f, 0.08164729f, -0.8828162f, 0.08164729f, 0.8828162f, -0.08164729f, -0.4553054f, -0.08164729f, 0.7504884f, -0.15296486f, -0.502986f, 0.40046722f, 0.7504884f, 0.40046722f, -0.502986f, -0.15296486f, 0.6740059f, 0.32398477f, -0.5794685f, 0.32398477f, 0.5794685f, -0.32398477f, -0.32398477f, -0.6740059f, 0.502986f, -0.40046722f, 0.15296486f, -0.7504884f, 0.502986f, 0.15296486f, -0.40046722f, -0.7504884f, 0.4553054f, 0.08164729f, 0.08164729f, -0.8828162f, 0.8828162f, -0.08164729f, -0.08164729f, -0.4553054f, 0.7504884f, -0.15296486f, 0.40046722f, -0.502986f, 0.7504884f, 0.40046722f, -0.15296486f, -0.502986f, 0.6740059f, 0.32398477f, 0.32398477f, -0.5794685f, 0.033819415f, 0.033819415f, 0.033819415f, 0.9982829f, -0.04480237f, -0.04480237f, 0.5086297f, 0.85865086f, -0.04480237f, 0.5086297f, -0.04480237f, 0.85865086f, -0.121284805f, 0.43214726f, 0.43214726f, 0.78216845f, 0.5086297f, -0.04480237f, -0.04480237f, 0.85865086f, 0.43214726f, -0.121284805f, 0.43214726f, 0.78216845f, 0.43214726f, 0.43214726f, -0.121284805f, 0.78216845f, 0.3796829f, 0.3796829f, 0.3796829f, 0.753341f, 0.033819415f, 0.033819415f, 0.9982829f, 0.033819415f, -0.04480237f, 0.04480237f, 0.85865086f, 0.5086297f, -0.04480237f, 0.5086297f, 0.85865086f, -0.04480237f, -0.121284805f, 0.43214726f, 0.78216845f, 0.43214726f, 0.5086297f, -0.04480237f, 0.85865086f, -0.04480237f, 0.43214726f, -0.121284805f, 0.78216845f, 0.43214726f, 0.43214726f, 0.43214726f, 0.78216845f, -0.121284805f, 0.3796829f, 0.3796829f, 0.753341f, 0.3796829f, 0.033819415f, 0.9982829f, 0.033819415f, 0.033819415f, -0.04480237f, 0.85865086f, -0.04480237f, 0.5086297f, -0.04480237f, 0.85865086f, 0.5086297f, -0.04480237f, -0.121284805f, 0.78216845f, 0.43214726f, 0.43214726f, 0.5086297f, 0.85865086f, -0.04480237f, -0.04480237f, 0.43214726f, 0.78216845f, -0.121284805f, 0.43214726f, 0.43214726f, 0.78216845f, 0.43214726f, -0.121284805f, 0.3796829f, 0.753341f, 0.3796829f, 0.3796829f, 0.9982829f, 0.033819415f, 0.033819415f, 0.033819415f, 0.85865086f, -0.04480237f, -0.04480237f, 0.5086297f, 0.85865086f, -0.04480237f, 0.5086297f, -0.04480237f, 0.78216845f, -0.121284805f, 0.43214726f, 0.43214726f, 0.85865086f, 0.5086297f, -0.04480237f, -0.04480237f, 0.78216845f, 0.43214726f, -0.121284805f, 0.43214726f, 0.78216845f, 0.43214726f, 0.43214726f, -0.121284805f, 0.753341f, 0.3796829f, 0.3796829f, 0.3796829f};
        for (i2 = 0; i2 < grad4.length; ++i2) {
            grad4[i2] = (float)((double)grad4[i2] / 0.11127401889945551);
        }
        i2 = 0;
        int j3 = 0;
        while (i2 < GRADIENTS_4D.length) {
            if (j3 == grad4.length) {
                j3 = 0;
            }
            OpenSimplexNoise2S.GRADIENTS_4D[i2] = grad4[j3];
            ++i2;
            ++j3;
        }
        int[][] lookup4DVertexCodes = new int[][]{{21, 69, 81, 84, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170}, {21, 69, 81, 85, 86, 89, 90, 101, 102, 106, 149, 150, 154, 166, 170}, {1, 5, 17, 21, 65, 69, 81, 85, 86, 90, 102, 106, 150, 154, 166, 170}, {1, 21, 22, 69, 70, 81, 82, 85, 86, 90, 102, 106, 150, 154, 166, 170, 171}, {21, 69, 84, 85, 86, 89, 90, 101, 105, 106, 149, 153, 154, 169, 170}, {5, 21, 69, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 170}, {5, 21, 69, 85, 86, 89, 90, 102, 106, 150, 154, 170}, {5, 21, 22, 69, 70, 85, 86, 89, 90, 102, 106, 150, 154, 170, 171}, {4, 5, 20, 21, 68, 69, 84, 85, 89, 90, 105, 106, 153, 154, 169, 170}, {5, 21, 69, 85, 86, 89, 90, 105, 106, 153, 154, 170}, {5, 21, 69, 85, 86, 89, 90, 106, 154, 170}, {5, 21, 22, 69, 70, 85, 86, 89, 90, 91, 106, 154, 170, 171}, {4, 21, 25, 69, 73, 84, 85, 88, 89, 90, 105, 106, 153, 154, 169, 170, 174}, {5, 21, 25, 69, 73, 85, 86, 89, 90, 105, 106, 153, 154, 170, 174}, {5, 21, 25, 69, 73, 85, 86, 89, 90, 94, 106, 154, 170, 174}, {5, 21, 26, 69, 74, 85, 86, 89, 90, 91, 94, 106, 154, 170, 171, 174, 175}, {21, 81, 84, 85, 86, 89, 101, 102, 105, 106, 149, 165, 166, 169, 170}, {17, 21, 81, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 165, 166, 170}, {17, 21, 81, 85, 86, 90, 101, 102, 106, 150, 166, 170}, {17, 21, 22, 81, 82, 85, 86, 90, 101, 102, 106, 150, 166, 170, 171}, {20, 21, 84, 85, 86, 89, 90, 101, 102, 105, 106, 149, 153, 165, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 149, 154, 166, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 150, 154, 166, 170, 171}, {21, 22, 85, 86, 90, 102, 106, 107, 150, 154, 166, 170, 171}, {20, 21, 84, 85, 89, 90, 101, 105, 106, 153, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 153, 154, 169, 170, 174}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 154, 170}, {21, 22, 85, 86, 89, 90, 102, 106, 107, 154, 170, 171}, {20, 21, 25, 84, 85, 88, 89, 90, 101, 105, 106, 153, 169, 170, 174}, {21, 25, 85, 89, 90, 105, 106, 110, 153, 154, 169, 170, 174}, {21, 25, 85, 86, 89, 90, 105, 106, 110, 154, 170, 174}, {21, 26, 85, 86, 89, 90, 106, 107, 110, 154, 170, 171, 174, 175}, {16, 17, 20, 21, 80, 81, 84, 85, 101, 102, 105, 106, 165, 166, 169, 170}, {17, 21, 81, 85, 86, 101, 102, 105, 106, 165, 166, 170}, {17, 21, 81, 85, 86, 101, 102, 106, 166, 170}, {17, 21, 22, 81, 82, 85, 86, 101, 102, 103, 106, 166, 170, 171}, {20, 21, 84, 85, 89, 101, 102, 105, 106, 165, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 166, 170}, {21, 22, 85, 86, 90, 101, 102, 106, 107, 166, 170, 171}, {20, 21, 84, 85, 89, 101, 105, 106, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 170}, {21, 22, 85, 86, 89, 90, 101, 102, 105, 106, 107, 170, 171}, {20, 21, 25, 84, 85, 88, 89, 101, 105, 106, 109, 169, 170, 174}, {21, 25, 85, 89, 90, 101, 105, 106, 110, 169, 170, 174}, {21, 25, 85, 86, 89, 90, 101, 102, 105, 106, 110, 170, 174}, {21, 85, 86, 89, 90, 102, 105, 106, 107, 110, 154, 170, 171, 174, 175}, {16, 21, 37, 81, 84, 85, 97, 100, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {17, 21, 37, 81, 85, 86, 97, 101, 102, 105, 106, 165, 166, 170, 186}, {17, 21, 37, 81, 85, 86, 97, 101, 102, 106, 118, 166, 170, 186}, {17, 21, 38, 81, 85, 86, 98, 101, 102, 103, 106, 118, 166, 170, 171, 186, 187}, {20, 21, 37, 84, 85, 89, 100, 101, 102, 105, 106, 165, 169, 170, 186}, {21, 37, 85, 101, 102, 105, 106, 122, 165, 166, 169, 170, 186}, {21, 37, 85, 86, 101, 102, 105, 106, 122, 166, 170, 186}, {21, 38, 85, 86, 101, 102, 106, 107, 122, 166, 170, 171, 186, 187}, {20, 21, 37, 84, 85, 89, 100, 101, 105, 106, 121, 169, 170, 186}, {21, 37, 85, 89, 101, 102, 105, 106, 122, 169, 170, 186}, {21, 37, 85, 86, 89, 90, 101, 102, 105, 106, 122, 170, 186}, {21, 85, 86, 90, 101, 102, 105, 106, 107, 122, 166, 170, 171, 186, 187}, {20, 21, 41, 84, 85, 89, 101, 104, 105, 106, 109, 121, 169, 170, 174, 186, 190}, {21, 41, 85, 89, 101, 105, 106, 110, 122, 169, 170, 174, 186, 190}, {21, 85, 89, 90, 101, 102, 105, 106, 110, 122, 169, 170, 174, 186, 190}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 107, 110, 122, 170, 171, 174, 186, 191}, {69, 81, 84, 85, 86, 89, 101, 149, 150, 153, 154, 165, 166, 169, 170}, {65, 69, 81, 85, 86, 89, 90, 101, 102, 149, 150, 153, 154, 165, 166, 170}, {65, 69, 81, 85, 86, 90, 102, 149, 150, 154, 166, 170}, {65, 69, 70, 81, 82, 85, 86, 90, 102, 149, 150, 154, 166, 170, 171}, {68, 69, 84, 85, 86, 89, 90, 101, 105, 149, 150, 153, 154, 165, 169, 170}, {69, 85, 86, 89, 90, 101, 106, 149, 150, 153, 154, 166, 169, 170}, {69, 85, 86, 89, 90, 102, 106, 149, 150, 153, 154, 166, 170, 171}, {69, 70, 85, 86, 90, 102, 106, 150, 154, 155, 166, 170, 171}, {68, 69, 84, 85, 89, 90, 105, 149, 153, 154, 169, 170}, {69, 85, 86, 89, 90, 105, 106, 149, 150, 153, 154, 169, 170, 174}, {69, 85, 86, 89, 90, 106, 149, 150, 153, 154, 170}, {69, 70, 85, 86, 89, 90, 106, 150, 154, 155, 170, 171}, {68, 69, 73, 84, 85, 88, 89, 90, 105, 149, 153, 154, 169, 170, 174}, {69, 73, 85, 89, 90, 105, 106, 153, 154, 158, 169, 170, 174}, {69, 73, 85, 86, 89, 90, 106, 153, 154, 158, 170, 174}, {69, 74, 85, 86, 89, 90, 106, 154, 155, 158, 170, 171, 174, 175}, {80, 81, 84, 85, 86, 89, 101, 102, 105, 149, 150, 153, 165, 166, 169, 170}, {81, 85, 86, 89, 101, 102, 106, 149, 150, 154, 165, 166, 169, 170}, {81, 85, 86, 90, 101, 102, 106, 149, 150, 154, 165, 166, 170, 171}, {81, 82, 85, 86, 90, 102, 106, 150, 154, 166, 167, 170, 171}, {84, 85, 86, 89, 101, 105, 106, 149, 153, 154, 165, 166, 169, 170}, {85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170}, {21, 69, 81, 85, 86, 89, 90, 101, 102, 106, 149, 150, 154, 166, 170, 171}, {85, 86, 90, 102, 106, 150, 154, 166, 170, 171}, {84, 85, 89, 90, 101, 105, 106, 149, 153, 154, 165, 169, 170, 174}, {21, 69, 84, 85, 86, 89, 90, 101, 105, 106, 149, 153, 154, 169, 170, 174}, {21, 69, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 166, 169, 170, 171, 174}, {85, 86, 89, 90, 102, 106, 150, 154, 166, 170, 171}, {84, 85, 88, 89, 90, 105, 106, 153, 154, 169, 170, 173, 174}, {85, 89, 90, 105, 106, 153, 154, 169, 170, 174}, {85, 86, 89, 90, 105, 106, 153, 154, 169, 170, 174}, {85, 86, 89, 90, 106, 154, 170, 171, 174, 175}, {80, 81, 84, 85, 101, 102, 105, 149, 165, 166, 169, 170}, {81, 85, 86, 101, 102, 105, 106, 149, 150, 165, 166, 169, 170, 186}, {81, 85, 86, 101, 102, 106, 149, 150, 165, 166, 170}, {81, 82, 85, 86, 101, 102, 106, 150, 166, 167, 170, 171}, {84, 85, 89, 101, 102, 105, 106, 149, 153, 165, 166, 169, 170, 186}, {21, 81, 84, 85, 86, 89, 101, 102, 105, 106, 149, 165, 166, 169, 170, 186}, {21, 81, 85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 154, 165, 166, 169, 170, 171, 186}, {85, 86, 90, 101, 102, 106, 150, 154, 166, 170, 171}, {84, 85, 89, 101, 105, 106, 149, 153, 165, 169, 170}, {21, 84, 85, 86, 89, 90, 101, 102, 105, 106, 149, 153, 154, 165, 166, 169, 170, 174, 186}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 154, 166, 169, 170}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 150, 154, 166, 170, 171}, {84, 85, 88, 89, 101, 105, 106, 153, 169, 170, 173, 174}, {85, 89, 90, 101, 105, 106, 153, 154, 169, 170, 174}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 153, 154, 169, 170, 174}, {21, 85, 86, 89, 90, 102, 105, 106, 154, 170, 171, 174, 175}, {80, 81, 84, 85, 97, 100, 101, 102, 105, 149, 165, 166, 169, 170, 186}, {81, 85, 97, 101, 102, 105, 106, 165, 166, 169, 170, 182, 186}, {81, 85, 86, 97, 101, 102, 106, 165, 166, 170, 182, 186}, {81, 85, 86, 98, 101, 102, 106, 166, 167, 170, 171, 182, 186, 187}, {84, 85, 100, 101, 102, 105, 106, 165, 166, 169, 170, 185, 186}, {85, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {85, 86, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {85, 86, 101, 102, 106, 166, 170, 171, 186, 187}, {84, 85, 89, 100, 101, 105, 106, 165, 169, 170, 185, 186}, {85, 89, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {21, 85, 86, 89, 90, 101, 102, 105, 106, 165, 166, 169, 170, 186}, {21, 85, 86, 90, 101, 102, 105, 106, 166, 170, 171, 186, 187}, {84, 85, 89, 101, 104, 105, 106, 169, 170, 173, 174, 185, 186, 190}, {85, 89, 101, 105, 106, 169, 170, 174, 186, 190}, {21, 85, 89, 90, 101, 102, 105, 106, 169, 170, 174, 186, 190}, {85, 86, 89, 90, 101, 102, 105, 106, 170, 171, 174, 186, 191}, {64, 65, 68, 69, 80, 81, 84, 85, 149, 150, 153, 154, 165, 166, 169, 170}, {65, 69, 81, 85, 86, 149, 150, 153, 154, 165, 166, 170}, {65, 69, 81, 85, 86, 149, 150, 154, 166, 170}, {65, 69, 70, 81, 82, 85, 86, 149, 150, 151, 154, 166, 170, 171}, {68, 69, 84, 85, 89, 149, 150, 153, 154, 165, 169, 170}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 166, 170}, {69, 70, 85, 86, 90, 149, 150, 154, 155, 166, 170, 171}, {68, 69, 84, 85, 89, 149, 153, 154, 169, 170}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 169, 170}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 170}, {69, 70, 85, 86, 89, 90, 149, 150, 153, 154, 155, 170, 171}, {68, 69, 73, 84, 85, 88, 89, 149, 153, 154, 157, 169, 170, 174}, {69, 73, 85, 89, 90, 149, 153, 154, 158, 169, 170, 174}, {69, 73, 85, 86, 89, 90, 149, 150, 153, 154, 158, 170, 174}, {69, 85, 86, 89, 90, 106, 150, 153, 154, 155, 158, 170, 171, 174, 175}, {80, 81, 84, 85, 101, 149, 150, 153, 165, 166, 169, 170}, {81, 85, 86, 101, 102, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {81, 85, 86, 101, 102, 149, 150, 154, 165, 166, 170}, {81, 82, 85, 86, 102, 149, 150, 154, 166, 167, 170, 171}, {84, 85, 89, 101, 105, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 81, 84, 85, 86, 89, 101, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 81, 85, 86, 89, 90, 101, 102, 106, 149, 150, 153, 154, 165, 166, 169, 170, 171, 234}, {85, 86, 90, 102, 106, 149, 150, 154, 166, 170, 171}, {84, 85, 89, 101, 105, 149, 153, 154, 165, 169, 170}, {69, 84, 85, 86, 89, 90, 101, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 174, 234}, {69, 85, 86, 89, 90, 106, 149, 150, 153, 154, 166, 169, 170}, {69, 85, 86, 89, 90, 102, 106, 149, 150, 153, 154, 166, 170, 171}, {84, 85, 88, 89, 105, 149, 153, 154, 169, 170, 173, 174}, {85, 89, 90, 105, 106, 149, 153, 154, 169, 170, 174}, {69, 85, 86, 89, 90, 105, 106, 149, 150, 153, 154, 169, 170, 174}, {69, 85, 86, 89, 90, 106, 150, 153, 154, 170, 171, 174, 175}, {80, 81, 84, 85, 101, 149, 165, 166, 169, 170}, {81, 85, 86, 101, 102, 149, 150, 165, 166, 169, 170}, {81, 85, 86, 101, 102, 149, 150, 165, 166, 170}, {81, 82, 85, 86, 101, 102, 149, 150, 165, 166, 167, 170, 171}, {84, 85, 89, 101, 105, 149, 153, 165, 166, 169, 170}, {81, 84, 85, 86, 89, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 186, 234}, {81, 85, 86, 101, 102, 106, 149, 150, 154, 165, 166, 169, 170}, {81, 85, 86, 90, 101, 102, 106, 149, 150, 154, 165, 166, 170, 171}, {84, 85, 89, 101, 105, 149, 153, 165, 169, 170}, {84, 85, 89, 101, 105, 106, 149, 153, 154, 165, 166, 169, 170}, {85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170}, {85, 86, 89, 90, 101, 102, 106, 149, 150, 154, 166, 169, 170, 171}, {84, 85, 88, 89, 101, 105, 149, 153, 165, 169, 170, 173, 174}, {84, 85, 89, 90, 101, 105, 106, 149, 153, 154, 165, 169, 170, 174}, {85, 86, 89, 90, 101, 105, 106, 149, 153, 154, 166, 169, 170, 174}, {85, 86, 89, 90, 102, 105, 106, 150, 153, 154, 166, 169, 170, 171, 174, 175}, {80, 81, 84, 85, 97, 100, 101, 149, 165, 166, 169, 170, 181, 186}, {81, 85, 97, 101, 102, 149, 165, 166, 169, 170, 182, 186}, {81, 85, 86, 97, 101, 102, 149, 150, 165, 166, 170, 182, 186}, {81, 85, 86, 101, 102, 106, 150, 165, 166, 167, 170, 171, 182, 186, 187}, {84, 85, 100, 101, 105, 149, 165, 166, 169, 170, 185, 186}, {85, 101, 102, 105, 106, 149, 165, 166, 169, 170, 186}, {81, 85, 86, 101, 102, 105, 106, 149, 150, 165, 166, 169, 170, 186}, {81, 85, 86, 101, 102, 106, 150, 165, 166, 170, 171, 186, 187}, {84, 85, 89, 100, 101, 105, 149, 153, 165, 169, 170, 185, 186}, {84, 85, 89, 101, 102, 105, 106, 149, 153, 165, 166, 169, 170, 186}, {85, 86, 89, 101, 102, 105, 106, 149, 154, 165, 166, 169, 170, 186}, {85, 86, 90, 101, 102, 105, 106, 150, 154, 165, 166, 169, 170, 171, 186, 187}, {84, 85, 89, 101, 105, 106, 153, 165, 169, 170, 173, 174, 185, 186, 190}, {84, 85, 89, 101, 105, 106, 153, 165, 169, 170, 174, 186, 190}, {85, 89, 90, 101, 102, 105, 106, 153, 154, 165, 166, 169, 170, 174, 186, 190}, {85, 86, 89, 90, 101, 102, 105, 106, 154, 166, 169, 170, 171, 174, 186}, {64, 69, 81, 84, 85, 133, 145, 148, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {65, 69, 81, 85, 86, 133, 145, 149, 150, 153, 154, 165, 166, 170, 234}, {65, 69, 81, 85, 86, 133, 145, 149, 150, 154, 166, 170, 214, 234}, {65, 69, 81, 85, 86, 134, 146, 149, 150, 151, 154, 166, 170, 171, 214, 234, 235}, {68, 69, 84, 85, 89, 133, 148, 149, 150, 153, 154, 165, 169, 170, 234}, {69, 85, 133, 149, 150, 153, 154, 165, 166, 169, 170, 218, 234}, {69, 85, 86, 133, 149, 150, 153, 154, 166, 170, 218, 234}, {69, 85, 86, 134, 149, 150, 154, 155, 166, 170, 171, 218, 234, 235}, {68, 69, 84, 85, 89, 133, 148, 149, 153, 154, 169, 170, 217, 234}, {69, 85, 89, 133, 149, 150, 153, 154, 169, 170, 218, 234}, {69, 85, 86, 89, 90, 133, 149, 150, 153, 154, 170, 218, 234}, {69, 85, 86, 90, 149, 150, 153, 154, 155, 166, 170, 171, 218, 234, 235}, {68, 69, 84, 85, 89, 137, 149, 152, 153, 154, 157, 169, 170, 174, 217, 234, 238}, {69, 85, 89, 137, 149, 153, 154, 158, 169, 170, 174, 218, 234, 238}, {69, 85, 89, 90, 149, 150, 153, 154, 158, 169, 170, 174, 218, 234, 238}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 155, 158, 170, 171, 174, 218, 234, 239}, {80, 81, 84, 85, 101, 145, 148, 149, 150, 153, 165, 166, 169, 170, 234}, {81, 85, 145, 149, 150, 153, 154, 165, 166, 169, 170, 230, 234}, {81, 85, 86, 145, 149, 150, 154, 165, 166, 170, 230, 234}, {81, 85, 86, 146, 149, 150, 154, 166, 167, 170, 171, 230, 234, 235}, {84, 85, 148, 149, 150, 153, 154, 165, 166, 169, 170, 233, 234}, {85, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {85, 86, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {85, 86, 149, 150, 154, 166, 170, 171, 234, 235}, {84, 85, 89, 148, 149, 153, 154, 165, 169, 170, 233, 234}, {85, 89, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 85, 86, 89, 90, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {69, 85, 86, 90, 149, 150, 153, 154, 166, 170, 171, 234, 235}, {84, 85, 89, 149, 152, 153, 154, 169, 170, 173, 174, 233, 234, 238}, {85, 89, 149, 153, 154, 169, 170, 174, 234, 238}, {69, 85, 89, 90, 149, 150, 153, 154, 169, 170, 174, 234, 238}, {85, 86, 89, 90, 149, 150, 153, 154, 170, 171, 174, 234, 239}, {80, 81, 84, 85, 101, 145, 148, 149, 165, 166, 169, 170, 229, 234}, {81, 85, 101, 145, 149, 150, 165, 166, 169, 170, 230, 234}, {81, 85, 86, 101, 102, 145, 149, 150, 165, 166, 170, 230, 234}, {81, 85, 86, 102, 149, 150, 154, 165, 166, 167, 170, 171, 230, 234, 235}, {84, 85, 101, 148, 149, 153, 165, 166, 169, 170, 233, 234}, {85, 101, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {81, 85, 86, 101, 102, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {81, 85, 86, 102, 149, 150, 154, 165, 166, 170, 171, 234, 235}, {84, 85, 89, 101, 105, 148, 149, 153, 165, 169, 170, 233, 234}, {84, 85, 89, 101, 105, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {85, 86, 89, 101, 106, 149, 150, 153, 154, 165, 166, 169, 170, 234}, {85, 86, 90, 102, 106, 149, 150, 153, 154, 165, 166, 169, 170, 171, 234, 235}, {84, 85, 89, 105, 149, 153, 154, 165, 169, 170, 173, 174, 233, 234, 238}, {84, 85, 89, 105, 149, 153, 154, 165, 169, 170, 174, 234, 238}, {85, 89, 90, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 174, 234, 238}, {85, 86, 89, 90, 106, 149, 150, 153, 154, 166, 169, 170, 171, 174, 234}, {80, 81, 84, 85, 101, 149, 161, 164, 165, 166, 169, 170, 181, 186, 229, 234, 250}, {81, 85, 101, 149, 161, 165, 166, 169, 170, 182, 186, 230, 234, 250}, {81, 85, 101, 102, 149, 150, 165, 166, 169, 170, 182, 186, 230, 234, 250}, {81, 85, 86, 101, 102, 149, 150, 165, 166, 167, 170, 171, 182, 186, 230, 234, 251}, {84, 85, 101, 149, 164, 165, 166, 169, 170, 185, 186, 233, 234, 250}, {85, 101, 149, 165, 166, 169, 170, 186, 234, 250}, {81, 85, 101, 102, 149, 150, 165, 166, 169, 170, 186, 234, 250}, {85, 86, 101, 102, 149, 150, 165, 166, 170, 171, 186, 234, 251}, {84, 85, 101, 105, 149, 153, 165, 166, 169, 170, 185, 186, 233, 234, 250}, {84, 85, 101, 105, 149, 153, 165, 166, 169, 170, 186, 234, 250}, {85, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 186, 234, 250}, {85, 86, 101, 102, 106, 149, 150, 154, 165, 166, 169, 170, 171, 186, 234}, {84, 85, 89, 101, 105, 149, 153, 165, 169, 170, 173, 174, 185, 186, 233, 234, 254}, {85, 89, 101, 105, 149, 153, 165, 169, 170, 174, 186, 234, 254}, {85, 89, 101, 105, 106, 149, 153, 154, 165, 166, 169, 170, 174, 186, 234}, {85, 86, 89, 90, 101, 102, 105, 106, 149, 150, 153, 154, 165, 166, 169, 170, 171, 174, 186, 234}};
        LatticeVertex4D[] latticeVerticesByCode = new LatticeVertex4D[256];
        for (int i5 = 0; i5 < 256; ++i5) {
            int cx = (i5 >> 0 & 3) - 1;
            int cy = (i5 >> 2 & 3) - 1;
            int cz = (i5 >> 4 & 3) - 1;
            int cw = (i5 >> 6 & 3) - 1;
            latticeVerticesByCode[i5] = new LatticeVertex4D(cx, cy, cz, cw);
        }
        int nLatticeVerticesTotal = 0;
        for (i = 0; i < 256; ++i) {
            nLatticeVerticesTotal += lookup4DVertexCodes[i].length;
        }
        LOOKUP_4D_A = new int[256];
        LOOKUP_4D_B = new LatticeVertex4D[nLatticeVerticesTotal];
        int j4 = 0;
        for (i = 0; i < 256; ++i) {
            OpenSimplexNoise2S.LOOKUP_4D_A[i] = j4 | j4 + lookup4DVertexCodes[i].length << 16;
            for (int k = 0; k < lookup4DVertexCodes[i].length; ++k) {
                OpenSimplexNoise2S.LOOKUP_4D_B[j4++] = latticeVerticesByCode[lookup4DVertexCodes[i][k]];
            }
        }
    }

    private static class LatticeVertex4D {
        public final float dx;
        public final float dy;
        public final float dz;
        public final float dw;
        public final long xsvp;
        public final long ysvp;
        public final long zsvp;
        public final long wsvp;

        public LatticeVertex4D(int xsv, int ysv, int zsv, int wsv) {
            this.xsvp = (long)xsv * 5910200641878280303L;
            this.ysvp = (long)ysv * 6452764530575939509L;
            this.zsvp = (long)zsv * 6614699811220273867L;
            this.wsvp = (long)wsv * 6254464313819354443L;
            float ssv = (float)(xsv + ysv + zsv + wsv) * -0.1381966f;
            this.dx = (float)(-xsv) - ssv;
            this.dy = (float)(-ysv) - ssv;
            this.dz = (float)(-zsv) - ssv;
            this.dw = (float)(-wsv) - ssv;
        }
    }
}

