/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.mixin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import net.devtech.arrp.ARRP;
import net.devtech.arrp.api.SidedRRPCallback;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={MultiPackResourceManager.class})
public abstract class LifecycledResourceManagerImplMixin {
    private static final Logger ARRP_LOGGER = LogManager.getLogger((String)"ARRP/ReloadableResourceManagerImplMixin");

    @ModifyVariable(method={"<init>"}, at=@At(value="HEAD"), argsOnly=true)
    private static List<PackResources> registerARRPs(List<PackResources> packs, PackType type, List<PackResources> packs0) throws ExecutionException, InterruptedException {
        ArrayList<PackResources> copy = new ArrayList<PackResources>(packs);
        ARRP.waitForPregen();
        ARRP_LOGGER.info("ARRP register - before vanilla");
        ((SidedRRPCallback)SidedRRPCallback.BEFORE_VANILLA.invoker()).insert(type, Lists.reverse(copy));
        ARRP_LOGGER.info("ARRP register - after vanilla");
        ((SidedRRPCallback)SidedRRPCallback.AFTER_VANILLA.invoker()).insert(type, copy);
        return copy;
    }
}

