/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.json.lang;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class JLang
implements Cloneable {
    private final Map<String, String> lang = new HashMap<String, String>();

    public static JLang lang() {
        return new JLang();
    }

    @Deprecated
    public JLang translate(String in, String out) {
        this.lang.put(in, out);
        return this;
    }

    private <T> JLang object(Registry<T> registry, String str, T t, String name) {
        return this.object(str, Objects.requireNonNull(registry.m_7981_(t), "register your item before calling this"), name);
    }

    private JLang object(String type, ResourceLocation identifier, String translation) {
        this.lang.put(type + "." + identifier.m_135827_() + "." + identifier.m_135815_(), translation);
        return this;
    }

    public JLang entry(String entry, String name) {
        this.lang.put(entry, name);
        return this;
    }

    public JLang itemRespect(Item item, String name) {
        this.lang.put(item.m_5524_(), name);
        return this;
    }

    public JLang item(ItemStack stack, String name) {
        this.lang.put(stack.m_41778_(), name);
        return this;
    }

    @Deprecated
    public JLang item(Item item, String name) {
        return this.object((Registry)BuiltInRegistries.f_257033_, "item", (Object)item, name);
    }

    public JLang blockRespect(Block block, String name) {
        this.lang.put(block.m_7705_(), name);
        return this;
    }

    @Deprecated
    public JLang block(Block block, String name) {
        return this.object((Registry)BuiltInRegistries.f_256975_, "block", (Object)block, name);
    }

    public JLang fluid(Fluid fluid, String name) {
        return this.object((Registry)BuiltInRegistries.f_257020_, "fluid", (Object)fluid, name);
    }

    public JLang entityRespect(EntityType<?> type, String name) {
        this.lang.put(type.m_20675_(), name);
        return this;
    }

    @Deprecated
    public JLang entity(EntityType<?> type, String name) {
        return this.object((Registry)BuiltInRegistries.f_256780_, "entity_type", (Object)type, name);
    }

    public JLang enchantmentRespect(Enchantment enchantment, String name) {
        this.lang.put(enchantment.m_44704_(), name);
        return this;
    }

    @Deprecated
    public JLang enchantment(Enchantment enchantment, String name) {
        return this.object(BuiltInRegistries.f_256876_, "enchantment", enchantment, name);
    }

    public JLang item(ResourceLocation item, String name) {
        return this.object("item", item, name);
    }

    public JLang block(ResourceLocation block, String name) {
        return this.object("block", block, name);
    }

    public JLang fluid(ResourceLocation id, String name) {
        return this.object("fluid", id, name);
    }

    public JLang entity(ResourceLocation id, String name) {
        return this.object("entity_type", id, name);
    }

    public JLang enchantment(ResourceLocation id, String name) {
        return this.object("enchantment", id, name);
    }

    public JLang itemGroup(ResourceLocation id, String name) {
        return this.object("itemGroup", id, name);
    }

    public JLang sound(ResourceLocation id, String name) {
        return this.object("sound_event", id, name);
    }

    public JLang status(ResourceLocation id, String name) {
        return this.object("mob_effect", id, name);
    }

    public JLang allPotionOf(ResourceLocation id, String effectName) {
        this.allPotion(id, "Potion of " + effectName, "Splash Potion of " + effectName, "Lingering Potion of " + effectName, "Tipped Arrow of " + effectName);
        return this;
    }

    public JLang allPotion(ResourceLocation id, String drinkablePotionName, String splashPotionName, String lingeringPotionName, String tippedArrowName) {
        return this.drinkablePotion(id, drinkablePotionName).splashPotion(id, splashPotionName).lingeringPotion(id, lingeringPotionName).tippedArrow(id, tippedArrowName);
    }

    public JLang tippedArrow(ResourceLocation id, String name) {
        this.lang.put("item.minecraft.tipped_arrow.effect." + id.m_135815_(), name);
        return this;
    }

    public JLang lingeringPotion(ResourceLocation id, String name) {
        this.lang.put("item.minecraft.lingering_potion.effect." + id.m_135815_(), name);
        return this;
    }

    public JLang splashPotion(ResourceLocation id, String name) {
        this.lang.put("item.minecraft.splash_potion.effect." + id.m_135815_(), name);
        return this;
    }

    public JLang drinkablePotion(ResourceLocation id, String name) {
        this.lang.put("item.minecraft.potion.effect." + id.m_135815_(), "Potion of " + name);
        return this;
    }

    public JLang drinkablePotionOf(ResourceLocation id, String effectName) {
        this.lang.put("item.minecraft.potion.effect." + id.m_135815_(), "Potion of " + effectName);
        return this;
    }

    public JLang splashPotionOf(ResourceLocation id, String effectName) {
        this.lang.put("item.minecraft.splash_potion.effect." + id.m_135815_(), "Splash Potion of " + effectName);
        return this;
    }

    public JLang lingeringPotionOf(ResourceLocation id, String effectName) {
        this.lang.put("item.minecraft.lingering_potion.effect." + id.m_135815_(), "Lingering Potion of " + effectName);
        return this;
    }

    public JLang tippedArrowOf(ResourceLocation id, String effectName) {
        this.lang.put("item.minecraft.tipped_arrow.effect." + id.m_135815_(), "Tipped Arrow of " + effectName);
        return this;
    }

    public JLang biome(ResourceLocation id, String name) {
        return this.object("biome", id, name);
    }

    public Map<String, String> getLang() {
        return this.lang;
    }

    public JLang clone() {
        try {
            return (JLang)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }
}

