/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.devtech.arrp.api.RuntimeResourcePack;
import net.devtech.arrp.json.animation.JAnimation;
import net.devtech.arrp.json.blockstate.JMultipart;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.blockstate.JVariant;
import net.devtech.arrp.json.blockstate.JWhen;
import net.devtech.arrp.json.lang.JLang;
import net.devtech.arrp.json.loot.JCondition;
import net.devtech.arrp.json.loot.JFunction;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.loot.JPool;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.models.JTextures;
import net.devtech.arrp.json.recipe.JIngredient;
import net.devtech.arrp.json.recipe.JIngredients;
import net.devtech.arrp.json.recipe.JKeys;
import net.devtech.arrp.json.recipe.JPattern;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.tags.JTag;
import net.devtech.arrp.util.CallableFunction;
import net.devtech.arrp.util.CountingInputStream;
import net.devtech.arrp.util.UnsafeByteArrayOutputStream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.Internal
public class RuntimeResourcePackImpl
implements RuntimeResourcePack,
PackResources {
    public static final ExecutorService EXECUTOR_SERVICE;
    public static final boolean DUMP;
    public static final boolean DEBUG_PERFORMANCE;
    public static final Gson GSON;
    static final Set<String> KEY_WARNINGS;
    private static final Logger LOGGER;
    public final int packVersion;
    private final ResourceLocation id;
    private final Lock waiting = new ReentrantLock();
    private final Map<ResourceLocation, Supplier<byte[]>> data = new ConcurrentHashMap<ResourceLocation, Supplier<byte[]>>();
    private final Map<ResourceLocation, Supplier<byte[]>> assets = new ConcurrentHashMap<ResourceLocation, Supplier<byte[]>>();
    private final Map<List<String>, Supplier<byte[]>> root = new ConcurrentHashMap<List<String>, Supplier<byte[]>>();
    private final Map<ResourceLocation, JLang> langMergable = new ConcurrentHashMap<ResourceLocation, JLang>();

    public RuntimeResourcePackImpl(ResourceLocation id) {
        this(id, 5);
    }

    public RuntimeResourcePackImpl(ResourceLocation id, int version) {
        this.packVersion = version;
        this.id = id;
    }

    @Override
    public void addRecoloredImage(ResourceLocation identifier, InputStream target, IntUnaryOperator operator) {
        this.addLazyResource(PackType.CLIENT_RESOURCES, RuntimeResourcePackImpl.fix(identifier, "textures", "png"), (i, r) -> {
            try {
                CountingInputStream is = new CountingInputStream(target);
                BufferedImage base = ImageIO.read(is);
                BufferedImage recolored = new BufferedImage(base.getWidth(), base.getHeight(), 2);
                for (int y = 0; y < base.getHeight(); ++y) {
                    for (int x = 0; x < base.getWidth(); ++x) {
                        recolored.setRGB(x, y, operator.applyAsInt(base.getRGB(x, y)));
                    }
                }
                UnsafeByteArrayOutputStream baos = new UnsafeByteArrayOutputStream(is.bytes());
                ImageIO.write((RenderedImage)recolored, "png", baos);
                return baos.getBytes();
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public byte[] addLang(ResourceLocation identifier, JLang lang) {
        return this.addAsset(RuntimeResourcePackImpl.fix(identifier, "lang", "json"), RuntimeResourcePackImpl.serialize(lang.getLang()));
    }

    @Override
    public void mergeLang(ResourceLocation identifier, JLang lang) {
        this.langMergable.compute(identifier, (identifier1, lang1) -> {
            if (lang1 == null) {
                JLang finalLang = lang1 = new JLang();
                this.addLazyResource(PackType.CLIENT_RESOURCES, identifier, (pack, identifier2) -> pack.addLang(identifier, finalLang));
            }
            lang1.getLang().putAll(lang.getLang());
            return lang1;
        });
    }

    @Override
    public byte[] addLootTable(ResourceLocation identifier, JLootTable table) {
        return this.addData(RuntimeResourcePackImpl.fix(identifier, "loot_tables", "json"), RuntimeResourcePackImpl.serialize(table));
    }

    @Override
    public Future<byte[]> addAsyncResource(PackType type, ResourceLocation path, CallableFunction<ResourceLocation, byte[]> data) {
        Future<byte[]> future = EXECUTOR_SERVICE.submit(() -> (byte[])data.get(path));
        this.getSys(type).put(path, () -> {
            try {
                return (byte[])future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return future;
    }

    @Override
    public void addLazyResource(PackType type, ResourceLocation path, BiFunction<RuntimeResourcePack, ResourceLocation, byte[]> func) {
        this.getSys(type).put(path, new Memoized<ResourceLocation>(func, path));
    }

    @Override
    public byte[] addResource(PackType type, ResourceLocation path, byte[] data) {
        this.getSys(type).put(path, () -> data);
        return data;
    }

    @Override
    public Future<byte[]> addAsyncRootResource(String path, CallableFunction<String, byte[]> data) {
        Future<byte[]> future = EXECUTOR_SERVICE.submit(() -> (byte[])data.get(path));
        this.root.put(Arrays.asList(path.split("/")), () -> {
            try {
                return (byte[])future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        });
        return future;
    }

    @Override
    public void addLazyRootResource(String path, BiFunction<RuntimeResourcePack, String, byte[]> data) {
        this.root.put(Arrays.asList(path.split("/")), new Memoized<String>(data, path));
    }

    @Override
    public byte[] addRootResource(String path, byte[] data) {
        this.root.put(Arrays.asList(path.split("/")), () -> data);
        return data;
    }

    @Override
    public byte[] addAsset(ResourceLocation path, byte[] data) {
        return this.addResource(PackType.CLIENT_RESOURCES, path, data);
    }

    @Override
    public byte[] addData(ResourceLocation path, byte[] data) {
        return this.addResource(PackType.SERVER_DATA, path, data);
    }

    @Override
    public byte[] addModel(JModel model, ResourceLocation path) {
        return this.addAsset(RuntimeResourcePackImpl.fix(path, "models", "json"), RuntimeResourcePackImpl.serialize(model));
    }

    @Override
    public byte[] addBlockState(JState state, ResourceLocation path) {
        return this.addAsset(RuntimeResourcePackImpl.fix(path, "blockstates", "json"), RuntimeResourcePackImpl.serialize(state));
    }

    @Override
    public byte[] addTexture(ResourceLocation id, BufferedImage image) {
        UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", ubaos);
        }
        catch (IOException e) {
            throw new RuntimeException("impossible.", e);
        }
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "textures", "png"), ubaos.getBytes());
    }

    @Override
    public byte[] addAnimation(ResourceLocation id, JAnimation animation) {
        return this.addAsset(RuntimeResourcePackImpl.fix(id, "textures", "png.mcmeta"), RuntimeResourcePackImpl.serialize(animation));
    }

    @Override
    public byte[] addTag(ResourceLocation id, JTag tag) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "tags", "json"), RuntimeResourcePackImpl.serialize(tag));
    }

    @Override
    public byte[] addRecipe(ResourceLocation id, JRecipe recipe) {
        return this.addData(RuntimeResourcePackImpl.fix(id, "recipes", "json"), RuntimeResourcePackImpl.serialize(recipe));
    }

    @Override
    public Future<?> async(Consumer<RuntimeResourcePack> action) {
        this.lock();
        return EXECUTOR_SERVICE.submit(() -> {
            action.accept(this);
            this.waiting.unlock();
        });
    }

    @Override
    public void dumpDirect(Path output) {
        LOGGER.info("dumping " + this.id + "'s assets and data");
        try {
            for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.root.entrySet()) {
                Path path = output.resolve(String.join((CharSequence)"/", (Iterable<? extends CharSequence>)entry.getKey()));
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, entry.getValue().get(), new OpenOption[0]);
            }
            Path assets = output.resolve("assets");
            Files.createDirectories(assets, new FileAttribute[0]);
            for (Map.Entry<ResourceLocation, Supplier<byte[]>> entry : this.assets.entrySet()) {
                this.write(assets, entry.getKey(), entry.getValue().get());
            }
            Path path = output.resolve("data");
            Files.createDirectories(path, new FileAttribute[0]);
            for (Map.Entry<ResourceLocation, Supplier<byte[]>> entry : this.data.entrySet()) {
                this.write(path, entry.getKey(), entry.getValue().get());
            }
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void load(Path dir) throws IOException {
        Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);
        for (Path file : () -> stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(dir::relativize).iterator()) {
            String path;
            String s = file.toString();
            if (s.startsWith("assets")) {
                path = s.substring("assets".length() + 1);
                this.load(path, this.assets, Files.readAllBytes(file));
                continue;
            }
            if (s.startsWith("data")) {
                path = s.substring("data".length() + 1);
                this.load(path, this.data, Files.readAllBytes(file));
                continue;
            }
            byte[] data = Files.readAllBytes(file);
            this.root.put(Arrays.asList(s.split("/")), () -> data);
        }
    }

    @Override
    public void dump(File output) {
        this.dump(Paths.get(output.toURI()));
    }

    @Override
    public void dump(ZipOutputStream zos) throws IOException {
        ResourceLocation id;
        this.lock();
        for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.root.entrySet()) {
            zos.putNextEntry(new ZipEntry(String.join((CharSequence)"/", (Iterable<? extends CharSequence>)entry.getKey())));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.assets.entrySet()) {
            id = (ResourceLocation)entry.getKey();
            zos.putNextEntry(new ZipEntry("assets/" + id.m_135827_() + "/" + id.m_135815_()));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        for (Map.Entry<List<String>, Supplier<byte[]>> entry : this.data.entrySet()) {
            id = (ResourceLocation)entry.getKey();
            zos.putNextEntry(new ZipEntry("data/" + id.m_135827_() + "/" + id.m_135815_()));
            zos.write(entry.getValue().get());
            zos.closeEntry();
        }
        this.waiting.unlock();
    }

    @Override
    public void load(ZipInputStream stream) throws IOException {
        ZipEntry entry;
        while ((entry = stream.getNextEntry()) != null) {
            String path;
            String s = entry.toString();
            if (s.startsWith("assets")) {
                path = s.substring("assets".length() + 1);
                this.load(path, this.assets, this.read(entry, stream));
                continue;
            }
            if (s.startsWith("data")) {
                path = s.substring("data".length() + 1);
                this.load(path, this.data, this.read(entry, stream));
                continue;
            }
            byte[] data = this.read(entry, stream);
            this.root.put(Arrays.asList(s.split("/")), () -> data);
        }
    }

    @Override
    public ResourceLocation getId() {
        return this.id;
    }

    public IoSupplier<InputStream> m_8017_(String ... segments) {
        this.lock();
        Supplier<byte[]> supplier = this.root.get(Arrays.asList(segments));
        if (supplier == null) {
            this.waiting.unlock();
            return null;
        }
        this.waiting.unlock();
        return () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation id) {
        this.lock();
        Supplier<byte[]> supplier = this.getSys(type).get(id);
        if (supplier == null) {
            this.waiting.unlock();
            return null;
        }
        this.waiting.unlock();
        return () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    public void m_8031_(PackType type, String namespace, String prefix, PackResources.ResourceOutput consumer) {
        this.lock();
        for (ResourceLocation identifier : this.getSys(type).keySet()) {
            Supplier<byte[]> supplier = this.getSys(type).get(identifier);
            if (supplier == null) {
                this.waiting.unlock();
                continue;
            }
            IoSupplier inputSupplier = () -> new ByteArrayInputStream((byte[])supplier.get());
            if (!identifier.m_135827_().equals(namespace) || !identifier.m_135815_().startsWith(prefix)) continue;
            consumer.accept((Object)identifier, (Object)inputSupplier);
        }
        this.waiting.unlock();
    }

    public Set<String> m_5698_(PackType type) {
        this.lock();
        HashSet<String> namespaces = new HashSet<String>();
        for (ResourceLocation identifier : this.getSys(type).keySet()) {
            namespaces.add(identifier.m_135827_());
        }
        this.waiting.unlock();
        return namespaces;
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> metaReader) {
        InputStream stream = null;
        try {
            IoSupplier<InputStream> supplier = this.m_8017_("pack.mcmeta");
            if (supplier != null) {
                stream = (InputStream)supplier.m_247737_();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (stream != null) {
            return (T)AbstractPackResources.m_10214_(metaReader, (InputStream)stream);
        }
        if (metaReader.m_7991_().equals("pack")) {
            JsonObject object = new JsonObject();
            object.addProperty("pack_format", (Number)this.packVersion);
            object.addProperty("description", "runtime resource pack");
            return (T)metaReader.m_6322_(object);
        }
        if (KEY_WARNINGS.add(metaReader.m_7991_())) {
            LOGGER.info("'" + metaReader.m_7991_() + "' is an unsupported metadata key");
        }
        return null;
    }

    public String m_5542_() {
        return "Runtime Resource Pack" + this.id;
    }

    public void close() {
        LOGGER.info("closing rrp " + this.id);
        this.lock();
        if (DUMP) {
            this.dump();
        }
        this.waiting.unlock();
    }

    private static byte[] serialize(Object object) {
        UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)ubaos, StandardCharsets.UTF_8);
        GSON.toJson(object, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ubaos.getBytes();
    }

    private static ResourceLocation fix(ResourceLocation identifier, String prefix, String append) {
        return new ResourceLocation(identifier.m_135827_(), prefix + "/" + identifier.m_135815_() + "." + append);
    }

    protected byte[] read(ZipEntry entry, InputStream stream) throws IOException {
        byte[] data = new byte[Math.toIntExact(entry.getSize())];
        if (stream.read(data) != data.length) {
            throw new IOException("Zip stream was cut off! (maybe incorrect zip entry length? maybe u didn't flush your stream?)");
        }
        return data;
    }

    protected void load(String fullPath, Map<ResourceLocation, Supplier<byte[]>> map, byte[] data) {
        int sep = fullPath.indexOf(47);
        String namespace = fullPath.substring(0, sep);
        String path = fullPath.substring(sep + 1);
        map.put(new ResourceLocation(namespace, path), () -> data);
    }

    private void lock() {
        if (!this.waiting.tryLock()) {
            if (DEBUG_PERFORMANCE) {
                long start = System.currentTimeMillis();
                this.waiting.lock();
                long end = System.currentTimeMillis();
                LOGGER.warn("waited " + (end - start) + "ms for lock in RRP: " + this.id);
            } else {
                this.waiting.lock();
            }
        }
    }

    private void write(Path dir, ResourceLocation identifier, byte[] data) {
        try {
            Path file = dir.resolve(identifier.m_135827_()).resolve(identifier.m_135815_());
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            try (OutputStream output = Files.newOutputStream(file, new OpenOption[0]);){
                output.write(data);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<ResourceLocation, Supplier<byte[]>> getSys(PackType side) {
        return side == PackType.CLIENT_RESOURCES ? this.assets : this.data;
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(JMultipart.class, (Object)new JMultipart.Serializer()).registerTypeAdapter(JWhen.class, (Object)new JWhen.Serializer()).registerTypeAdapter(JState.class, (Object)new JState.Serializer()).registerTypeAdapter(JVariant.class, (Object)new JVariant.Serializer()).registerTypeAdapter(JTextures.class, (Object)new JTextures.Serializer()).registerTypeAdapter(JAnimation.class, (Object)new JAnimation.Serializer()).registerTypeAdapter(JFunction.class, (Object)new JFunction.Serializer()).registerTypeAdapter(JPool.class, (Object)new JPool.Serializer()).registerTypeAdapter(JPattern.class, (Object)new JPattern.Serializer()).registerTypeAdapter(JKeys.class, (Object)new JKeys.Serializer()).registerTypeAdapter(JIngredient.class, (Object)new JIngredient.Serializer()).registerTypeAdapter(JIngredients.class, (Object)new JIngredients.Serializer()).registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(JCondition.class, (Object)new JCondition.Serializer()).create();
        KEY_WARNINGS = Collections.newSetFromMap(new ConcurrentHashMap());
        LOGGER = LogManager.getLogger((String)"RRP");
        Properties properties = new Properties();
        int processors = Math.max(Runtime.getRuntime().availableProcessors() / 2 - 1, 1);
        boolean dump = false;
        boolean performance = false;
        properties.setProperty("threads", String.valueOf(processors));
        properties.setProperty("dump assets", "false");
        properties.setProperty("debug performance", "false");
        File file = new File("config/rrp.properties");
        try (FileReader reader = new FileReader(file);){
            properties.load(reader);
            processors = Integer.parseInt(properties.getProperty("threads"));
            dump = Boolean.parseBoolean(properties.getProperty("dump assets"));
            performance = Boolean.parseBoolean(properties.getProperty("debug performance"));
        }
        catch (Throwable t) {
            LOGGER.warn("Invalid config, creating new one!");
            file.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(file);){
                properties.store(writer, "number of threads RRP should use for generating resources");
            }
            catch (IOException ex) {
                LOGGER.error("Unable to write to RRP config!");
                ex.printStackTrace();
            }
        }
        EXECUTOR_SERVICE = Executors.newFixedThreadPool(processors, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ARRP-Workers-%s").build());
        DUMP = dump;
        DEBUG_PERFORMANCE = performance;
        KEY_WARNINGS.add("filter");
        KEY_WARNINGS.add("language");
    }

    private class Memoized<T>
    implements Supplier<byte[]> {
        private final BiFunction<RuntimeResourcePack, T, byte[]> func;
        private final T path;
        private byte[] data;

        public Memoized(BiFunction<RuntimeResourcePack, T, byte[]> func, T path) {
            this.func = func;
            this.path = path;
        }

        @Override
        public byte[] get() {
            if (this.data == null) {
                this.data = this.func.apply(RuntimeResourcePackImpl.this, (RuntimeResourcePack)this.path);
            }
            return this.data;
        }
    }
}

