/*
 * Decompiled with CFR 0.152.
 */
package net.devtech.arrp.api;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.devtech.arrp.impl.RuntimeResourcePackImpl;
import net.devtech.arrp.json.animation.JAnimation;
import net.devtech.arrp.json.blockstate.JState;
import net.devtech.arrp.json.lang.JLang;
import net.devtech.arrp.json.loot.JLootTable;
import net.devtech.arrp.json.models.JModel;
import net.devtech.arrp.json.recipe.JRecipe;
import net.devtech.arrp.json.tags.JTag;
import net.devtech.arrp.util.CallableFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;

public interface RuntimeResourcePack
extends PackResources {
    public static final File DEFAULT_OUTPUT = new File("rrp.debug");

    public static RuntimeResourcePack create(String id) {
        return new RuntimeResourcePackImpl(new ResourceLocation(id));
    }

    public static RuntimeResourcePack create(String id, int version) {
        return new RuntimeResourcePackImpl(new ResourceLocation(id), version);
    }

    public static RuntimeResourcePack create(ResourceLocation id) {
        return new RuntimeResourcePackImpl(id);
    }

    public static RuntimeResourcePack create(ResourceLocation id, int version) {
        return new RuntimeResourcePackImpl(id, version);
    }

    public static ResourceLocation id(String string) {
        return new ResourceLocation(string);
    }

    public static ResourceLocation id(String namespace, String string) {
        return new ResourceLocation(namespace, string);
    }

    public void addRecoloredImage(ResourceLocation var1, InputStream var2, IntUnaryOperator var3);

    public byte[] addLang(ResourceLocation var1, JLang var2);

    public void mergeLang(ResourceLocation var1, JLang var2);

    public byte[] addLootTable(ResourceLocation var1, JLootTable var2);

    public Future<byte[]> addAsyncResource(PackType var1, ResourceLocation var2, CallableFunction<ResourceLocation, byte[]> var3);

    public void addLazyResource(PackType var1, ResourceLocation var2, BiFunction<RuntimeResourcePack, ResourceLocation, byte[]> var3);

    public byte[] addResource(PackType var1, ResourceLocation var2, byte[] var3);

    public Future<byte[]> addAsyncRootResource(String var1, CallableFunction<String, byte[]> var2);

    public void addLazyRootResource(String var1, BiFunction<RuntimeResourcePack, String, byte[]> var2);

    public byte[] addRootResource(String var1, byte[] var2);

    public byte[] addAsset(ResourceLocation var1, byte[] var2);

    public byte[] addData(ResourceLocation var1, byte[] var2);

    public byte[] addModel(JModel var1, ResourceLocation var2);

    public byte[] addBlockState(JState var1, ResourceLocation var2);

    public byte[] addTexture(ResourceLocation var1, BufferedImage var2);

    public byte[] addAnimation(ResourceLocation var1, JAnimation var2);

    public byte[] addTag(ResourceLocation var1, JTag var2);

    public byte[] addRecipe(ResourceLocation var1, JRecipe var2);

    public Future<?> async(Consumer<RuntimeResourcePack> var1);

    default public void dump() {
        this.dump(DEFAULT_OUTPUT);
    }

    public void dumpDirect(Path var1);

    public void load(Path var1) throws IOException;

    @Deprecated
    public void dump(File var1);

    default public void dump(Path path) {
        ResourceLocation id = this.getId();
        Path folder = path.resolve(id.m_135827_() + ";" + id.m_135815_());
        this.dumpDirect(folder);
    }

    public void dump(ZipOutputStream var1) throws IOException;

    public void load(ZipInputStream var1) throws IOException;

    public ResourceLocation getId();
}

