/*
 * Decompiled with CFR 0.152.
 */
package com.ianm1647.ancientreforging.screen;

import com.ianm1647.ancientreforging.screen.AncientReforgingMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.client.AdventureContainerScreen;
import java.util.ArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AncientReforgingScreen
extends AdventureContainerScreen<AncientReforgingMenu> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("apotheosis", "textures/gui/reforge.png");
    public static final ResourceLocation ANIMATED_TEXTURE = new ResourceLocation("apotheosis", "textures/gui/reforge_animation.png");
    public static final int MAX_ANIMATION_TIME = 8;
    protected boolean hasMainItem = false;
    protected int animationTick = 0;
    protected int maxSlot = -1;
    protected int opacityTick = 0;
    protected int availableOpacity = 170;

    public AncientReforgingScreen(AncientReforgingMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.f_97727_ = 266;
    }

    public void m_88315_(GuiGraphics gfx, int mouseX, int mouseY, float pPartialTick) {
        this.m_280273_(gfx);
        super.m_88315_(gfx, mouseX, mouseY, pPartialTick);
        RenderSystem.disableBlend();
        this.m_280072_(gfx, mouseX, mouseY);
        int sigils = ((AncientReforgingMenu)this.f_97732_).getSigilCount();
        int mats = ((AncientReforgingMenu)this.f_97732_).getMatCount();
        int levels = ((AncientReforgingMenu)this.f_97732_).player.f_36078_;
        for (int idx = 0; idx < 3; ++idx) {
            ItemStack choice;
            Slot slot = ((AncientReforgingMenu)this.m_6262_()).m_38853_(3 + idx);
            if (!this.m_6774_(slot.f_40220_, slot.f_40221_, 16, 16, mouseX, mouseY) || (choice = slot.m_7993_()).m_41619_()) continue;
            ArrayList<Object> tooltips = new ArrayList<Object>();
            int sigilCost = ((AncientReforgingMenu)this.f_97732_).getSigilCost(idx);
            int matCost = ((AncientReforgingMenu)this.f_97732_).getMatCost(idx);
            int levelCost = ((AncientReforgingMenu)this.f_97732_).getLevelCost(idx);
            boolean creative = this.f_96541_.f_91074_.m_7500_();
            tooltips.add(Component.m_237115_((String)"text.apotheosis.reforge_cost").m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.UNDERLINE}));
            tooltips.add(CommonComponents.f_237098_);
            if (sigilCost > 0) {
                tooltips.add(Component.m_237110_((String)"%s %s", (Object[])new Object[]{sigilCost, ((Item)Adventure.Items.SIGIL_OF_REBIRTH.get()).m_7626_(ItemStack.f_41583_)}).m_130940_(!creative && sigils < sigilCost ? ChatFormatting.RED : ChatFormatting.GRAY));
            }
            if (matCost > 0) {
                tooltips.add(Component.m_237110_((String)"%s %s", (Object[])new Object[]{matCost, ((AncientReforgingMenu)this.f_97732_).m_38853_(1).m_7993_().m_41786_().getString()}).m_130940_(!creative && mats < matCost ? ChatFormatting.RED : ChatFormatting.GRAY));
            }
            String key = idx == 0 ? "container.enchant.level.one" : "container.enchant.level.many";
            tooltips.add(Component.m_237110_((String)key, (Object[])new Object[]{idx + 1}).m_130940_(!creative && levels < levelCost ? ChatFormatting.RED : ChatFormatting.GRAY));
            tooltips.add(Component.m_237113_((String)" "));
            tooltips.add(Component.m_237110_((String)"container.enchant.level.requirement", (Object[])new Object[]{levelCost}).m_130940_(!creative && levels < levelCost ? ChatFormatting.RED : ChatFormatting.GRAY));
            this.drawOnLeft(gfx, tooltips, this.getGuiTop() + 45);
            break;
        }
    }

    protected void m_7286_(GuiGraphics gfx, float partials, int x, int y) {
        Slot slot;
        int mats;
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int xCenter = (this.f_96543_ - this.f_97726_) / 2;
        int yCenter = (this.f_96544_ - this.f_97727_) / 2;
        gfx.m_280163_(TEXTURE, xCenter, yCenter, 0.0f, 0.0f, this.f_97726_, this.f_97727_, 256, 384);
        for (int idx = 0; idx < 3; ++idx) {
            if (this.maxSlot < idx || this.animationTick != 0) continue;
            gfx.m_280163_(TEXTURE, left + 20 + 46 * idx, top + 129, (float)(20 + 46 * idx), 273.0f, 46, 35, 256, 384);
        }
        boolean hadItem = this.hasMainItem;
        this.hasMainItem = ((AncientReforgingMenu)this.f_97732_).m_38853_(0).m_6657_();
        if (!hadItem && this.hasMainItem) {
            this.animationTick = 8;
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)((SoundEvent)Adventure.Sounds.REFORGE.get()), (float)1.0f, (float)2.0f));
        }
        if (this.hasMainItem) {
            float delta = Mth.m_14036_((float)(((float)(8 - this.animationTick) - partials) / 8.0f), (float)0.0f, (float)1.0f);
            mats = Mth.m_269140_((float)delta, (int)0, (int)20);
            gfx.m_280411_(ANIMATED_TEXTURE, left + 26, top + 15, 127, 112, 0.0f, (float)(mats * 112), 127, 112, 127, 2240);
        }
        int sigils = ((AncientReforgingMenu)this.f_97732_).getSigilCount();
        mats = ((AncientReforgingMenu)this.f_97732_).getMatCount();
        int levels = ((AncientReforgingMenu)this.f_97732_).player.f_36078_;
        this.maxSlot = -1;
        for (int idx = 0; idx < 3 && (slot = ((AncientReforgingMenu)this.m_6262_()).m_38853_(3 + idx)).m_6657_(); ++idx) {
            int sigilCost = ((AncientReforgingMenu)this.f_97732_).getSigilCost(idx);
            int matCost = ((AncientReforgingMenu)this.f_97732_).getMatCost(idx);
            int levelCost = ((AncientReforgingMenu)this.f_97732_).getLevelCost(idx);
            if ((sigils < sigilCost || levels < levelCost || mats < matCost) && !this.f_96541_.f_91074_.m_150110_().f_35937_) continue;
            ++this.maxSlot;
        }
    }

    protected int darken(int rColor, int factor) {
        int r = rColor >> 16 & 0xFF;
        int g = rColor >> 8 & 0xFF;
        int b = rColor & 0xFF;
        return (r /= factor) << 16 | (g /= factor) << 8 | (b /= factor);
    }

    protected void drawBorderedString(GuiGraphics gfx, String str, int x, int y, int color, int shadowColor) {
        MutableComponent comp = Component.m_237113_((String)str);
        gfx.m_280614_(this.f_96547_, (Component)comp, x, y - 1, shadowColor, false);
        gfx.m_280614_(this.f_96547_, (Component)comp, x - 1, y, shadowColor, false);
        gfx.m_280614_(this.f_96547_, (Component)comp, x, y + 1, shadowColor, false);
        gfx.m_280614_(this.f_96547_, (Component)comp, x + 1, y, shadowColor, false);
        gfx.m_280614_(this.f_96547_, (Component)comp, x, y, color, false);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        for (int k = 0; k < 3; ++k) {
            double d0 = pMouseX - (double)(i + 60);
            double d1 = pMouseY - (double)(j + 14 + 19 * k);
            if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 108.0) || !(d1 < 19.0) || !((AncientReforgingMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, k)) continue;
            this.f_96541_.f_91072_.m_105208_(((AncientReforgingMenu)this.f_97732_).f_38840_, k);
            return true;
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    protected void m_181908_() {
        ++this.opacityTick;
        if (this.animationTick > 0) {
            --this.animationTick;
            if (this.animationTick == 0) {
                this.opacityTick = 0;
            }
        }
        float sin = Mth.m_14031_((float)((float)this.opacityTick / 60.0f * (float)Math.PI));
        float delta = sin * sin;
        this.availableOpacity = Mth.m_269140_((float)delta, (int)136, (int)221);
    }
}

