/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.skill.weaponinnate;

import java.util.List;
import java.util.UUID;
import net.corruptdog.cdm.api.animation.types.YamtoAttackAnimation;
import net.corruptdog.cdm.gameasset.CorruptAnimations;
import net.corruptdog.cdm.skill.CDSkillDataKeys;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.skill.BasicAttack;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.BasicAttackEvent;
import yesman.epicfight.world.entity.eventlistener.DetachablePlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class YamatoAttack
extends BasicAttack {
    private static final UUID EVENT_UUID = UUID.fromString("6504b895-cd22-d0eb-9b19-509a447ab84f");

    public YamatoAttack(SkillBuilder<? extends BasicAttack> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (!((StaticAnimation)event.getAnimation().get()).isBasicAttackAnimation()) {
                container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.COMBO_COUNTER.get(), (Object)0);
            }
            if (!(event.getAnimation() instanceof AttackAnimation)) {
                this.onUnlock(container);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {
            if ((Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.COMBO_COUNTER.get()) > 0) {
                container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.COMBO_COUNTER.get(), (Object)0);
            }
            if (((AttackAnimation)event.getAnimation().get()).getId() != ((YamtoAttackAnimation)((Object)((Object)CorruptAnimations.YAMATO_POWER3.get()))).getId() && ((AttackAnimation)event.getAnimation().get()).getId() != ((YamtoAttackAnimation)((Object)((Object)CorruptAnimations.YAMATO_POWER3_REPEAT.get()))).getId()) {
                this.onUnlock(container);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
    }

    private void onUnlock(SkillContainer container) {
        if (container.getStack() > 0) {
            this.setStackSynchronize(container, 0);
        }
    }

    public boolean canExecute(SkillContainer skillContainer) {
        if (skillContainer.getExecutor().isLogicalClient()) {
            return skillContainer.getExecutor().getSkill((Skill)this.category).getStack() == 0;
        }
        return true;
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        Player player = (Player)executer.getOriginal();
        return !player.m_5833_() && playerState.canBasicAttack();
    }

    public boolean resourcePredicate(PlayerPatch<?> playerpatch) {
        return playerpatch.getSkill((Skill)this.category).getStack() == 0;
    }

    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        if (skillContainer.getExecutor().getEventListener().triggerEvents(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, (DetachablePlayerEvent)new BasicAttackEvent(skillContainer.getServerExecutor()))) {
            return;
        }
        CapabilityItem cap = skillContainer.getExecutor().getHoldingItemCapability(InteractionHand.MAIN_HAND);
        StaticAnimation attackMotion = null;
        ServerPlayer player = (ServerPlayer)skillContainer.getServerExecutor().getOriginal();
        SkillDataManager dataManager = skillContainer.getExecutor().getSkill((Skill)this.category).getDataManager();
        int comboCounter = (Integer)dataManager.getDataValue((SkillDataKey)CDSkillDataKeys.COMBO_COUNTER.get());
        if (player.m_20159_()) {
            Entity entity = player.m_20202_();
            if (entity instanceof PlayerRideableJumping && ((PlayerRideableJumping)entity).m_7132_() && cap.availableOnHorse() && cap.getMountAttackMotion() != null) {
                attackMotion = (StaticAnimation)cap.getMountAttackMotion().get(comboCounter %= cap.getMountAttackMotion().size());
                ++comboCounter;
            }
        } else {
            List combo = cap.getAutoAttackMotion(skillContainer.getExecutor());
            int comboSize = combo.size();
            boolean dashAttack = player.m_20142_();
            comboCounter = dashAttack ? comboSize - 2 : (comboCounter %= comboSize - 2);
            attackMotion = (StaticAnimation)combo.get(comboCounter);
            comboCounter = dashAttack ? 0 : comboCounter + 1;
        }
        dataManager.setData((SkillDataKey)CDSkillDataKeys.COMBO_COUNTER.get(), (Object)comboCounter);
        if (attackMotion != null) {
            skillContainer.getExecutor().playAnimationSynchronized((AssetAccessor)attackMotion.getRealAnimation(), 0.0f);
        }
        skillContainer.getExecutor().updateEntityState();
    }

    public void updateContainer(SkillContainer container) {
        if ((Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.COMBO_COUNTER.get()) > 0 && container.getExecutor().getTickSinceLastAction() > 10) {
            container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.COMBO_COUNTER.get(), (Object)0);
        }
    }
}

