/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.skill.weaponinnate;

import java.util.Objects;
import java.util.UUID;
import net.corruptdog.cdm.gameasset.CorruptAnimations;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ShilledSlash
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440000");

    public ShilledSlash(SkillBuilder<? extends WeaponInnateSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            DamageSource damagesource;
            Vec3 sourceLocation;
            ServerPlayerPatch executer = (ServerPlayerPatch)event.getPlayerPatch();
            AnimationPlayer animationPlayer = executer.getAnimator().getPlayerFor(null);
            float elapsedTime = 0.0f;
            if (animationPlayer != null) {
                elapsedTime = animationPlayer.getElapsedTime();
            }
            int animationId = ((DynamicAnimation)Objects.requireNonNull(executer.getAnimator().getPlayerFor(null)).getAnimation().get()).getId();
            if (elapsedTime <= 0.2f && animationId == ((AttackAnimation)CorruptAnimations.SHILED_SLASH.get()).getId() && (sourceLocation = (damagesource = event.getDamageSource()).m_7270_()) != null) {
                Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                if (!(!(toSourceLocation.m_82526_(viewVector) > 0.0) || damagesource.m_269533_(DamageTypeTags.f_268415_) || damagesource.m_276093_(DamageTypes.f_268515_) || damagesource.m_269533_(DamageTypeTags.f_268490_) || damagesource.m_269533_(DamageTypeTags.f_268738_))) {
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound(SoundEvents.f_12346_, 0.8f, 1.2f);
                    event.setCanceled(true);
                    event.setResult(AttackResult.ResultType.BLOCKED);
                    Entity directEntity = event.getDamageSource().m_7640_();
                    LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)directEntity, LivingEntityPatch.class);
                    if (entitypatch != null) {
                        entitypatch.playAnimationSynchronized(CorruptAnimations.PARRY_BREAK1, 0.0f);
                        MobEffectInstance effectInstance = ((ServerPlayerPatch)event.getPlayerPatch()).getTarget().m_21124_((MobEffect)EpicFightMobEffects.INSTABILITY.get());
                        int amp = effectInstance == null ? 0 : effectInstance.m_19564_() + 1;
                        ((ServerPlayerPatch)event.getPlayerPatch()).getTarget().m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.INSTABILITY.get(), 1000, amp));
                        if (((ServerPlayerPatch)event.getPlayerPatch()).getTarget().m_21023_((MobEffect)EpicFightMobEffects.INSTABILITY.get()) && Objects.requireNonNull(((ServerPlayerPatch)event.getPlayerPatch()).getTarget().m_21124_((MobEffect)EpicFightMobEffects.INSTABILITY.get())).m_19564_() >= 2) {
                            entitypatch.playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_BOSSES.get(), 0.1f, 0.1f);
                            entitypatch.playAnimationSynchronized(CorruptAnimations.GUARD_BREAK2, 0.0f);
                            ((ServerPlayerPatch)event.getPlayerPatch()).getTarget().m_21195_((MobEffect)EpicFightMobEffects.INSTABILITY.get());
                        }
                    }
                }
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        PlayerPatch executer = container.getExecutor();
        executer.getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, 0);
    }

    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        skillContainer.getExecutor().playAnimationSynchronized(CorruptAnimations.SHILED_SLASH, 0.0f);
        super.executeOnServer(skillContainer, args);
    }
}

