/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.skill.identity;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.corruptdog.cdm.api.animation.types.SeeThroughAnimation;
import net.corruptdog.cdm.gameasset.CorruptAnimations;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SeeThrough
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440000");
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public SeeThrough(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    public static Builder createSeeThroughSkillBuilder() {
        return (Builder)new Builder().setCategory((SkillCategory)SkillCategories.IDENTITY).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.NONE);
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TARGET_INDICATOR_ALERT_CHECK_EVENT, EVENT_UUID);
    }

    public void onInitiate(SkillContainer container) {
        PlayerEventListener listener = container.getExecutor().getEventListener();
        listener.addEventListener(PlayerEventListener.EventType.TARGET_INDICATOR_ALERT_CHECK_EVENT, EVENT_UUID, event -> {
            int animationId = ((DynamicAnimation)Objects.requireNonNull(((LocalPlayerPatch)event.getPlayerPatch()).getAnimator().getPlayerFor(null)).getAnimation().get()).getId();
            PlayerPatch playerPatch = container.getExecutor();
            LivingEntity target = playerPatch.getTarget();
            if (animationId == ((SeeThroughAnimation)((Object)((Object)CorruptAnimations.RECOGNITION.get()))).getId() && target != null) {
                event.setCanceled(false);
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.BASIC_ATTACK_EVENT, EVENT_UUID, event -> {
            float stamina = ((ServerPlayerPatch)event.getPlayerPatch()).getStamina();
            int costStamina = 3;
            ResourceLocation rl = ((DynamicAnimation)Objects.requireNonNull(((ServerPlayerPatch)event.getPlayerPatch()).getAnimator().getPlayerFor(null)).getAnimation().get()).getRegistryName();
            if (stamina < 3.0f && rl == ((SeeThroughAnimation)((Object)((Object)CorruptAnimations.RECOGNITION.get()))).getRegistryName()) {
                event.setCanceled(true);
            }
            if (rl == ((SeeThroughAnimation)((Object)((Object)CorruptAnimations.RECOGNITION.get()))).getRegistryName()) {
                event.setCanceled(true);
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(CorruptAnimations.LETHAL_SLICING_ONCE, 0.1f);
                ((ServerPlayerPatch)event.getPlayerPatch()).setStamina(stamina - (float)costStamina);
            }
        });
        listener.addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)container.getExecutor().getTarget(), LivingEntityPatch.class);
            if (entitypatch == null || entitypatch.getAnimator() == null) {
                return;
            }
            int animationId = ((DynamicAnimation)Objects.requireNonNull(((ServerPlayerPatch)event.getPlayerPatch()).getAnimator().getPlayerFor(null)).getAnimation().get()).getId();
            int targetanimationId = ((DynamicAnimation)Objects.requireNonNull(entitypatch.getAnimator().getPlayerFor(null)).getAnimation().get()).getId();
            DamageSource damagesource = event.getDamageSource();
            Vec3 sourceLocation = damagesource.m_7270_();
            StaticAnimation[] attackAnimations = new StaticAnimation[]{(StaticAnimation)Animations.LONGSWORD_DASH.get(), (StaticAnimation)CorruptAnimations.LONGSWORD_OLD_DASH.get(), (StaticAnimation)CorruptAnimations.SSPEAR_DASH.get(), (StaticAnimation)CorruptAnimations.UCHIGATANA_HEAVY1.get(), (StaticAnimation)Animations.SWORD_DASH.get(), (StaticAnimation)Animations.TACHI_DASH.get(), (StaticAnimation)Animations.SPEAR_DASH.get(), (StaticAnimation)Animations.UCHIGATANA_DASH.get()};
            StaticAnimation[] dodgeAnimations = new StaticAnimation[]{(StaticAnimation)Animations.BIPED_STEP_FORWARD.get(), (StaticAnimation)CorruptAnimations.STEP_FORWARD.get(), (StaticAnimation)CorruptAnimations.SSTEP_FORWARD.get()};
            block0: for (StaticAnimation attackAnim : attackAnimations) {
                if (targetanimationId != attackAnim.getId() || sourceLocation == null) continue;
                Vec3 playerPos = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_();
                Vec3 targetPos = ((ServerPlayerPatch)event.getPlayerPatch()).getTarget().m_20182_();
                Vec3 targetToPlayer = playerPos.m_82546_(targetPos).m_82541_();
                Vec3 targetForward = ((ServerPlayerPatch)event.getPlayerPatch()).getTarget().m_20252_(1.0f).m_82541_();
                double angle = Math.toDegrees(Math.acos(targetForward.m_82526_(targetToPlayer)));
                Vec3 playerForward = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f).m_82541_();
                Vec3 playerToTarget = targetPos.m_82546_(playerPos).m_82541_();
                double playerAngle = Math.toDegrees(Math.acos(playerForward.m_82526_(playerToTarget)));
                if (!(angle <= 90.0) || !(playerAngle <= 90.0)) continue;
                for (StaticAnimation dodgeAnim : dodgeAnimations) {
                    if (animationId != dodgeAnim.getId()) continue;
                    event.setCanceled(true);
                    Player player = (Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                    Vec3 entityViewVector = ((LivingEntity)entitypatch.getOriginal()).m_20252_(1.0f);
                    player.m_6021_(((LivingEntity)entitypatch.getOriginal()).m_20185_() + entityViewVector.m_7096_() * 2.0, ((LivingEntity)entitypatch.getOriginal()).m_20186_(), ((LivingEntity)entitypatch.getOriginal()).m_20189_() + entityViewVector.m_7094_() * 2.0);
                    ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(CorruptAnimations.RECOGNITION, 0.0f);
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 3));
                    event.setResult(AttackResult.ResultType.MISSED);
                    entitypatch.playAnimationSynchronized(CorruptAnimations.RECOGNIZED, 0.1f);
                    break block0;
                }
                break;
            }
        });
    }

    public static class Builder
    extends SkillBuilder<SeeThrough> {
        public Builder setActivateType(Skill.ActivateType activateType) {
            this.activateType = activateType;
            return this;
        }

        public Builder setResource(Skill.Resource resource) {
            this.resource = resource;
            return this;
        }
    }
}

