/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.skill.identity;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import net.corruptdog.cdm.Config.CDConfig;
import net.corruptdog.cdm.gameasset.CorruptAnimations;
import net.corruptdog.cdm.gameasset.CorruptSound;
import net.corruptdog.cdm.world.CDWeaponCapabilityPresets;
import net.corruptdog.cdm.world.CorruptWeaponCategories;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.LongHitAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.effect.EpicFightMobEffects;

@Mod.EventBusSubscriber
public class Execute {
    private static final Logger LOGGER = LogManager.getLogger(Execute.class);
    private static final Map<Object, BiConsumer<ServerPlayer, LivingEntityPatch<?>>> EXECUTION_STRATEGIES = new HashMap();

    private static boolean isClassAvailable() {
        try {
            Class.forName("net.yonchi.refm.world.capabilities.item.RapierWeaponCategories");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void handleExecution(ServerPlayer player, LivingEntityPatch<?> targetPatch, PlayerPatch<?> playerPatch) {
        Vec3 viewVec = ((LivingEntity)targetPatch.getOriginal()).m_20252_(1.0f);
        playerPatch.setGrapplingTarget((LivingEntity)targetPatch.getOriginal());
        Execute.applyPotions(player, targetPatch);
        WeaponCategory weaponCategory = playerPatch.getHoldingItemCapability(InteractionHand.MAIN_HAND).getWeaponCategory();
        BiConsumer<ServerPlayer, LivingEntityPatch<?>> strategy = EXECUTION_STRATEGIES.get(weaponCategory);
        if (strategy != null) {
            strategy.accept(player, targetPatch);
        } else {
            Execute.executeDefault(player, targetPatch, viewVec);
        }
    }

    private static void applyPotions(ServerPlayer player, LivingEntityPatch<?> targetPatch) {
        player.m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 100, 0));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 50, 1));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 70, 5));
        ((LivingEntity)targetPatch.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 40, 0));
        targetPatch.playSound((SoundEvent)CorruptSound.EXECUTE.get(), 1.0f, 1.0f);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)event.getEntity(), PlayerPatch.class);
        if (playerPatch == null || !((Boolean)CDConfig.CAN_EXECUTE.get()).booleanValue()) {
            return;
        }
        Execute.executeTarget(event.getEntity(), event.getTarget());
    }

    public static void executeTarget(Player player, Entity target) {
        PlayerPatch playerPatch;
        if (player == null || target == null || player.m_9236_().m_5776_()) {
            return;
        }
        LivingEntityPatch targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)target, LivingEntityPatch.class);
        if (targetPatch != null && target != player && (playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class)) != null && Execute.isAnimationValid(targetPatch) && playerPatch.getEntityState().canBasicAttack()) {
            Execute.handleExecution((ServerPlayer)player, targetPatch, playerPatch);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isAnimationValid(LivingEntityPatch<?> targetPatch) {
        Object object = Objects.requireNonNull(targetPatch.getAnimator().getPlayerFor(null)).getAnimation().get();
        if (object instanceof StaticAnimation) {
            StaticAnimation staticAnimation = (StaticAnimation)object;
            if (staticAnimation == Animations.BIPED_KNEEL.get()) return true;
        }
        if (!((object = Objects.requireNonNull(targetPatch.getAnimator().getPlayerFor(null)).getAnimation().get()) instanceof LongHitAnimation)) return false;
        LongHitAnimation longHitAnimation = (LongHitAnimation)object;
        if (!Set.of((ActionAnimation)Animations.WITHER_NEUTRALIZED.get(), (ActionAnimation)Animations.VEX_NEUTRALIZED.get(), (ActionAnimation)Animations.SPIDER_NEUTRALIZED.get(), (ActionAnimation)Animations.DRAGON_NEUTRALIZED.get(), (ActionAnimation)Animations.ENDERMAN_NEUTRALIZED.get(), (ActionAnimation)Animations.BIPED_COMMON_NEUTRALIZED.get(), (ActionAnimation)Animations.GREATSWORD_GUARD_BREAK.get(), (ActionAnimation)CorruptAnimations.GUARD_BREAK1.get(), (ActionAnimation)CorruptAnimations.GUARD_BREAK2.get(), (ActionAnimation)CorruptAnimations.GUARD_BREAK3.get(), (ActionAnimation)CorruptAnimations.GUARD_BREAK4.get()).contains(longHitAnimation)) return false;
        return true;
    }

    private static void executeYamato(ServerPlayer player, LivingEntityPatch<?> targetPatch) {
        Vec3 viewVec = ((LivingEntity)targetPatch.getOriginal()).m_20252_(1.0f);
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        player.m_6021_(((LivingEntity)targetPatch.getOriginal()).m_20185_() + viewVec.m_7096_() * 2.0, ((LivingEntity)targetPatch.getOriginal()).m_20186_(), ((LivingEntity)targetPatch.getOriginal()).m_20189_() + viewVec.m_7094_() * 2.0);
        playerPatch.playAnimationSynchronized(CorruptAnimations.EXECUTE_YAMATO, 0.4f);
        targetPatch.playAnimationSynchronized(CorruptAnimations.EXECUTED_YAMATO, 0.6f);
    }

    private static void executeKatana(ServerPlayer player, LivingEntityPatch<?> targetPatch) {
        Vec3 viewVec = ((LivingEntity)targetPatch.getOriginal()).m_20252_(1.0f);
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        player.m_6021_(((LivingEntity)targetPatch.getOriginal()).m_20185_() + viewVec.m_7096_() * 2.0, ((LivingEntity)targetPatch.getOriginal()).m_20186_(), ((LivingEntity)targetPatch.getOriginal()).m_20189_() + viewVec.m_7094_() * 2.0);
        playerPatch.playAnimationSynchronized(CorruptAnimations.KATANA_EXECUTE, 0.0f);
        targetPatch.playAnimationSynchronized(CorruptAnimations.KATANA_EXECUTED, 0.05f);
    }

    private static void executeDagger(ServerPlayer player, LivingEntityPatch<?> targetPatch) {
        Vec3 viewVec = ((LivingEntity)targetPatch.getOriginal()).m_20252_(1.0f);
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        player.m_6021_(((LivingEntity)targetPatch.getOriginal()).m_20185_() + viewVec.m_7096_() * 2.5, ((LivingEntity)targetPatch.getOriginal()).m_20186_(), ((LivingEntity)targetPatch.getOriginal()).m_20189_() + viewVec.m_7094_() * 2.5);
        playerPatch.playAnimationSynchronized(CorruptAnimations.DAGGER_EXECUTE, 0.0f);
        targetPatch.playAnimationSynchronized(CorruptAnimations.DAGGER_EXECUTED, 0.05f);
    }

    private static void executeDualDagger(ServerPlayer player, LivingEntityPatch<?> targetPatch) {
        Vec3 viewVec = ((LivingEntity)targetPatch.getOriginal()).m_20252_(1.0f);
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        player.m_6021_(((LivingEntity)targetPatch.getOriginal()).m_20185_() + viewVec.m_7096_(), ((LivingEntity)targetPatch.getOriginal()).m_20186_(), ((LivingEntity)targetPatch.getOriginal()).m_20189_() + viewVec.m_7094_());
        playerPatch.playAnimationSynchronized(CorruptAnimations.DUAL_DAGGER_EXECUTE, 0.05f);
        targetPatch.playAnimationSynchronized(CorruptAnimations.DUAL_DAGGER_EXECUTED, 0.05f);
    }

    private static void executeFist(ServerPlayer player, LivingEntityPatch<?> targetPatch) {
        Vec3 viewVec = ((LivingEntity)targetPatch.getOriginal()).m_20252_(1.0f);
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        player.m_6021_(((LivingEntity)targetPatch.getOriginal()).m_20185_() + viewVec.m_7096_(), ((LivingEntity)targetPatch.getOriginal()).m_20186_(), ((LivingEntity)targetPatch.getOriginal()).m_20189_() + viewVec.m_7094_());
        playerPatch.playAnimationSynchronized(CorruptAnimations.FIST_EXECUTE, 0.0f);
        targetPatch.playAnimationSynchronized(CorruptAnimations.FIST_EXECUTED, 0.1f);
    }

    private static void executeSpear(ServerPlayer player, LivingEntityPatch<?> targetPatch) {
        Vec3 viewVec = ((LivingEntity)targetPatch.getOriginal()).m_20252_(1.0f);
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        player.m_6021_(((LivingEntity)targetPatch.getOriginal()).m_20185_() + viewVec.m_7096_() * 2.0, ((LivingEntity)targetPatch.getOriginal()).m_20186_(), ((LivingEntity)targetPatch.getOriginal()).m_20189_() + viewVec.m_7094_() * 2.0);
        playerPatch.playAnimationSynchronized(CorruptAnimations.SPEAR_EXECUTE, 0.0f);
        targetPatch.playAnimationSynchronized(CorruptAnimations.SPEAR_EXECUTED, 0.25f);
    }

    private static void executeGreatsword(ServerPlayer player, LivingEntityPatch<?> targetPatch) {
        Vec3 viewVec = ((LivingEntity)targetPatch.getOriginal()).m_20252_(1.0f);
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        player.m_6021_(((LivingEntity)targetPatch.getOriginal()).m_20185_() + viewVec.m_7096_() * 1.5, ((LivingEntity)targetPatch.getOriginal()).m_20186_(), ((LivingEntity)targetPatch.getOriginal()).m_20189_() + viewVec.m_7094_() * 1.5);
        playerPatch.playAnimationSynchronized(CorruptAnimations.GREATSWORD_EXECUTE, 0.0f);
        targetPatch.playAnimationSynchronized(CorruptAnimations.GREATSWORD_EXECUTED, 0.8f);
    }

    private static void executeTrident(ServerPlayer player, LivingEntityPatch<?> targetPatch) {
        Vec3 viewVec = ((LivingEntity)targetPatch.getOriginal()).m_20252_(1.0f);
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        player.m_6021_(((LivingEntity)targetPatch.getOriginal()).m_20185_() + viewVec.m_7096_() * 1.5, ((LivingEntity)targetPatch.getOriginal()).m_20186_(), ((LivingEntity)targetPatch.getOriginal()).m_20189_() + viewVec.m_7094_() * 1.5);
        playerPatch.playAnimationSynchronized(CorruptAnimations.TRIDENT_EXECUTE, 0.0f);
        targetPatch.playAnimationSynchronized(CorruptAnimations.TRIDENT_EXECUTED, 0.0f);
    }

    private static void executeTachi(ServerPlayer player, LivingEntityPatch<?> targetPatch) {
        Vec3 viewVec = ((LivingEntity)targetPatch.getOriginal()).m_20252_(1.0f);
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        player.m_6021_(((LivingEntity)targetPatch.getOriginal()).m_20185_() + viewVec.m_7096_() * 2.5, ((LivingEntity)targetPatch.getOriginal()).m_20186_(), ((LivingEntity)targetPatch.getOriginal()).m_20189_() + viewVec.m_7094_() * 2.5);
        playerPatch.playAnimationSynchronized(CorruptAnimations.TACHI_EXECUTE, 0.0f);
        targetPatch.playAnimationSynchronized(CorruptAnimations.TACHI_EXECUTED, 0.0f);
    }

    private static void executeLongsword(ServerPlayer player, LivingEntityPatch<?> targetPatch) {
        Vec3 viewVec = ((LivingEntity)targetPatch.getOriginal()).m_20252_(1.0f);
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        player.m_6021_(((LivingEntity)targetPatch.getOriginal()).m_20185_() + viewVec.m_7096_() * 2.5, ((LivingEntity)targetPatch.getOriginal()).m_20186_(), ((LivingEntity)targetPatch.getOriginal()).m_20189_() + viewVec.m_7094_() * 2.5);
        playerPatch.playAnimationSynchronized(CorruptAnimations.LONGSWORD_EXECUTE, 0.15f);
        targetPatch.playAnimationSynchronized(CorruptAnimations.LONGSWORD_EXECUTED, 0.15f);
    }

    private static void executeSword(ServerPlayer player, LivingEntityPatch<?> targetPatch) {
        Vec3 viewVec = ((LivingEntity)targetPatch.getOriginal()).m_20252_(1.0f);
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        player.m_6021_(((LivingEntity)targetPatch.getOriginal()).m_20185_() + viewVec.m_7096_() * 1.5, ((LivingEntity)targetPatch.getOriginal()).m_20186_(), ((LivingEntity)targetPatch.getOriginal()).m_20189_() + viewVec.m_7094_() * 1.5);
        playerPatch.playAnimationSynchronized(CorruptAnimations.SWORD_EXECUTE, 0.0f);
        targetPatch.playAnimationSynchronized(CorruptAnimations.SWORD_EXECUTED, 0.0f);
    }

    private static void executeDefault(ServerPlayer player, LivingEntityPatch<?> targetPatch, Vec3 viewVec) {
        player.m_6021_(((LivingEntity)targetPatch.getOriginal()).m_20185_() + viewVec.m_7096_() * 1.5, ((LivingEntity)targetPatch.getOriginal()).m_20186_(), ((LivingEntity)targetPatch.getOriginal()).m_20189_() + viewVec.m_7094_() * 1.5);
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
        if (playerPatch != null) {
            playerPatch.playAnimationSynchronized(CorruptAnimations.EXECUTE_WEAPON, 0.0f);
        }
        targetPatch.playAnimationSynchronized(CorruptAnimations.EXECUTED_WEAPON, 0.25f);
    }

    static {
        EXECUTION_STRATEGIES.put(CorruptWeaponCategories.YAMATO, Execute::executeYamato);
        EXECUTION_STRATEGIES.put(CDWeaponCapabilityPresets.EX_YAMATO, Execute::executeYamato);
        EXECUTION_STRATEGIES.put(CorruptWeaponCategories.KATANA, Execute::executeKatana);
        EXECUTION_STRATEGIES.put(CapabilityItem.WeaponCategories.UCHIGATANA, Execute::executeKatana);
        EXECUTION_STRATEGIES.put(CorruptWeaponCategories.S_SPEAR, Execute::executeSpear);
        EXECUTION_STRATEGIES.put(CapabilityItem.WeaponCategories.SPEAR, Execute::executeSpear);
        EXECUTION_STRATEGIES.put(CapabilityItem.WeaponCategories.GREATSWORD, Execute::executeGreatsword);
        EXECUTION_STRATEGIES.put(CapabilityItem.WeaponCategories.TRIDENT, Execute::executeTrident);
        EXECUTION_STRATEGIES.put(CorruptWeaponCategories.S_TACHI, Execute::executeTachi);
        EXECUTION_STRATEGIES.put(CapabilityItem.WeaponCategories.TACHI, Execute::executeTachi);
        EXECUTION_STRATEGIES.put(CapabilityItem.WeaponCategories.FIST, Execute::executeFist);
        EXECUTION_STRATEGIES.put(CapabilityItem.WeaponCategories.LONGSWORD, (player, target) -> {
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
            if (playerPatch != null) {
                CapabilityItem offhand = playerPatch.getHoldingItemCapability(InteractionHand.OFF_HAND);
                if (offhand.getWeaponCategory() == CapabilityItem.WeaponCategories.SHIELD) {
                    Execute.executeDefault(player, target, ((LivingEntity)target.getOriginal()).m_20252_(1.0f));
                } else {
                    Execute.executeLongsword(player, target);
                }
            }
        });
        EXECUTION_STRATEGIES.put(CorruptWeaponCategories.S_LONGSWORD, (player, target) -> {
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
            if (playerPatch != null) {
                CapabilityItem offhand = playerPatch.getHoldingItemCapability(InteractionHand.OFF_HAND);
                if (offhand.getWeaponCategory() == CapabilityItem.WeaponCategories.SHIELD) {
                    Execute.executeDefault(player, target, ((LivingEntity)target.getOriginal()).m_20252_(1.0f));
                } else {
                    Execute.executeLongsword(player, target);
                }
            }
        });
        EXECUTION_STRATEGIES.put(CorruptWeaponCategories.GREAT_TACHI, (player, target) -> {
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
            if (playerPatch != null) {
                CapabilityItem offhand = playerPatch.getHoldingItemCapability(InteractionHand.OFF_HAND);
                if (offhand.getWeaponCategory() == CorruptWeaponCategories.GREAT_TACHI) {
                    Execute.executeDefault(player, target, ((LivingEntity)target.getOriginal()).m_20252_(1.0f));
                } else {
                    Execute.executeLongsword(player, target);
                }
            }
        });
        EXECUTION_STRATEGIES.put(CorruptWeaponCategories.S_GREATSWORD, (player, target) -> {
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
            if (playerPatch != null) {
                CapabilityItem offhand = playerPatch.getHoldingItemCapability(InteractionHand.OFF_HAND);
                if (offhand.getWeaponCategory() == CorruptWeaponCategories.S_GREATSWORD) {
                    Execute.executeDefault(player, target, ((LivingEntity)target.getOriginal()).m_20252_(1.0f));
                } else {
                    Execute.executeGreatsword(player, target);
                }
            }
        });
        EXECUTION_STRATEGIES.put(CapabilityItem.WeaponCategories.SWORD, (player, target) -> {
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
            if (playerPatch != null) {
                CapabilityItem offhand = playerPatch.getHoldingItemCapability(InteractionHand.OFF_HAND);
                if (offhand.getWeaponCategory() == CapabilityItem.WeaponCategories.SWORD) {
                    Execute.executeDefault(player, target, ((LivingEntity)target.getOriginal()).m_20252_(1.0f));
                } else {
                    Execute.executeSword(player, target);
                }
            }
        });
        EXECUTION_STRATEGIES.put(CorruptWeaponCategories.S_SWORD, (player, target) -> {
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
            if (playerPatch != null) {
                CapabilityItem offhand = playerPatch.getHoldingItemCapability(InteractionHand.OFF_HAND);
                if (offhand.getWeaponCategory() == CorruptWeaponCategories.S_SWORD) {
                    Execute.executeDefault(player, target, ((LivingEntity)target.getOriginal()).m_20252_(1.0f));
                } else {
                    Execute.executeSword(player, target);
                }
            }
        });
        EXECUTION_STRATEGIES.put(CapabilityItem.WeaponCategories.DAGGER, (player, target) -> {
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
            if (playerPatch != null) {
                CapabilityItem offhand = playerPatch.getHoldingItemCapability(InteractionHand.OFF_HAND);
                if (offhand.getWeaponCategory() == CapabilityItem.WeaponCategories.DAGGER) {
                    Execute.executeDualDagger(player, target);
                } else {
                    Execute.executeDagger(player, target);
                }
            }
        });
        EXECUTION_STRATEGIES.put(CorruptWeaponCategories.S_DAGGER, (player, target) -> {
            PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)player, PlayerPatch.class);
            if (playerPatch != null) {
                CapabilityItem offhand = playerPatch.getHoldingItemCapability(InteractionHand.OFF_HAND);
                if (offhand.getWeaponCategory() == CorruptWeaponCategories.S_DAGGER) {
                    Execute.executeDualDagger(player, target);
                } else {
                    Execute.executeDagger(player, target);
                }
            }
        });
        if (Execute.isClassAvailable()) {
            try {
                Class<?> rapierCategoryClass = Class.forName("net.yonchi.refm.world.capabilities.item.RapierWeaponCategories");
                Class<Enum> enumClass = rapierCategoryClass.asSubclass(Enum.class);
                Enum rapier = enumClass.getEnumConstants()[0];
                Object enderRapier = enumClass.getField("ENDER_RAPIER").get(null);
                Object witherRapier = enumClass.getField("WITHER_RAPIER").get(null);
                Object oceanRapier = enumClass.getField("OCEAN_RAPIER").get(null);
                Object amethystRapier = enumClass.getField("AMETHYST_RAPIER").get(null);
                EXECUTION_STRATEGIES.put(rapier, Execute::executeLongsword);
                EXECUTION_STRATEGIES.put(enderRapier, Execute::executeTachi);
                EXECUTION_STRATEGIES.put(witherRapier, Execute::executeSword);
                EXECUTION_STRATEGIES.put(oceanRapier, Execute::executeSword);
                EXECUTION_STRATEGIES.put(amethystRapier, Execute::executeSword);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to load RapierWeaponCategories class or process execution strategies", (Throwable)e);
            }
        }
    }
}

