/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.skill.Passive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.corruptdog.cdm.gameasset.CorruptAnimations;
import net.corruptdog.cdm.gameasset.CorruptSound;
import net.corruptdog.cdm.network.server.NetworkManager;
import net.corruptdog.cdm.network.server.SPAfterImagine;
import net.corruptdog.cdm.skill.CDSkillDataKeys;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class BloodWolf
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("123e4567-e89b-12d3-a456-426614174000");
    private static final ResourceLocation BLOODWOLF_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"cdmoveset", (String)"textures/gui/skills/passive/bloodwolf.png");
    private static final int MAX_WOLFPASSIVE = 10;
    private static final int TIMER_DURATION = 800;
    private static final int TIMER_INTERVAL = 40;
    private static final int MAX_DAMAGE = 5;

    public BloodWolf(SkillBuilder<? extends PassiveSkill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID, event -> {
            Integer wolfPassive = (Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.WOLFPASSIVE.get());
            if (wolfPassive == null) {
                wolfPassive = 0;
            }
            container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.WOLFPASSIVE.get(), (Object)(wolfPassive + 1));
            if (wolfPassive < 10) {
                container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.WOLFPASSIVE.get(), (Object)(wolfPassive + 1));
                System.out.println(container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.WOLFPASSIVE.get()));
                if (wolfPassive + 1 == 10) {
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)CorruptSound.SKILL.get(), 0.8f, 1.2f);
                    container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.TIMER.get(), (Object)800);
                }
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            Integer damage = (Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.DAMAGE.get());
            if (damage == null) {
                damage = 0;
            }
            if (damage > 5) {
                float attackDamage = event.getBaseDamage();
                event.attachValueModifier(ValueModifier.multiplier((float)1.5f));
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID, event -> {
            Integer wolfPassive = (Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.WOLFPASSIVE.get());
            if (wolfPassive == null) {
                wolfPassive = 0;
            }
            if (event.getAttackDamage() > event.getTarget().m_21223_() && wolfPassive < 10 && wolfPassive + 1 != 10) {
                container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.WOLFPASSIVE.get(), (Object)(wolfPassive + 1));
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID, event -> {
            Integer wolfPassive = (Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.WOLFPASSIVE.get());
            if (wolfPassive == null) {
                wolfPassive = 0;
            }
            if (wolfPassive == 10 && event.getDamageSource().m_7639_() != null) {
                double probability = 0.4;
                if (Math.random() < probability) {
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)CorruptSound.HURT.get(), 0.8f, 1.2f);
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.BLADE_HIT.get(), 0.8f, 1.2f);
                    ServerPlayer playerentity = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
                    DamageSource damageSource = event.getDamageSource();
                    ((HitParticleType)EpicFightParticles.HIT_BLADE.get()).spawnParticleWithArgument(playerentity.m_284548_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)playerentity, damageSource.m_7640_());
                    ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized((AssetAccessor)Animations.SWORD_GUARD_ACTIVE_HIT3, 0.0f);
                    event.setCanceled(true);
                    event.setResult(AttackResult.ResultType.BLOCKED);
                    BloodWolf.HIT((Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal(), ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_9236_());
                }
            }
        });
    }

    private static void HIT(Player player, Level level) {
        if (player == null) {
            return;
        }
        if (!level.m_5776_()) {
            Vec3 _center = new Vec3(player.m_20185_(), player.m_20188_(), player.m_20189_());
            List<LivingEntity> entfound = level.m_6443_(LivingEntity.class, new AABB(_center, _center).m_82400_(3.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.m_20238_(_center))).limit(4L).toList();
            for (LivingEntity entityiterator : entfound) {
                LivingEntityPatch ep = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entityiterator, LivingEntityPatch.class);
                if (ep == null || entityiterator == player) continue;
                ep.playAnimationSynchronized(CorruptAnimations.BIPED_HIT_LONG2, 0.0f);
            }
        }
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.TAKE_DAMAGE_EVENT_ATTACK, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DEAL_DAMAGE_EVENT_DAMAGE, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, GuiGraphics guiGraphics, float x, float y) {
        String string;
        PoseStack poseStack = new PoseStack();
        poseStack.m_85836_();
        Objects.requireNonNull(gui.getFont());
        poseStack.m_252880_(0.0f, 9.0f, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int wolfPassive = (Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.WOLFPASSIVE.get());
        if (wolfPassive == 11) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
            guiGraphics.m_280411_(this.getSkillTexture(), (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
            string = String.valueOf((Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.TIMER.get()) / 40);
        } else if (wolfPassive < 10) {
            string = String.valueOf(wolfPassive);
            guiGraphics.m_280411_(BLOODWOLF_TEXTURE, (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        } else {
            string = String.valueOf((Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.TIMER.get()) / 40);
            guiGraphics.m_280411_(BLOODWOLF_TEXTURE, (int)x, (int)y, 24, 24, 0.0f, 0.0f, 1, 1, 1, 1);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.drawString(gui.getFont(), string, x + 13.0f - (float)gui.getFont().m_92895_(string), y + 10.0f, 0xFFFFFF, true);
        poseStack.m_85836_();
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecutor().isLogicalClient()) {
            SPAfterImagine msg;
            ServerPlayer serverPlayer;
            int timer = (Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.TIMER.get());
            int wolfPassive = (Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.WOLFPASSIVE.get());
            if (timer == 0 && wolfPassive == 10) {
                ((Player)container.getExecutor().getOriginal()).m_216990_((SoundEvent)CorruptSound.HURT.get());
            }
            if (timer == 0 && wolfPassive == 11) {
                ((Player)container.getExecutor().getOriginal()).m_216990_((SoundEvent)CorruptSound.HURT.get());
            }
            if (timer == 800 && wolfPassive == 10) {
                container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.DAMAGE.get(), (Object)6);
                serverPlayer = (ServerPlayer)container.getExecutor().getOriginal();
                msg = new SPAfterImagine(serverPlayer.m_20182_(), serverPlayer.m_19879_());
                NetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg, serverPlayer);
            }
            if (timer > 0) {
                container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.TIMER.get(), (Object)(timer - 1));
                if (timer == 1) {
                    container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.TIMER.get(), (Object)800);
                    serverPlayer = (ServerPlayer)container.getExecutor().getOriginal();
                    msg = new SPAfterImagine(serverPlayer.m_20182_(), serverPlayer.m_19879_());
                    NetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg, serverPlayer);
                    container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.DAMAGE.get(), (Object)0);
                    if (wolfPassive == 10) {
                        container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.WOLFPASSIVE.get(), (Object)11);
                    } else {
                        container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.WOLFPASSIVE.get(), (Object)0);
                        container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.DAMAGE.get(), (Object)0);
                    }
                }
            }
        }
    }
}

