/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.skill.Dodge;

import java.util.UUID;
import net.corruptdog.cdm.gameasset.CorruptAnimations;
import net.corruptdog.cdm.gameasset.CorruptSound;
import net.corruptdog.cdm.network.server.NetworkManager;
import net.corruptdog.cdm.network.server.SPAfterImagine;
import net.corruptdog.cdm.skill.CDSkillDataKeys;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.client.CPSkillRequest;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillCategory;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataKey;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class SStep
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("e33b7c1a-8909-47c1-9b95-81f9d86c412e");
    public static final int RESET_TICKS = 100;
    protected final AnimationManager.AnimationAccessor<? extends StaticAnimation>[][] animations;

    public static Builder createDodgeBuilder() {
        return (Builder)new Builder().setCategory((SkillCategory)SkillCategories.DODGE).setActivateType(Skill.ActivateType.ONE_SHOT).setResource(Skill.Resource.STAMINA);
    }

    public SStep(Builder builder) {
        super((SkillBuilder)builder);
        this.animations = builder.animations;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID, event -> {
            Player player = (Player)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            if (!((Boolean)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.DODGE_PLAYED.get())).booleanValue()) {
                if (player.m_9236_() instanceof ServerLevel) {
                    float consumption = container.getExecutor().getModifiedStaminaConsume(container.getExecutor().getSkill((SkillSlot)SkillSlots.DODGE).getSkill().getConsumption());
                    container.getExecutor().setStamina(container.getExecutor().getStamina() + consumption * 0.5f);
                    ServerPlayer serverPlayer = (ServerPlayer)container.getExecutor().getOriginal();
                    SPAfterImagine msg = new SPAfterImagine(serverPlayer.m_20182_(), serverPlayer.m_19879_());
                    NetworkManager.sendToAllPlayerTrackingThisEntityWithSelf(msg, serverPlayer);
                    ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)CorruptSound.DODGE.get(), 1.0f, 1.2f);
                    Skill skill = container.getExecutor().getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill();
                    if (skill != null) {
                        SkillContainer weaponInnateContainer = ((ServerPlayerPatch)event.getPlayerPatch()).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
                        weaponInnateContainer.getSkill().setConsumptionSynchronize(container, weaponInnateContainer.getResource() + 5.0f);
                    } else {
                        ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(CorruptAnimations.WOLFDODGE_BACKWARD, 0.25f);
                    }
                }
                container.getDataManager().setData((SkillDataKey)CDSkillDataKeys.DODGE_PLAYED.get(), (Object)true);
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(this.animations[3][(Integer)container.getDataManager().getDataValue((SkillDataKey)CDSkillDataKeys.DIRECTION.get())], 0.0f);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(LocalPlayerPatch executer, FriendlyByteBuf args) {
        float degree;
        Input input = Minecraft.m_91087_().f_91074_.f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)Minecraft.m_91087_().f_91074_)), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        int forward = input.f_108568_ ? 1 : 0;
        int backward = input.f_108569_ ? -1 : 0;
        int left = input.f_108570_ ? 1 : 0;
        int right = input.f_108571_ ? -1 : 0;
        int vertic = forward + backward;
        int horizon = left + right;
        float f = degree = vertic == 0 ? 0.0f : (float)(-(90 * horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon));
        int animation = vertic == 0 ? (horizon == 0 ? 0 : (horizon >= 0 ? 2 : 3)) : (vertic >= 0 ? 0 : 1);
        degree = MathUtils.lerpBetween((float)degree, (float)((LocalPlayer)executer.getOriginal()).m_146908_(), (float)1.0f);
        CPSkillRequest packet = new CPSkillRequest(executer.getSkill((Skill)this).getSlot());
        packet.getBuffer().writeInt(animation);
        packet.getBuffer().writeFloat(degree);
        return packet;
    }

    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        super.executeOnServer(skillContainer, args);
        int i = args.readInt();
        float yaw = args.readFloat();
        SkillDataManager dataManager = skillContainer.getExecutor().getSkill((SkillSlot)SkillSlots.DODGE).getDataManager();
        dataManager.setData((SkillDataKey)CDSkillDataKeys.DODGE_PLAYED.get(), (Object)false);
        int count = (Integer)dataManager.getDataValue((SkillDataKey)CDSkillDataKeys.COUNT.get());
        skillContainer.getExecutor().playAnimationSynchronized(this.animations[count][i], 0.0f);
        dataManager.setDataSync((SkillDataKey)CDSkillDataKeys.DIRECTION.get(), (Object)i);
        if (count != 0) {
            dataManager.setDataSync((SkillDataKey)CDSkillDataKeys.RESET_TIMER.get(), (Object)100);
        }
        dataManager.setDataSync((SkillDataKey)CDSkillDataKeys.COUNT.get(), (Object)(++count % 3));
        skillContainer.getExecutor().setModelYRot(yaw, true);
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        SkillDataManager manager = container.getDataManager();
        if (manager.hasData((SkillDataKey)CDSkillDataKeys.RESET_TIMER.get()) && (Integer)manager.getDataValue((SkillDataKey)CDSkillDataKeys.RESET_TIMER.get()) > 0) {
            manager.setData((SkillDataKey)CDSkillDataKeys.RESET_TIMER.get(), (Object)((Integer)manager.getDataValue((SkillDataKey)CDSkillDataKeys.RESET_TIMER.get()) - 1));
            if ((Integer)manager.getDataValue((SkillDataKey)CDSkillDataKeys.RESET_TIMER.get()) == 1 && manager.hasData((SkillDataKey)CDSkillDataKeys.COUNT.get())) {
                manager.setData((SkillDataKey)CDSkillDataKeys.COUNT.get(), (Object)0);
            }
        }
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        return !executer.isInAir() && playerState.canUseSkill() && !((Player)executer.getOriginal()).m_20069_() && !((Player)executer.getOriginal()).m_6147_() && ((Player)executer.getOriginal()).m_20202_() == null;
    }

    public static class Builder
    extends SkillBuilder<SStep> {
        protected AnimationManager.AnimationAccessor[][] animations = new AnimationManager.AnimationAccessor[4][4];

        @SafeVarargs
        public final Builder setAnimations1(AnimationManager.AnimationAccessor<? extends StaticAnimation> ... animations) {
            this.animations[0] = animations;
            return this;
        }

        @SafeVarargs
        public final Builder setAnimations2(AnimationManager.AnimationAccessor<? extends StaticAnimation> ... animations) {
            this.animations[1] = animations;
            return this;
        }

        @SafeVarargs
        public final Builder setAnimations3(AnimationManager.AnimationAccessor<? extends StaticAnimation> ... animations) {
            this.animations[2] = animations;
            return this;
        }

        @SafeVarargs
        public final Builder setPerfectAnimations(AnimationManager.AnimationAccessor<? extends StaticAnimation> ... animations) {
            this.animations[3] = animations;
            return this;
        }
    }
}

