/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.skill.Dodge;

import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.network.client.CPSkillRequest;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class Dodge
extends DodgeSkill {
    private static final UUID EVENT_UUID = UUID.fromString("2f1cd1fe-dfd4-407e-88c0-4ea494509f3f");

    public Dodge(DodgeSkill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
    }

    public void executeOnServer(SkillContainer skillContainer, FriendlyByteBuf args) {
        super.executeOnServer(skillContainer, args);
        int i = args.readInt();
        float yRot = args.readFloat();
        skillContainer.getExecutor().playAnimationSynchronized((AssetAccessor)this.animations[i], 0.0f);
        skillContainer.getExecutor().setModelYRot(yRot, true);
    }

    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.COMBO_COUNTER_HANDLE_EVENT, EVENT_UUID);
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        EntityState playerState = executer.getEntityState();
        return !executer.isInAir() && playerState.canUseSkill() && !((Player)executer.getOriginal()).m_20069_() && !((Player)executer.getOriginal()).m_6147_() && ((Player)executer.getOriginal()).m_20202_() == null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Object getExecutionPacket(SkillContainer skillContainer, FriendlyByteBuf args) {
        float degree;
        Input input = Minecraft.m_91087_().f_91074_.f_108618_;
        float pulse = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)Minecraft.m_91087_().f_91074_)), (float)0.0f, (float)1.0f);
        input.m_214106_(false, pulse);
        int forward = input.f_108568_ ? 1 : 0;
        int backward = input.f_108569_ ? -1 : 0;
        int left = input.f_108570_ ? 1 : 0;
        int right = input.f_108571_ ? -1 : 0;
        int vertic = forward + backward;
        int horizon = left + right;
        float f = degree = vertic == 0 ? 0.0f : (float)(-(45 * vertic * horizon));
        int animation = vertic == 0 ? (horizon == 0 ? 0 : (horizon >= 0 ? 2 : 3)) : (vertic >= 0 ? 0 : 1);
        degree = MathUtils.lerpBetween((float)degree, (float)((Player)skillContainer.getExecutor().getOriginal()).m_146908_(), (float)1.0f);
        CPSkillRequest packet = new CPSkillRequest(skillContainer.getSlot());
        packet.getBuffer().writeInt(animation);
        packet.getBuffer().writeFloat(degree);
        return packet;
    }
}

