/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.mixins;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.corruptdog.cdm.Config.CDConfig;
import net.corruptdog.cdm.gameasset.CorruptSound;
import net.corruptdog.cdm.skill.SlowTime;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillBuilder;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

@Mixin(value={DodgeSkill.class}, remap=false)
public class DodgeSkillMixin
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("99e5c782-fdaf-11eb-9a03-0242ac130005");

    public DodgeSkillMixin(SkillBuilder<? extends Skill> builder) {
        super(builder);
    }

    @Unique
    public void Slow_time(SkillContainer container) {
        Level var3 = ((Player)container.getExecutor().getOriginal()).m_9236_();
        if (((Player)container.getExecutor().getOriginal()).m_9236_().m_7654_() != null && !FMLEnvironment.dist.isDedicatedServer() && ((Player)container.getExecutor().getOriginal()).m_9236_().m_7654_().m_7416_() <= 1 && var3 instanceof ServerLevel) {
            SlowTime.changeAll(20.0f);
        }
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID, event -> {
            if (((Boolean)CDConfig.ENABLE_DODGESUCCESS_SOUND.get()).booleanValue()) {
                container.getExecutor().playSound((SoundEvent)CorruptSound.FORESIGHT.get(), 0.8f, 1.2f);
            }
            if (((Boolean)CDConfig.SLOW_TIME.get()).booleanValue() && ((Player)container.getExecutor().getOriginal()).m_9236_().m_7654_() != null && !FMLEnvironment.dist.isDedicatedServer() && Objects.requireNonNull(((Player)container.getExecutor().getOriginal()).m_9236_().m_7654_()).m_7416_() <= 1) {
                SlowTime.changeAll(8.0f);
                ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
                scheduledExecutorService.schedule(() -> this.Slow_time(container), 500L, TimeUnit.MILLISECONDS);
            }
        });
        container.getExecutor().getEventListener().addEventListener(PlayerEventListener.EventType.ANIMATION_BEGIN_EVENT, EVENT_UUID, event -> {
            StaticAnimation animation = event.getAnimation();
            if (((Boolean)CDConfig.ENABLE_DODGE_SOUND.get()).booleanValue() && (animation == Animations.BIPED_STEP_FORWARD || animation == Animations.BIPED_STEP_BACKWARD || animation == Animations.BIPED_STEP_LEFT || animation == Animations.BIPED_STEP_RIGHT)) {
                event.getPlayerPatch().playSound((SoundEvent)CorruptSound.STEP.get(), 0.8f, 1.0f);
            }
        });
    }

    @Unique
    public void onRemoved(SkillContainer container) {
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.DODGE_SUCCESS_EVENT, EVENT_UUID);
    }
}

