/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.entity;

import java.util.ArrayList;
import java.util.List;
import net.corruptdog.cdm.entity.init.CorruptFightMobEntity;
import net.corruptdog.cdm.world.item.CDAddonItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class CorruptDog
extends TamableAnimal
implements RangedAttackMob {
    private boolean isMeleeMode = false;
    private int weaponSwitchCooldown = 0;
    private final RangedBowAttackGoal<CorruptDog> bowGoal = new RangedBowAttackGoal((Mob)this, 1.0, 20, 15.0f);
    private final MeleeAttackGoal meleeGoal = new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

        public void m_8041_() {
            super.m_8041_();
            CorruptDog.this.m_21561_(false);
        }

        public void m_8056_() {
            super.m_8056_();
            CorruptDog.this.m_21561_(true);
        }
    };
    public static final List<Item> WEAPONS = new ArrayList<Item>();

    public CorruptDog(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<CorruptDog>)((EntityType)CorruptFightMobEntity.CORRUPTDOG.get()), world);
    }

    public CorruptDog(EntityType<CorruptDog> type, Level world) {
        super(type, world);
        this.m_274367_(0.6f);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_6593_((Component)Component.m_237113_((String)"Corrupt_Dog"));
        this.m_20340_(true);
        WEAPONS.add((Item)CDAddonItems.S_IRON_LONGSWORD.get());
        WEAPONS.add((Item)CDAddonItems.S_NETHERITE_TACHI.get());
        this.m_21008_(InteractionHand.MAIN_HAND, WEAPONS.get(this.m_217043_().m_188503_(WEAPONS.size())).m_7968_());
    }

    public boolean m_5886_(@NotNull ProjectileWeaponItem pProjectileWeapon) {
        return pProjectileWeapon == Items.f_42411_ || pProjectileWeapon == Items.f_42713_;
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, pDistanceFactor);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double targetVelocityX = pTarget.m_20184_().f_82479_;
        double targetVelocityY = pTarget.m_20184_().f_82480_;
        double targetVelocityZ = pTarget.m_20184_().f_82481_;
        double dx = pTarget.m_20185_() - this.m_20185_();
        double dy = pTarget.m_20227_(0.3333333333333333) - this.m_20186_();
        double dz = pTarget.m_20189_() - this.m_20189_();
        double distance = Math.sqrt(dx * dx + dz * dz);
        double timeToReach = distance / (double)1.6f;
        double predictedX = pTarget.m_20185_() + targetVelocityX * timeToReach;
        double predictedY = pTarget.m_20186_() + targetVelocityY * timeToReach + 0.3333333333333333;
        double predictedZ = pTarget.m_20189_() + targetVelocityZ * timeToReach;
        double d0 = predictedX - this.m_20185_();
        double d1 = predictedY - abstractarrow.m_20186_();
        double d2 = predictedZ - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        abstractarrow.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)abstractarrow);
    }

    public void reassessWeaponGoal() {
        this.m_9236_();
        if (!this.m_9236_().f_46443_) {
            this.f_21345_.m_25363_((Goal)this.meleeGoal);
            this.f_21345_.m_25363_(this.bowGoal);
            ItemStack itemstack = this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem));
            if (itemstack.m_150930_(Items.f_42411_)) {
                int i = 20;
                if (this.m_9236_().m_46791_() != Difficulty.HARD) {
                    i = 30;
                }
                this.bowGoal.m_25797_(i);
                this.bowGoal.m_25797_(i);
                this.f_21345_.m_25352_(4, this.bowGoal);
            } else {
                this.f_21345_.m_25352_(4, (Goal)this.meleeGoal);
            }
        }
    }

    protected AbstractArrow getArrow(ItemStack pArrowStack, float pVelocity) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)pArrowStack, (float)pVelocity);
    }

    public AgeableMob m_142606_(@NotNull ServerLevel serverWorld, @NotNull AgeableMob ageable) {
        CorruptDog retval = (CorruptDog)((EntityType)CorruptFightMobEntity.CORRUPTDOG.get()).m_20615_((Level)serverWorld);
        if (retval != null) {
            retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        }
        return retval;
    }

    public void m_8119_() {
        LivingEntity target;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && (target = this.m_5448_()) instanceof Player) {
            Player player = (Player)target;
            double distance = this.m_20270_((Entity)player);
            ItemStack currentWeapon = this.m_21120_(InteractionHand.MAIN_HAND);
            if (this.weaponSwitchCooldown > 0) {
                --this.weaponSwitchCooldown;
                return;
            }
            if (distance > 10.0 && !(currentWeapon.m_41720_() instanceof BowItem)) {
                this.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42411_));
                this.reassessWeaponGoal();
                this.isMeleeMode = false;
                this.weaponSwitchCooldown = 20;
            } else if (distance <= 10.0 && currentWeapon.m_41720_() instanceof BowItem) {
                this.m_21008_(InteractionHand.MAIN_HAND, WEAPONS.get(this.m_217043_().m_188503_(WEAPONS.size())).m_7968_());
                this.reassessWeaponGoal();
                this.isMeleeMode = true;
                this.weaponSwitchCooldown = 20;
            } else if (distance <= 10.0 && !(currentWeapon.m_41720_() instanceof BowItem)) {
                this.isMeleeMode = true;
            }
        }
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.reassessWeaponGoal();
    }

    public void m_8061_(@NotNull EquipmentSlot pSlot, @NotNull ItemStack pStack) {
        super.m_8061_(pSlot, pStack);
        if (!this.m_9236_().f_46443_) {
            this.reassessWeaponGoal();
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Monster.class, false, false));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, EnderMan.class, false, false));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(@NotNull LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public double m_6049_() {
        return -0.35;
    }

    public SoundEvent m_7975_(@NotNull DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.fromNamespaceAndPath((String)"cdmoveset", (String)"entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.fromNamespaceAndPath((String)"cdmoveset", (String)"entity.generic.death"));
    }

    public boolean m_6469_(DamageSource damagesource, float amount) {
        ItemStack currentWeapon;
        if (damagesource.m_276093_(DamageTypes.f_268631_)) {
            return false;
        }
        if (damagesource.m_7639_() instanceof Player && (currentWeapon = this.m_21120_(InteractionHand.MAIN_HAND)).m_41720_() instanceof BowItem) {
            this.m_21008_(InteractionHand.MAIN_HAND, WEAPONS.get(this.m_217043_().m_188503_(WEAPONS.size())).m_7968_());
            this.reassessWeaponGoal();
        }
        return super.m_6469_(damagesource, amount);
    }

    public boolean m_6128_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 200.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }
}

