/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.api.animation.types;

import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.HurtableEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;

public class KnockbackAnimation
extends AttackAnimation {
    public KnockbackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends KnockbackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        this(convertTime, accessor, armature, new AttackAnimation.Phase(0.0f, antic, preDelay, contact, recovery, Float.MAX_VALUE, colliderJoint, collider));
    }

    public KnockbackAnimation(float convertTime, AnimationManager.AnimationAccessor<? extends KnockbackAnimation> accessor, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(convertTime, accessor, armature, phases);
        this.newTimePair(0.0f, Float.MAX_VALUE);
        this.addStateRemoveOld(EntityState.TURNING_LOCKED, true);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, MoveCoordFunctions.TRACE_TARGET_DISTANCE);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, (self, entitypatch, transformSheet) -> {
            LivingEntity attackTarget = entitypatch.getTarget();
            if (!self.getProperty((AnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE).orElse(false).booleanValue() && attackTarget != null) {
                TransformSheet transform = ((TransformSheet)self.getTransfroms().get("Root")).copyAll();
                Keyframe[] keyframes = transform.getKeyframes();
                int startFrame = 0;
                int endFrame = transform.getKeyframes().length - 1;
                Vec3f keyLast = keyframes[endFrame].transform().translation();
                Vec3 pos = ((LivingEntity)entitypatch.getOriginal()).m_146892_();
                Vec3 targetpos = attackTarget.m_20182_().m_82549_(attackTarget.m_20184_().m_82490_(8.0));
                float horizontalDistance = Math.max((float)targetpos.m_82546_(pos).m_165924_() * 1.3f - (attackTarget.m_20205_() + ((LivingEntity)entitypatch.getOriginal()).m_20205_()), 0.0f);
                Vec3f worldPosition = new Vec3f(keyLast.x, 0.0f, -horizontalDistance);
                float scale = Math.min(worldPosition.length() / keyLast.length(), 2.0f);
                for (int i = startFrame; i <= endFrame; ++i) {
                    Vec3f translation = keyframes[i].transform().translation();
                    translation.z *= scale;
                }
                transformSheet.readFrom(transform);
            } else {
                transformSheet.readFrom((TransformSheet)self.getTransfroms().get("Root"));
            }
        });
    }

    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        entitypatch.setLastAttackSuccess(false);
    }

    protected void hurtCollidingEntities(LivingEntityPatch<?> entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
        LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
        float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
        float poseTime = state.attacking() ? elapsedTime : phase.contact;
        List list = this.getPhaseByTime(elapsedTime).getCollidingEntities(entitypatch, (AttackAnimation)this, prevPoseTime, poseTime, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
        if (!list.isEmpty()) {
            HitEntityList hitEntities = new HitEntityList(entitypatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            int maxStrikes = this.getMaxStrikes(entitypatch, phase);
            while (true) {
                if (entitypatch.getCurrentlyAttackTriedEntities().size() >= maxStrikes || !hitEntities.next()) {
                    return;
                }
                Entity hitten = hitEntities.getEntity();
                LivingEntity truehittenEntity = this.getTrueEntity(hitten);
                if (truehittenEntity == null || !truehittenEntity.m_6084_() || entitypatch.getCurrentlyAttackTriedEntities().contains(truehittenEntity) || entitypatch.getCurrentlyAttackTriedEntities().contains(hitten) || !(hitten instanceof LivingEntity) && !(hitten instanceof PartEntity) || !entity.m_142582_(hitten)) continue;
                HurtableEntityPatch hitHurtableEntityPatch = (HurtableEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)hitten, HurtableEntityPatch.class);
                EpicFightDamageSource source = this.getEpicFightDamageSource(entitypatch, hitten, phase);
                if (hitHurtableEntityPatch != null) {
                    if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).isPresent()) {
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.NONE) {
                            if (truehittenEntity instanceof Player) {
                                source.setStunType(StunType.LONG);
                                source.setBaseImpact((float)((double)(source.getBaseImpact() * 4.0f) / (1.0 - truehittenEntity.m_21133_(Attributes.f_22278_))));
                            } else {
                                source.setStunType(StunType.NONE);
                            }
                        } else if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.HOLD && ((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                            source.setStunType(StunType.NONE);
                        } else if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.FALL && ((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                            source.setStunType(StunType.NONE);
                        } else if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.KNOCKDOWN && ((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                            source.setStunType(StunType.NONE);
                        } else {
                            source = this.getEpicFightDamageSource(entitypatch, hitten, phase);
                        }
                    } else {
                        source = this.getEpicFightDamageSource(entitypatch, hitten, phase);
                    }
                }
                int prevInvulTime = hitten.f_19802_;
                hitten.f_19802_ = 0;
                AttackResult attackResult = entitypatch.attack(source, hitten, phase.hand);
                hitten.f_19802_ = prevInvulTime;
                if (attackResult.resultType.dealtDamage()) {
                    if (source.getStunType() == StunType.KNOCKDOWN) {
                        truehittenEntity.m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 60, 0, true, false, false));
                        if (truehittenEntity.m_21023_(MobEffects.f_19591_)) {
                            truehittenEntity.m_21195_(MobEffects.f_19591_);
                        }
                        if (truehittenEntity.m_21023_(MobEffects.f_19591_)) {
                            truehittenEntity.m_21195_(MobEffects.f_19591_);
                        }
                    }
                    hitten.m_9236_().m_6263_(null, hitten.m_20185_(), hitten.m_20186_(), hitten.m_20189_(), this.getHitSound(entitypatch, phase), hitten.m_5720_(), 1.0f, 1.0f);
                    this.spawnHitParticle((ServerLevel)hitten.m_9236_(), entitypatch, hitten, phase);
                    if (hitHurtableEntityPatch != null && phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).isPresent() && !((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_21023_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get())) {
                        float stunTime;
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.NONE && !(truehittenEntity instanceof Player)) {
                            stunTime = (float)((double)(source.getBaseImpact() * 0.4f) * (1.0 - truehittenEntity.m_21133_(Attributes.f_22278_)));
                            if (((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_6084_()) {
                                hitHurtableEntityPatch.applyStun(source.getStunType() == StunType.KNOCKDOWN ? StunType.KNOCKDOWN : StunType.LONG, stunTime);
                                float power = source.getBaseImpact() * 0.25f;
                                double d1 = entity.m_20185_() - hitten.m_20185_();
                                double d0 = entity.m_20189_() - hitten.m_20189_();
                                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                                    d1 = (Math.random() - Math.random()) * 0.01;
                                    d0 = (Math.random() - Math.random()) * 0.01;
                                }
                                if ((double)(power = (float)((double)power * (1.0 - truehittenEntity.m_21133_(Attributes.f_22278_)))) > 0.0) {
                                    hitten.f_19812_ = true;
                                    Vec3 vec3 = hitten.m_20184_();
                                    Vec3 vec31 = new Vec3(d1, 0.0, d0).m_82541_().m_82490_((double)power);
                                    hitten.m_7618_(EntityAnchorArgument.Anchor.FEET, entity.m_20182_());
                                    hitten.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, hitten.m_20096_() ? Math.min(0.4, vec3.f_82480_ / 2.0) : 0.0, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                                }
                            }
                        }
                        if (phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).get() == StunType.FALL) {
                            stunTime = (float)((double)(source.getBaseImpact() * 0.4f) * (1.0 - truehittenEntity.m_21133_(Attributes.f_22278_)));
                            if (((LivingEntity)hitHurtableEntityPatch.getOriginal()).m_6084_()) {
                                hitHurtableEntityPatch.applyStun(source.getStunType() == StunType.KNOCKDOWN ? StunType.KNOCKDOWN : StunType.SHORT, stunTime);
                                double power = source.getBaseImpact() * 0.25f;
                                double d1 = entity.m_20185_() - hitten.m_20185_();
                                double d2 = entity.m_20186_() - 8.0 - hitten.m_20186_();
                                double d0 = entity.m_20189_() - hitten.m_20189_();
                                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                                    d1 = (Math.random() - Math.random()) * 0.01;
                                    d0 = (Math.random() - Math.random()) * 0.01;
                                }
                                if (!(truehittenEntity instanceof Player)) {
                                    power *= 1.0 - truehittenEntity.m_21133_(Attributes.f_22278_);
                                }
                                if (power > 0.0) {
                                    hitten.f_19812_ = true;
                                    Vec3 vec3 = entity.m_20184_();
                                    Vec3 vec31 = new Vec3(d1, d2, d0).m_82541_().m_82490_(power);
                                    if (!(truehittenEntity instanceof Player) || !(entitypatch instanceof PlayerPatch)) {
                                        hitten.m_20334_(vec3.f_82479_ / 2.0 - vec31.f_82479_, vec3.f_82480_ / 2.0 - vec31.f_82480_, vec3.f_82481_ / 2.0 - vec31.f_82481_);
                                    }
                                }
                                if (truehittenEntity instanceof Player && entitypatch instanceof PlayerPatch) {
                                    truehittenEntity.m_7292_(new MobEffectInstance(MobEffects.f_19620_, 5, (int)(power * 4.0 * 6.0), true, false, false));
                                }
                                truehittenEntity.m_7292_(new MobEffectInstance(MobEffects.f_19591_, (int)(power * 4.0 * 6.0), 20, true, false, false));
                            }
                        }
                    }
                }
                entitypatch.getCurrentlyAttackTriedEntities().add(truehittenEntity);
                if (!attackResult.resultType.shouldCount()) continue;
                entitypatch.getCurrentlyAttackTriedEntities().add(truehittenEntity);
            }
        }
    }

    public void postInit() {
        super.postInit();
        if (!this.properties.containsKey(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED)) {
            float basisSpeed = Float.parseFloat(String.format(Locale.US, "%.2f", Float.valueOf(1.0f / this.getTotalTime())));
            this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, Float.valueOf(basisSpeed));
        }
    }

    protected Vec3 getCoordVector(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> dynamicAnimation) {
        Vec3 vec3 = super.getCoordVector(entitypatch, dynamicAnimation);
        if (entitypatch.shouldBlockMoving() && this.getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE).orElse(false).booleanValue()) {
            vec3 = vec3.m_82490_(0.0);
        }
        return vec3;
    }

    public boolean isBasicAttackAnimation() {
        return true;
    }
}

