/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.api.animation.types;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.animation.property.JointMaskEntry;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class InvincibleAttackAnimation
extends AttackAnimation {
    public static final Function<DamageSource, AttackResult.ResultType> INVINCIBLE = damagesource -> {
        if (damagesource.m_7639_() != null) {
            return AttackResult.ResultType.MISSED;
        }
        return AttackResult.ResultType.SUCCESS;
    };

    public InvincibleAttackAnimation(float transitionTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends InvincibleAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, antic, preDelay, contact, recovery, collider, colliderJoint, accessor, armature);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, true);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL, false);
        this.addProperty(AnimationProperty.StaticAnimationProperty.POSE_MODIFIER, Animations.ReusableSources.COMBO_ATTACK_DIRECTION_MODIFIER);
    }

    protected void bindPhaseState(AttackAnimation.Phase phase) {
        float preDelay = phase.preDelay;
        this.stateSpectrumBlueprint.newTimePair(Float.MIN_VALUE, Float.MAX_VALUE).addState(EntityState.MOVEMENT_LOCKED, (Object)true).addState(EntityState.TURNING_LOCKED, (Object)true).newTimePair(phase.start, preDelay).addState(EntityState.PHASE_LEVEL, (Object)1).newTimePair(phase.start, phase.contact).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).addState(EntityState.CAN_SKILL_EXECUTION, (Object)false).newTimePair(phase.start, phase.recovery).addState(EntityState.MOVEMENT_LOCKED, (Object)true).addState(EntityState.UPDATE_LIVING_MOTION, (Object)false).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).newTimePair(phase.start, phase.end).addState(EntityState.HURT_LEVEL, (Object)1).addState(EntityState.INACTION, (Object)true).addState(EntityState.MOVEMENT_LOCKED, (Object)true).newTimePair(preDelay, phase.contact).addState(EntityState.TURNING_LOCKED, (Object)true).addState(EntityState.ATTACKING, (Object)true).addState(EntityState.PHASE_LEVEL, (Object)2).newTimePair(phase.contact, phase.end).addState(EntityState.PHASE_LEVEL, (Object)3).addState(EntityState.TURNING_LOCKED, (Object)true).newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.ATTACK_RESULT, INVINCIBLE);
    }

    public void postInit() {
        super.postInit();
        if (!this.properties.containsKey(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED)) {
            float basisSpeed = Float.parseFloat(String.format(Locale.US, "%.2f", Float.valueOf(1.0f / this.getTotalTime())));
            this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, Float.valueOf(basisSpeed));
        }
    }

    public Optional<JointMaskEntry> getJointMaskEntry(LivingEntityPatch<?> entitypatch, boolean useCurrentMotion) {
        return entitypatch.isLogicalClient() && entitypatch.getClientAnimator().getPriorityFor((AssetAccessor)this.getAccessor()) == Layer.Priority.HIGHEST ? Optional.of(JointMaskEntry.BASIC_ATTACK_MASK) : super.getJointMaskEntry(entitypatch, useCurrentMotion);
    }
}

