/*
 * Decompiled with CFR 0.152.
 */
package net.corruptdog.cdm.api.animation.types;

import java.util.Objects;
import net.corruptdog.cdm.api.animation.types.property.Properties;
import net.corruptdog.cdm.api.animation.types.property.RenderEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StateSpectrum;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.gamerule.EpicFightGameRules;

public class ExecuteAnimation
extends AttackAnimation {
    protected final StateSpectrum.Blueprint stateUtilsBlueprint = new StateSpectrum.Blueprint();
    private boolean wasLockOn = false;

    public ExecuteAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends ExecuteAnimation> accessor, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(transitionTime, accessor, armature, phases);
        this.stateUtilsBlueprint.clear();
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT, true);
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, false);
    }

    protected void bindPhaseState(AttackAnimation.Phase phase) {
        float preDelay = phase.preDelay;
        this.stateSpectrumBlueprint.newTimePair(phase.contact, phase.end).addState(EntityState.LOCKON_ROTATE, (Object)true).addState(EntityState.CAN_SKILL_EXECUTION, (Object)false).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).addState(EntityState.HURT_LEVEL, (Object)2).newTimePair(phase.start, preDelay).addState(EntityState.PHASE_LEVEL, (Object)1).newTimePair(phase.start, phase.end + 1.0f).addState(EntityState.LOCKON_ROTATE, (Object)true).addState(EntityState.MOVEMENT_LOCKED, (Object)true).addState(EntityState.UPDATE_LIVING_MOTION, (Object)false).newTimePair(phase.start, phase.end).addState(EntityState.INACTION, (Object)true).addState(EntityState.CAN_BASIC_ATTACK, (Object)false).addState(EntityState.MOVEMENT_LOCKED, (Object)true).newTimePair(preDelay, phase.contact + 0.01f).addState(EntityState.ATTACKING, (Object)true).addState(EntityState.PHASE_LEVEL, (Object)2).newTimePair(phase.contact + 0.01f, phase.end).addState(EntityState.PHASE_LEVEL, (Object)3).newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.INACTION, (Object)true).addState(EntityState.ATTACK_RESULT, damagesource -> !damagesource.m_269533_(DamageTypeTags.f_268738_) ? AttackResult.ResultType.MISSED : AttackResult.ResultType.SUCCESS);
    }

    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        if (entitypatch.isLogicalClient() && this.getProperty((AnimationProperty)Properties.MOVE_ROOT_PHASE).isEmpty() && entitypatch instanceof LocalPlayerPatch) {
            LocalPlayerPatch localPlayerPatch = (LocalPlayerPatch)entitypatch;
            this.wasLockOn = localPlayerPatch.isTargetLockedOn();
            localPlayerPatch.setLockOn(true);
        }
    }

    public void modifyPose(DynamicAnimation animation, Pose pose, LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        AnimationProperty.PoseModifier modifier;
        if (this.getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.COORD).isEmpty()) {
            JointTransform jt = pose.get("Root");
            Vec3f jointPosition = jt.translation();
            OpenMatrix4f toRootTransformApplied = entitypatch.getArmature().searchJointByName("Root").getLocalTransform().removeTranslation();
            OpenMatrix4f toOrigin = OpenMatrix4f.invert((OpenMatrix4f)toRootTransformApplied, null);
            Vec3f worldPosition = OpenMatrix4f.transform3v((OpenMatrix4f)toRootTransformApplied, (Vec3f)jointPosition, null);
            if (!this.getProperty((AnimationProperty)Properties.MOVE_ROOT_PHASE).isPresent() || !((Properties.SpecialPhase)this.getProperty((AnimationProperty)Properties.MOVE_ROOT_PHASE).get()).isInPhase(time)) {
                worldPosition.x = 0.0f;
                worldPosition.y = this.getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(false) != false && worldPosition.y > 0.0f ? 0.0f : worldPosition.y;
                worldPosition.z = 0.0f;
            }
            OpenMatrix4f.transform3v((OpenMatrix4f)toOrigin, (Vec3f)worldPosition, (Vec3f)worldPosition);
            jointPosition.x = worldPosition.x;
            jointPosition.y = worldPosition.y;
            jointPosition.z = worldPosition.z;
        }
        if ((modifier = (AnimationProperty.PoseModifier)this.getProperty((AnimationProperty)AnimationProperty.StaticAnimationProperty.POSE_MODIFIER).orElse(null)) != null) {
            modifier.modify(animation, pose, entitypatch, time, partialTicks);
        }
    }

    public void tick(LivingEntityPatch<?> entitypatch) {
        LocalPlayerPatch localPlayerPatch;
        if (entitypatch.isLogicalClient() && this.getProperty((AnimationProperty)Properties.MOVE_ROOT_PHASE).isEmpty() && entitypatch instanceof LocalPlayerPatch) {
            localPlayerPatch = (LocalPlayerPatch)entitypatch;
            localPlayerPatch.setLockOn(false);
        }
        if (entitypatch.isLogicalClient() && entitypatch instanceof LocalPlayerPatch) {
            localPlayerPatch = (LocalPlayerPatch)entitypatch;
            localPlayerPatch.setLockOn(this.wasLockOn);
        }
        super.tick(entitypatch);
        if (entitypatch.isLogicalClient() && this.getProperty((AnimationProperty)Properties.INVISIBLE_PHASE).isPresent()) {
            if (((Properties.SpecialPhase)this.getProperty((AnimationProperty)Properties.INVISIBLE_PHASE).get()).isInPhase(Objects.requireNonNull(entitypatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor())).getElapsedTime())) {
                RenderEvents.HiddenEntity((LivingEntity)entitypatch.getOriginal(), 10);
            } else {
                RenderEvents.UnhiddenEntity((LivingEntity)entitypatch.getOriginal());
            }
        }
    }

    protected Vec3 getCoordVector(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> dynamicAnimation) {
        Vec3 vec3 = super.getCoordVector(entitypatch, dynamicAnimation);
        float t = Objects.requireNonNull(entitypatch.getAnimator().getPlayerFor(dynamicAnimation)).getElapsedTime();
        if (this.getProperty((AnimationProperty)Properties.MOVE_ROOT_PHASE).isPresent() && ((Properties.SpecialPhase)this.getProperty((AnimationProperty)Properties.MOVE_ROOT_PHASE).get()).isInPhase(t)) {
            vec3 = vec3.m_82542_(0.0, 0.0, 0.0);
        }
        return vec3;
    }

    public void end(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        if (entitypatch.isLogicalClient() && entitypatch instanceof LocalPlayerPatch) {
            LocalPlayerPatch localPlayerPatch = (LocalPlayerPatch)entitypatch;
            localPlayerPatch.setLockOn(this.wasLockOn);
        }
        boolean stiffAttack = (Boolean)EpicFightGameRules.STIFF_COMBO_ATTACKS.getRuleValue(((LivingEntity)entitypatch.getOriginal()).m_9236_());
        if (!isEnd && !((DynamicAnimation)nextAnimation.get()).isMainFrameAnimation() && entitypatch.isLogicalClient() && !stiffAttack) {
            float playbackSpeed = 0.05f * this.getPlaySpeed(entitypatch, (DynamicAnimation)this);
            entitypatch.getClientAnimator().baseLayer.copyLayerTo(entitypatch.getClientAnimator().baseLayer.getLayer(Layer.Priority.HIGHEST), playbackSpeed);
        }
    }
}

